/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.Type;

public class JarApplicationReader {
    public final InternalOptions options;
    ConcurrentHashMap<String, DexString> stringCache = new ConcurrentHashMap();

    public JarApplicationReader(InternalOptions options) {
        this.options = options;
    }

    public DexItemFactory getFactory() {
        return this.options.itemFactory;
    }

    public DexString getString(String string) {
        return this.stringCache.computeIfAbsent(string, this.options.itemFactory::createString);
    }

    public DexType getType(Type type) {
        return this.getTypeFromDescriptor(type.getDescriptor());
    }

    public DexType getTypeFromName(String name) {
        assert (this.isValidInternalName(name));
        return this.getType(Type.getObjectType((String)name));
    }

    public DexType getTypeFromDescriptor(String desc) {
        assert (this.isValidDescriptor(desc));
        return this.options.itemFactory.createType(this.getString(desc));
    }

    public DexTypeList getTypeListFromNames(String[] names) {
        if (names.length == 0) {
            return DexTypeList.empty();
        }
        DexType[] types = new DexType[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = this.getTypeFromName(names[i]);
        }
        return new DexTypeList(types);
    }

    public DexTypeList getTypeListFromDescriptors(String[] descriptors) {
        if (descriptors.length == 0) {
            return DexTypeList.empty();
        }
        DexType[] types = new DexType[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            types[i] = this.getTypeFromDescriptor(descriptors[i]);
        }
        return new DexTypeList(types);
    }

    public DexField getField(String owner, String name, String desc) {
        return this.getField(this.getTypeFromName(owner), name, desc);
    }

    public DexField getField(DexType owner, String name, String desc) {
        return this.options.itemFactory.createField(owner, this.getTypeFromDescriptor(desc), this.getString(name));
    }

    public DexMethod getMethod(String owner, String name, String desc) {
        return this.getMethod(this.getTypeFromName(owner), name, desc);
    }

    public DexMethod getMethod(DexType owner, String name, String desc) {
        return this.options.itemFactory.createMethod(owner, this.getProto(desc), this.getString(name));
    }

    public DexCallSite getCallSite(String methodName, String methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs) {
        return this.options.itemFactory.createCallSite(this.getString(methodName), this.getProto(methodProto), bootstrapMethod, bootstrapArgs);
    }

    public DexMethodHandle getMethodHandle(DexMethodHandle.MethodHandleType type, Descriptor<? extends DexItem, ? extends Descriptor> fieldOrMethod) {
        return this.options.itemFactory.createMethodHandle(type, fieldOrMethod);
    }

    public DexProto getProto(String desc) {
        assert (this.isValidDescriptor(desc));
        Type returnType = Type.getReturnType((String)desc);
        Type[] arguments = Type.getArgumentTypes((String)desc);
        StringBuilder shortyDescriptor = new StringBuilder();
        String[] argumentDescriptors = new String[arguments.length];
        shortyDescriptor.append(JarApplicationReader.getShortyDescriptor(returnType));
        for (int i = 0; i < arguments.length; ++i) {
            shortyDescriptor.append(JarApplicationReader.getShortyDescriptor(arguments[i]));
            argumentDescriptors[i] = arguments[i].getDescriptor();
        }
        DexProto proto = this.options.itemFactory.createProto(this.getString(shortyDescriptor.toString()), this.getTypeFromDescriptor(returnType.getDescriptor()), this.getTypeListFromDescriptors(argumentDescriptors));
        return proto;
    }

    private static String getShortyDescriptor(Type type) {
        switch (type.getSort()) {
            case 11: {
                throw new InternalCompilerError("Cannot produce a shorty decriptor for methods");
            }
            case 9: 
            case 10: {
                return "L";
            }
        }
        return type.getDescriptor();
    }

    private boolean isValidDescriptor(String desc) {
        return Type.getType((String)desc).getDescriptor().equals(desc);
    }

    private boolean isValidInternalName(String name) {
        return Type.getObjectType((String)name).getInternalName().equals(name);
    }
}

