/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Aget;
import com.android.tools.r8.code.AgetBoolean;
import com.android.tools.r8.code.AgetByte;
import com.android.tools.r8.code.AgetChar;
import com.android.tools.r8.code.AgetObject;
import com.android.tools.r8.code.AgetShort;
import com.android.tools.r8.code.AgetWide;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.Arrays;

public class ArrayGet
extends Instruction {
    private final MemberType type;

    public ArrayGet(MemberType type, Value dest, Value array, Value index) {
        super(dest, Arrays.asList(array, index));
        this.type = type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    public Value index() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case SINGLE: {
                instruction = new Aget(dest, array, index);
                break;
            }
            case WIDE: {
                instruction = new AgetWide(dest, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AgetObject(dest, array, index);
                break;
            }
            case BOOLEAN: {
                instruction = new AgetBoolean(dest, array, index);
                break;
            }
            case BYTE: {
                instruction = new AgetByte(dest, array, index);
                break;
            }
            case CHAR: {
                instruction = new AgetChar(dest, array, index);
                break;
            }
            case SHORT: {
                instruction = new AgetShort(dest, array, index);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        return false;
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return other.asArrayGet().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asArrayGet().type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isArrayGet() {
        return true;
    }

    @Override
    public ArrayGet asArrayGet() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.ALWAYS;
    }
}

