/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Const;
import com.android.tools.r8.code.Const16;
import com.android.tools.r8.code.Const4;
import com.android.tools.r8.code.ConstHigh16;
import com.android.tools.r8.code.ConstWide;
import com.android.tools.r8.code.ConstWide16;
import com.android.tools.r8.code.ConstWide32;
import com.android.tools.r8.code.ConstWideHigh16;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.NumberUtils;

public class ConstNumber
extends ConstInstruction {
    public final ConstType type;
    private final long value;

    public ConstNumber(ConstType type, Value dest, long value) {
        super(dest);
        assert (dest.isFixedRegisterValue() || dest.definition.isConstNumber());
        this.type = type;
        this.value = value;
    }

    public static ConstNumber copyOf(IRCode code, ConstNumber original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outType(), original.getDebugInfo());
        return new ConstNumber(original.type, newValue, original.getRawValue());
    }

    private boolean preciseTypeUnknown() {
        return this.type == ConstType.INT_OR_FLOAT || this.type == ConstType.LONG_OR_DOUBLE;
    }

    public Value dest() {
        return this.outValue;
    }

    public boolean getBooleanValue() {
        return !this.isZero();
    }

    public int getIntValue() {
        assert (this.type == ConstType.INT || this.type == ConstType.INT_OR_FLOAT || this.type == ConstType.OBJECT);
        return (int)this.value;
    }

    public long getLongValue() {
        assert (this.type == ConstType.LONG || this.type == ConstType.LONG_OR_DOUBLE);
        return this.value;
    }

    public float getFloatValue() {
        assert (this.type == ConstType.FLOAT || this.type == ConstType.INT_OR_FLOAT);
        return Float.intBitsToFloat((int)this.value);
    }

    public double getDoubleValue() {
        assert (this.type == ConstType.DOUBLE || this.type == ConstType.LONG_OR_DOUBLE);
        return Double.longBitsToDouble(this.value);
    }

    public long getRawValue() {
        return this.value;
    }

    public boolean isZero() {
        return this.value == 0L;
    }

    public boolean isIntegerNegativeOne(NumericType type) {
        assert (type == NumericType.INT || type == NumericType.LONG);
        if (type == NumericType.INT) {
            return this.getIntValue() == -1;
        }
        return this.getLongValue() == -1L;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        if (!this.dest().needsRegister()) {
            builder.addNop(this);
            return;
        }
        int register = builder.allocatedRegister(this.dest(), this.getNumber());
        if (MoveType.fromConstType(this.type) == MoveType.SINGLE || this.type == ConstType.OBJECT) {
            assert (NumberUtils.is32Bit(this.value));
            if ((register & 0xF) == register && NumberUtils.is4Bit(this.value)) {
                builder.add((Instruction)this, new Const4(register, (int)this.value));
            } else if (NumberUtils.is16Bit(this.value)) {
                builder.add((Instruction)this, new Const16(register, (int)this.value));
            } else if ((this.value & 0xFFFFL) == 0L) {
                builder.add((Instruction)this, new ConstHigh16(register, (int)this.value >>> 16));
            } else {
                builder.add((Instruction)this, new Const(register, (int)this.value));
            }
        } else {
            assert (MoveType.fromConstType(this.type) == MoveType.WIDE);
            if (NumberUtils.is16Bit(this.value)) {
                builder.add((Instruction)this, new ConstWide16(register, (int)this.value));
            } else if ((this.value & 0xFFFFFFFFFFFFL) == 0L) {
                builder.add((Instruction)this, new ConstWideHigh16(register, (int)(this.value >>> 48)));
            } else if (NumberUtils.is32Bit(this.value)) {
                builder.add((Instruction)this, new ConstWide32(register, (int)this.value));
            } else {
                builder.add((Instruction)this, new ConstWide(register, this.value));
            }
        }
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "Const has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.value + " (" + (Object)((Object)this.type) + ")";
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        if (this.preciseTypeUnknown()) {
            return false;
        }
        ConstNumber o = other.asConstNumber();
        return o.type == this.type && o.value == this.value;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        ConstNumber o = other.asConstNumber();
        int result = this.type.ordinal() - o.type.ordinal();
        if (result != 0) {
            return result;
        }
        return Long.signum(this.value - o.value);
    }

    public boolean is8Bit() {
        return NumberUtils.is8Bit(this.value);
    }

    public boolean negativeIs8Bit() {
        return NumberUtils.negativeIs8Bit(this.value);
    }

    public boolean is16Bit() {
        return NumberUtils.is16Bit(this.value);
    }

    public boolean negativeIs16Bit() {
        return NumberUtils.negativeIs16Bit(this.value);
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstNumber() {
        return true;
    }

    @Override
    public ConstNumber asConstNumber() {
        return this;
    }
}

