/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCodeInstructionsIterator;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.utils.CfgPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class IRCode {
    public final DexEncodedMethod method;
    public LinkedList<BasicBlock> blocks;
    public final ValueNumberGenerator valueNumberGenerator;
    private BasicBlock normalExitBlock;
    private boolean numbered = false;
    private int nextInstructionNumber = 0;

    public IRCode(DexEncodedMethod method, LinkedList<BasicBlock> blocks, BasicBlock normalExitBlock, ValueNumberGenerator valueNumberGenerator) {
        this.method = method;
        this.blocks = blocks;
        this.normalExitBlock = normalExitBlock;
        this.valueNumberGenerator = valueNumberGenerator;
    }

    private void ensureBlockNumbering() {
        if (!this.numbered) {
            this.numbered = true;
            BasicBlock[] sorted = this.topologicallySortedBlocks();
            for (int i = 0; i < sorted.length; ++i) {
                sorted[i].setNumber(i);
            }
        }
    }

    public String toString() {
        this.ensureBlockNumbering();
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public void clearMarks() {
        for (BasicBlock block : this.blocks) {
            block.clearMark();
        }
    }

    public void removeMarkedBlocks() {
        ListIterator<BasicBlock> blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!block.isMarked()) continue;
            blockIterator.remove();
            if (block != this.normalExitBlock) continue;
            this.normalExitBlock = null;
        }
    }

    public void removeBlocks(List<BasicBlock> blocksToRemove) {
        this.blocks.removeAll(blocksToRemove);
        if (blocksToRemove.contains(this.normalExitBlock)) {
            this.normalExitBlock = null;
        }
    }

    public BasicBlock[] topologicallySortedBlocks() {
        return this.topologicallySortedBlocks(Collections.emptyList());
    }

    public BasicBlock[] topologicallySortedBlocks(List<BasicBlock> blocksToIgnore) {
        this.clearMarks();
        int reachableBlocks = this.blocks.size() - blocksToIgnore.size();
        BasicBlock[] sorted = new BasicBlock[reachableBlocks];
        BasicBlock entryBlock = this.blocks.getFirst();
        int index = this.depthFirstSorting(entryBlock, sorted, reachableBlocks - 1);
        assert (index == -1);
        return sorted;
    }

    private int depthFirstSorting(BasicBlock block, BasicBlock[] sorted, int index) {
        if (!block.isMarked()) {
            block.mark();
            for (BasicBlock succ : block.getSuccessors()) {
                index = this.depthFirstSorting(succ, sorted, index);
            }
            assert (sorted[index] == null);
            sorted[index] = block;
            return index - 1;
        }
        return index;
    }

    public void print(CfgPrinter printer) {
        this.ensureBlockNumbering();
        for (BasicBlock block : this.blocks) {
            block.print(printer);
        }
    }

    public boolean isConsistentSSA() {
        assert (this.isConsistentGraph() && this.consistentDefUseChains() && this.validThrowingInstructions());
        return true;
    }

    public boolean isConsistentGraph() {
        assert (this.consistentBlockNumbering());
        assert (this.consistentPredecessorSuccessors());
        assert (this.consistentCatchHandlers());
        assert (this.consistentBlockInstructions());
        assert (this.normalExitBlock == null || this.normalExitBlock.exit().isReturn());
        return true;
    }

    private boolean consistentDefUseChains() {
        HashSet<Value> values = new HashSet<Value>();
        for (BasicBlock block : this.blocks) {
            int predecessorCount = block.getPredecessors().size();
            for (Phi phi : block.getPhis()) {
                assert (phi.getOperands().size() == predecessorCount);
                values.add(phi);
                for (Value value : phi.getOperands()) {
                    values.add(value);
                    if (value.isPhi()) {
                        Phi phiOperand = value.asPhi();
                        assert (phiOperand.getBlock().getPhis().contains(phiOperand));
                        assert (phiOperand.uniquePhiUsers().contains(phi));
                        continue;
                    }
                    Instruction definition = value.definition;
                    assert (definition.outValue() == value);
                }
            }
            for (Instruction instruction : block.getInstructions()) {
                assert (instruction.getBlock() == block);
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    values.add(outValue);
                    assert (outValue.definition == instruction);
                    Value previousLocalValue = outValue.getPreviousLocalValue();
                    if (previousLocalValue != null) {
                        values.add(previousLocalValue);
                        assert (previousLocalValue.debugUsers().contains(instruction));
                    }
                }
                for (Value value : instruction.inValues()) {
                    values.add(value);
                    assert (value.uniqueUsers().contains(instruction));
                    if (value.isPhi()) {
                        Phi phi = value.asPhi();
                        assert (phi.getBlock().getPhis().contains(phi));
                        continue;
                    }
                    Instruction definition = value.definition;
                    assert (definition.outValue() == value);
                }
            }
        }
        for (Value value : values) {
            assert (this.consistentValueUses(value));
        }
        return true;
    }

    private boolean consistentValueUses(Value value) {
        for (Instruction user : value.uniqueUsers()) {
            assert (user.inValues().contains(value));
        }
        for (Phi phiUser : value.uniquePhiUsers()) {
            assert (phiUser.getOperands().contains(value));
            assert (phiUser.getBlock().getPhis().contains(phiUser));
        }
        if (value.debugUsers() != null) {
            for (Instruction debugUser : value.debugUsers()) {
                assert (debugUser.getPreviousLocalValue() == value || debugUser.getDebugValues().contains(value));
            }
        }
        return true;
    }

    private boolean consistentPredecessorSuccessors() {
        for (BasicBlock block : this.blocks) {
            assert (new HashSet<BasicBlock>(block.getSuccessors()).size() == block.getSuccessors().size());
            for (BasicBlock succ : block.getSuccessors()) {
                assert (this.blocks.contains(succ));
                assert (succ.getPredecessors().contains(block));
            }
            assert (new HashSet<BasicBlock>(block.getPredecessors()).size() == block.getPredecessors().size());
            for (BasicBlock pred : block.getPredecessors()) {
                assert (this.blocks.contains(pred));
                assert (pred.getSuccessors().contains(block));
            }
        }
        return true;
    }

    private boolean consistentCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            assert (block.exit().isGoto() || block.exit().isThrow());
            CatchHandlers<Integer> catchHandlers = block.getCatchHandlersWithSuccessorIndexes();
            List<DexType> guards = catchHandlers.getGuards();
            int lastGuardIndex = guards.size() - 1;
            for (int i = 0; i < guards.size(); ++i) {
                assert (guards.get(i) != DexItemFactory.catchAllType || i == lastGuardIndex);
            }
            ArrayList<Integer> sortedHandlerIndices = new ArrayList<Integer>(catchHandlers.getAllTargets());
            sortedHandlerIndices.sort(Comparator.naturalOrder());
            int firstIndex = (Integer)sortedHandlerIndices.get(0);
            int lastIndex = (Integer)sortedHandlerIndices.get(sortedHandlerIndices.size() - 1);
            assert (firstIndex == 0);
            assert (lastIndex < sortedHandlerIndices.size());
            int lastSuccessorIndex = block.getSuccessors().size() - 1;
            assert (lastIndex == lastSuccessorIndex || lastIndex == lastSuccessorIndex - 1);
            assert (lastIndex == lastSuccessorIndex || !block.exit().isThrow());
        }
        return true;
    }

    public boolean consistentBlockNumbering() {
        return this.blocks.stream().collect(Collectors.groupingBy(BasicBlock::getNumber, Collectors.counting())).entrySet().stream().noneMatch(bb2count -> (Long)bb2count.getValue() > 1L);
    }

    private boolean consistentBlockInstructions() {
        for (BasicBlock block : this.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                assert (instruction.getBlock() == block);
            }
        }
        return true;
    }

    private boolean validThrowingInstructions() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            boolean seenThrowing = false;
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.instructionTypeCanThrow()) {
                    assert (!seenThrowing);
                    seenThrowing = true;
                    continue;
                }
                if (seenThrowing) assert (instruction.isDebugInstruction() || instruction.isJumpInstruction() || instruction.isConstInstruction() || instruction.isNewArrayFilledData());
            }
        }
        return true;
    }

    public InstructionIterator instructionIterator() {
        return new IRCodeInstructionsIterator(this);
    }

    void setNormalExitBlock(BasicBlock block) {
        this.normalExitBlock = block;
    }

    public BasicBlock getNormalExitBlock() {
        return this.normalExitBlock;
    }

    public ListIterator<BasicBlock> listIterator() {
        return new BasicBlockIterator(this);
    }

    public ListIterator<BasicBlock> listIterator(int index) {
        return new BasicBlockIterator(this, index);
    }

    public BasicBlock[] numberInstructions() {
        BasicBlock[] blocks;
        for (BasicBlock block : blocks = this.topologicallySortedBlocks()) {
            for (Instruction instruction : block.getInstructions()) {
                instruction.setNumber(this.nextInstructionNumber);
                this.nextInstructionNumber += 2;
            }
        }
        return blocks;
    }

    public int numberRemainingInstructions() {
        InstructionIterator it = this.instructionIterator();
        while (it.hasNext()) {
            Instruction i = (Instruction)it.next();
            if (i.getNumber() != -1) continue;
            i.setNumber(this.nextInstructionNumber);
            this.nextInstructionNumber += 2;
        }
        return this.nextInstructionNumber;
    }

    public int getNextInstructionNumber() {
        return this.nextInstructionNumber;
    }

    public List<Value> collectArguments() {
        ArrayList<Value> arguments = new ArrayList<Value>();
        InstructionIterator iterator = this.blocks.get(0).iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (!instruction.isArgument()) continue;
            arguments.add(instruction.asArgument().outValue());
        }
        assert (arguments.size() == this.method.method.getArity() + (this.method.accessFlags.isStatic() ? 0 : 1));
        return arguments;
    }

    public Value createValue(MoveType moveType, Value.DebugInfo debugInfo) {
        return new Value(this.valueNumberGenerator.next(), moveType, debugInfo);
    }

    public Value createValue(MoveType moveType) {
        return this.createValue(moveType, null);
    }

    public ConstNumber createIntConstant(int value) {
        return new ConstNumber(ConstType.INT, this.createValue(MoveType.SINGLE), value);
    }

    public ConstNumber createTrue() {
        return new ConstNumber(ConstType.INT, this.createValue(MoveType.SINGLE), 1L);
    }

    public ConstNumber createFalse() {
        return new ConstNumber(ConstType.INT, this.createValue(MoveType.SINGLE), 0L);
    }

    public final int getHighestBlockNumber() {
        return this.blocks.stream().max(Comparator.comparingInt(BasicBlock::getNumber)).get().getNumber();
    }

    public Instruction createConstNull(Instruction from) {
        Value newValue = this.createValue(from.outType());
        return new ConstNumber(ConstType.fromMoveType(from.outType()), newValue, 0L);
    }
}

