/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.ReturnObject;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.code.ReturnWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;

public class Return
extends JumpInstruction {
    private final MoveType returnType;

    public Return() {
        super(null);
        this.returnType = null;
    }

    public Return(Value value, MoveType returnType) {
        super(null, value);
        this.returnType = returnType;
    }

    public boolean isReturnVoid() {
        return this.inValues.size() == 0;
    }

    public MoveType getReturnType() {
        return this.returnType;
    }

    public Value returnValue() {
        assert (!this.isReturnVoid());
        return (Value)this.inValues.get(0);
    }

    public com.android.tools.r8.code.Instruction createDexInstruction(DexBuilder builder) {
        if (this.isReturnVoid()) {
            return new ReturnVoid();
        }
        switch (this.returnValue().type) {
            case OBJECT: {
                assert (this.returnType == MoveType.OBJECT);
                return new ReturnObject(builder.allocatedRegister(this.returnValue(), this.getNumber()));
            }
            case SINGLE: {
                if (this.returnType == MoveType.OBJECT) {
                    return new ReturnObject(builder.allocatedRegister(this.returnValue(), this.getNumber()));
                }
                assert (this.returnType == MoveType.SINGLE);
                return new com.android.tools.r8.code.Return(builder.allocatedRegister(this.returnValue(), this.getNumber()));
            }
            case WIDE: {
                assert (this.returnType == MoveType.WIDE);
                return new ReturnWide(builder.allocatedRegister(this.returnValue(), this.getNumber()));
            }
        }
        throw new Unreachable();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.add((Instruction)this, this.createDexInstruction(builder));
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        if (this.isReturnVoid()) {
            return other.asReturn().isReturnVoid();
        }
        return other.asReturn().returnValue().type == this.returnValue().type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        if (this.isReturnVoid()) {
            return other.asReturn().isReturnVoid() ? 0 : -1;
        }
        return this.returnValue().type.ordinal() - other.asReturn().returnValue().type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Return defines no values.";
        return 0;
    }

    @Override
    public boolean isReturn() {
        return true;
    }

    @Override
    public Return asReturn() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.ALWAYS;
    }
}

