/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Nop;
import com.android.tools.r8.code.PackedSwitch;
import com.android.tools.r8.code.PackedSwitchPayload;
import com.android.tools.r8.code.SparseSwitch;
import com.android.tools.r8.code.SparseSwitchPayload;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.CfgPrinter;

public class Switch
extends JumpInstruction {
    private final int[] keys;
    private final int[] targetBlockIndices;
    private int fallthroughBlockIndex;

    public Switch(Value value, int[] keys, int[] targetBlockIndices, int fallthroughBlockIndex) {
        super(null, value);
        this.keys = keys;
        this.targetBlockIndices = targetBlockIndices;
        this.fallthroughBlockIndex = fallthroughBlockIndex;
        assert (this.valid());
    }

    private boolean valid() {
        assert (this.keys.length <= 65535);
        assert (this.keys.length == this.targetBlockIndices.length);
        for (int i = 1; i < this.keys.length - 1; ++i) {
            assert (this.keys[i - 1] < this.keys[i]);
            assert (this.targetBlockIndices[i] != this.fallthroughBlockIndex);
        }
        assert (this.targetBlockIndices[this.keys.length - 1] != this.fallthroughBlockIndex);
        return true;
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    private long numberOfTargetsIfPacked() {
        return (long)this.keys[this.keys.length - 1] - (long)this.keys[0] + 1L;
    }

    private boolean canBePacked() {
        return this.numberOfTargetsIfPacked() <= 65535L;
    }

    private int numberOfTargetsForPacked() {
        assert (this.canBePacked());
        return (int)this.numberOfTargetsIfPacked();
    }

    private long packedPayloadSize() {
        return this.numberOfTargetsForPacked() * 2 + 4;
    }

    private long sparsePayloadSize() {
        return this.keys.length * 4 + 2;
    }

    private boolean emitPacked() {
        return this.canBePacked() && this.packedPayloadSize() <= this.sparsePayloadSize();
    }

    public int getFirstKey() {
        return this.keys[0];
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public Switch asSwitch() {
        return this;
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        assert (other.isSwitch());
        return false;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isSwitch());
        return 0;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        if (this.emitPacked()) {
            builder.addSwitch(this, new PackedSwitch(value));
        } else {
            builder.addSwitch(this, new SparseSwitch(value));
        }
    }

    public int numberOfKeys() {
        return this.keys.length;
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public int[] targetBlockIndices() {
        return this.targetBlockIndices;
    }

    @Override
    public BasicBlock fallthroughBlock() {
        return this.getBlock().getSuccessors().get(this.fallthroughBlockIndex);
    }

    public int getFallthroughBlockIndex() {
        return this.fallthroughBlockIndex;
    }

    public void setFallthroughBlockIndex(int i) {
        this.fallthroughBlockIndex = i;
    }

    public BasicBlock targetBlock(int index) {
        return this.getBlock().getSuccessors().get(this.targetBlockIndices()[index]);
    }

    @Override
    public void setFallthroughBlock(BasicBlock block) {
        this.getBlock().getSuccessors().set(this.fallthroughBlockIndex, block);
    }

    public Nop buildPayload(int[] targets, int fallthroughTarget) {
        assert (this.keys.length == targets.length);
        if (this.emitPacked()) {
            int targetsCount = this.numberOfTargetsForPacked();
            if (targets.length == targetsCount) {
                return new PackedSwitchPayload(this.getFirstKey(), targets);
            }
            int[] packedTargets = new int[targetsCount];
            int originalIndex = 0;
            for (int i = 0; i < targetsCount; ++i) {
                int key = this.getFirstKey() + i;
                if (this.keys[originalIndex] == key) {
                    packedTargets[i] = targets[originalIndex];
                    ++originalIndex;
                    continue;
                }
                packedTargets[i] = fallthroughTarget;
            }
            assert (originalIndex == this.keys.length);
            return new PackedSwitchPayload(this.getFirstKey(), packedTargets);
        }
        assert (this.numberOfKeys() == this.keys.length);
        return new SparseSwitchPayload(this.keys, targets);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString() + "\n");
        for (int i = 0; i < this.numberOfKeys(); ++i) {
            builder.append("          ");
            builder.append(" -> ");
            builder.append(this.targetBlock(i).getNumber());
            builder.append("\n");
        }
        builder.append("          F -> ");
        builder.append(this.fallthroughBlock().getNumber());
        return builder.toString();
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        for (int index : this.targetBlockIndices) {
            BasicBlock target = this.getBlock().getSuccessors().get(index);
            printer.append(" B").append(target.getNumber());
        }
    }
}

