/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CallGraph {
    private final Map<DexEncodedMethod, Node> nodes = new LinkedHashMap<DexEncodedMethod, Node>();
    private final Map<DexEncodedMethod, Set<DexEncodedMethod>> breakers = new HashMap<DexEncodedMethod, Set<DexEncodedMethod>>();
    private final Function<List<DexEncodedMethod>, List<DexEncodedMethod>> shuffle;
    private Set<DexEncodedMethod> singleCallSite = Sets.newIdentityHashSet();
    private Set<DexEncodedMethod> doubleCallSite = Sets.newIdentityHashSet();

    private CallGraph(InternalOptions options) {
        this.shuffle = options.testing.irOrdering;
    }

    public boolean isBreaker(DexEncodedMethod method, DexEncodedMethod callee) {
        Set<DexEncodedMethod> value = this.breakers.get(method);
        return value != null && value.contains(callee);
    }

    public static CallGraph build(DexApplication application, AppInfoWithSubtyping appInfo, GraphLense graphLense, InternalOptions options) {
        CallGraph graph = new CallGraph(options);
        DexClass[] classes = application.classes().toArray(new DexClass[application.classes().size()]);
        Arrays.sort(classes, (a, b) -> a.type.slowCompareTo(b.type));
        for (DexClass clazz : classes) {
            for (DexEncodedMethod method : clazz.allMethodsSorted()) {
                Node node = graph.ensureMethodNode(method);
                InvokeExtractor extractor = new InvokeExtractor(appInfo, graphLense, node, graph);
                method.registerReachableDefinitions(extractor);
            }
        }
        assert (CallGraph.allMethodsExists(application, graph));
        graph.breakCycles();
        assert (graph.breakCycles() == 0);
        graph.fillCallSiteSets(appInfo);
        return graph;
    }

    public boolean hasSingleCallSite(DexEncodedMethod method) {
        return this.singleCallSite.contains(method);
    }

    public boolean hasDoubleCallSite(DexEncodedMethod method) {
        return this.doubleCallSite.contains(method);
    }

    private void fillCallSiteSets(AppInfoWithSubtyping appInfo) {
        assert (this.singleCallSite.isEmpty());
        Enqueuer.AppInfoWithLiveness liveAppInfo = appInfo.withLiveness();
        if (liveAppInfo == null) {
            return;
        }
        for (Node value : this.nodes.values()) {
            if (appInfo.withLiveness().pinnedItems.contains(value.method)) continue;
            if (value.invokeCount == 1) {
                this.singleCallSite.add(value.method);
                continue;
            }
            if (value.invokeCount != 2) continue;
            this.doubleCallSite.add(value.method);
        }
    }

    private static boolean allMethodsExists(DexApplication application, CallGraph graph) {
        for (DexProgramClass clazz : application.classes()) {
            clazz.forEachMethod(method -> {
                assert (graph.nodes.get(method) != null);
            });
        }
        return true;
    }

    private List<DexEncodedMethod> extractLeaves() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        List<Node> leaves = this.nodes.values().stream().filter(Node::isLeaf).collect(Collectors.toList());
        leaves.forEach(leaf -> {
            ((Node)leaf).callers.forEach(caller -> ((Node)caller).callees.remove(leaf));
            this.nodes.remove(leaf.method);
        });
        return this.shuffle.apply(leaves.stream().map(leaf -> leaf.method).collect(Collectors.toList()));
    }

    private int traverse(Node node, Set<Node> stack, Set<Node> marked) {
        int numberOfCycles = 0;
        if (!marked.contains(node)) {
            assert (!stack.contains(node));
            stack.add(node);
            ArrayList<Node> toBeRemoved = null;
            Node[] callees = node.callees.toArray(new Node[node.callees.size()]);
            Arrays.sort(callees, (a, b) -> a.method.method.slowCompareTo(b.method.method));
            for (Node callee : callees) {
                if (stack.contains(callee)) {
                    if (toBeRemoved == null) {
                        toBeRemoved = new ArrayList<Node>();
                    }
                    toBeRemoved.add(callee);
                    callee.callers.remove(node);
                    this.breakers.computeIfAbsent(node.method, ignore -> Sets.newIdentityHashSet()).add(callee.method);
                    continue;
                }
                numberOfCycles += this.traverse(callee, stack, marked);
            }
            if (toBeRemoved != null) {
                numberOfCycles += toBeRemoved.size();
                node.callees.removeAll(toBeRemoved);
            }
            stack.remove(node);
            marked.add(node);
        }
        return numberOfCycles;
    }

    private int breakCycles() {
        int numberOfCycles = 0;
        Set stack = Sets.newIdentityHashSet();
        Set marked = Sets.newIdentityHashSet();
        for (Node node : this.nodes.values()) {
            numberOfCycles += this.traverse(node, stack, marked);
        }
        return numberOfCycles;
    }

    private synchronized Node ensureMethodNode(DexEncodedMethod method) {
        return this.nodes.computeIfAbsent(method, k -> new Node(method));
    }

    private synchronized void addCall(Node caller, Node callee) {
        assert (caller != null);
        assert (callee != null);
        if (caller != callee) {
            caller.addCallee(callee);
            callee.addCaller(caller);
        } else {
            caller.isSelfRecursive = true;
        }
        callee.invokeCount++;
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    public void forEachMethod(Consumer<DexEncodedMethod> consumer, ExecutorService executorService) throws ExecutionException {
        while (!this.isEmpty()) {
            List<DexEncodedMethod> methods = this.extractLeaves();
            assert (methods.size() > 0);
            ArrayList futures = new ArrayList();
            for (DexEncodedMethod method : methods) {
                futures.add(executorService.submit(() -> consumer.accept(method)));
            }
            ThreadUtils.awaitFutures(futures);
        }
    }

    public void dump() {
        this.nodes.forEach((m, n) -> System.out.println(n + "\n"));
    }

    private static class InvokeExtractor
    extends UseRegistry {
        AppInfoWithSubtyping appInfo;
        GraphLense graphLense;
        Node caller;
        CallGraph graph;

        InvokeExtractor(AppInfoWithSubtyping appInfo, GraphLense graphLense, Node caller, CallGraph graph) {
            this.appInfo = appInfo;
            this.graphLense = graphLense;
            this.caller = caller;
            this.graph = graph;
        }

        private void addClassInitializerTarget(DexClass clazz) {
            assert (clazz != null);
            if (clazz.hasClassInitializer() && !clazz.isLibraryClass()) {
                DexEncodedMethod possibleTarget = clazz.getClassInitializer();
                this.addTarget(possibleTarget);
            }
        }

        private void addClassInitializerTarget(DexType type) {
            DexClass clazz;
            if (type.isArrayType()) {
                type = type.toBaseType(this.appInfo.dexItemFactory);
            }
            if ((clazz = this.appInfo.definitionFor(type)) != null) {
                this.addClassInitializerTarget(clazz);
            }
        }

        private void addTarget(DexEncodedMethod target) {
            Node callee = this.graph.ensureMethodNode(target);
            this.graph.addCall(this.caller, callee);
        }

        private void addPossibleTarget(DexEncodedMethod possibleTarget) {
            DexClass possibleTargetClass = this.appInfo.definitionFor(possibleTarget.method.getHolder());
            if (possibleTargetClass != null && !possibleTargetClass.isLibraryClass()) {
                this.addTarget(possibleTarget);
            }
        }

        private void addPossibleTargets(DexEncodedMethod definition, Set<DexEncodedMethod> possibleTargets) {
            for (DexEncodedMethod possibleTarget : possibleTargets) {
                if (possibleTarget == definition) continue;
                this.addPossibleTarget(possibleTarget);
            }
        }

        private void processInvoke(Invoke.Type type, DexMethod method) {
            DexEncodedMethod source = this.caller.method;
            DexEncodedMethod definition = this.appInfo.lookup(type, method = this.graphLense.lookupMethod(method, source));
            if (definition != null) {
                assert (!source.accessFlags.isBridge() || definition != this.caller.method);
                DexClass definitionHolder = this.appInfo.definitionFor(definition.method.getHolder());
                assert (definitionHolder != null);
                if (!definitionHolder.isLibraryClass()) {
                    this.addClassInitializerTarget(definitionHolder);
                    this.addTarget(definition);
                    if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                        Set<DexEncodedMethod> possibleTargets = definitionHolder.isInterface() ? this.appInfo.lookupInterfaceTargets(definition.method) : this.appInfo.lookupVirtualTargets(definition.method);
                        this.addPossibleTargets(definition, possibleTargets);
                    }
                }
            }
        }

        private void processFieldAccess(DexField field) {
            this.addClassInitializerTarget(field.getHolder());
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            this.processInvoke(Invoke.Type.VIRTUAL, method);
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.processInvoke(Invoke.Type.DIRECT, method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            this.processInvoke(Invoke.Type.STATIC, method);
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            this.processInvoke(Invoke.Type.INTERFACE, method);
            return false;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            this.processInvoke(Invoke.Type.SUPER, method);
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            this.addClassInitializerTarget(type);
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }
    }

    private static class Node {
        public final DexEncodedMethod method;
        private int invokeCount = 0;
        private boolean isSelfRecursive = false;
        private final Set<Node> callees = new LinkedHashSet<Node>();
        private final Set<Node> callers = new LinkedHashSet<Node>();

        private Node(DexEncodedMethod method) {
            this.method = method;
        }

        public boolean isBridge() {
            return this.method.accessFlags.isBridge();
        }

        private void addCallee(Node method) {
            this.callees.add(method);
        }

        private void addCaller(Node method) {
            this.callers.add(method);
        }

        boolean isSelfRecursive() {
            return this.isSelfRecursive;
        }

        boolean isLeaf() {
            return this.callees.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodNode for: ");
            builder.append(this.method.qualifiedName());
            builder.append(" (");
            builder.append(this.callees.size());
            builder.append(" callees, ");
            builder.append(this.callers.size());
            builder.append(" callers");
            if (this.isBridge()) {
                builder.append(", bridge");
            }
            if (this.isSelfRecursive()) {
                builder.append(", recursive");
            }
            builder.append(", invoke count " + this.invokeCount);
            builder.append(").\n");
            if (this.callees.size() > 0) {
                builder.append("Callees:\n");
                for (Node call : this.callees) {
                    builder.append("  ");
                    builder.append(call.method.qualifiedName());
                    builder.append("\n");
                }
            }
            if (this.callers.size() > 0) {
                builder.append("Callers:\n");
                for (Node caller : this.callers) {
                    builder.append("  ");
                    builder.append(caller.method.qualifiedName());
                    builder.append("\n");
                }
            }
            return builder.toString();
        }
    }
}

