/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public class EnumOrdinalMapCollector {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final InternalOptions options;
    private final Map<DexType, Reference2IntMap<DexField>> ordinalsMaps = new IdentityHashMap<DexType, Reference2IntMap<DexField>>();

    public EnumOrdinalMapCollector(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.options = options;
    }

    public static Reference2IntMap<DexField> getOrdinalsMapFor(DexType enumClass, Enqueuer.AppInfoWithLiveness appInfo) {
        Map ordinalsMaps = appInfo.getExtension(EnumOrdinalMapCollector.class, Collections.emptyMap());
        return (Reference2IntMap)ordinalsMaps.get(enumClass);
    }

    public void run() {
        this.appInfo.classes().forEach(this::processClasses);
        if (!this.ordinalsMaps.isEmpty()) {
            this.appInfo.setExtension(EnumOrdinalMapCollector.class, this.ordinalsMaps);
        }
    }

    private void processClasses(DexProgramClass clazz) {
        if (!clazz.accessFlags.isEnum() || clazz.isLibraryClass() || !clazz.hasClassInitializer()) {
            return;
        }
        DexEncodedMethod initializer = clazz.getClassInitializer();
        IRCode code = initializer.getCode().buildIR(initializer, this.options);
        Reference2IntArrayMap ordinalsMap = new Reference2IntArrayMap();
        ordinalsMap.defaultReturnValue(-1);
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction newInstance;
            Instruction insn = (Instruction)it.next();
            if (!insn.isStaticPut()) continue;
            StaticPut staticPut = insn.asStaticPut();
            if (staticPut.getField().type != clazz.type || (newInstance = staticPut.inValue().definition) == null || !newInstance.isNewInstance()) continue;
            Instruction ordinal = null;
            for (Instruction ctorCall : newInstance.outValue().uniqueUsers()) {
                InvokeDirect invoke;
                if (!ctorCall.isInvokeDirect() || !this.appInfo.dexItemFactory.isConstructor((invoke = ctorCall.asInvokeDirect()).getInvokedMethod()) || invoke.arguments().size() < 3) continue;
                ordinal = invoke.arguments().get((int)2).definition;
                break;
            }
            if (ordinal == null || !ordinal.isConstNumber()) {
                return;
            }
            if (ordinalsMap.put((Object)staticPut.getField(), ordinal.asConstNumber().getIntValue()) == -1) continue;
            return;
        }
        this.ordinalsMaps.put(clazz.type, (Reference2IntMap<DexField>)ordinalsMap);
    }
}

