/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import java.util.ArrayList;
import java.util.List;

public class InliningInfo {
    final DexEncodedMethod method;
    final List<Edge> edges = new ArrayList<Edge>();

    public InliningInfo(DexEncodedMethod method) {
        this.method = method;
    }

    public void include(Invoke.Type type, DexEncodedMethod target) {
        this.edges.add(new Edge(type, target.method, new Inlining(target)));
    }

    public void exclude(InvokeMethod invoke, String reason) {
        this.edges.add(new Edge(invoke.getType(), invoke.getInvokedMethod(), new NotInlining(reason)));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.method.method.toSourceString());
        buffer.append(" {\n");
        for (Edge edge : this.edges) {
            buffer.append("  ");
            edge.appendOn(buffer);
            buffer.append(".\n");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    static class NotInlining
    extends Node {
        final String reason;

        NotInlining(String reason) {
            this.reason = reason;
        }

        @Override
        public void appendOn(StringBuffer buffer) {
            buffer.append("-- no inlining: ");
            buffer.append(this.reason);
        }
    }

    static class Inlining
    extends Node {
        final DexEncodedMethod target;

        Inlining(DexEncodedMethod target) {
            this.target = target;
        }

        @Override
        void appendOn(StringBuffer buffer) {
            buffer.append("<< INLINED");
        }
    }

    static abstract class Node {
        Node() {
        }

        abstract void appendOn(StringBuffer var1);
    }

    static class Edge {
        final Invoke.Type type;
        final DexMethod declared;
        final Node inlinee;

        public Edge(Invoke.Type type, DexMethod declared, Node inlinee) {
            this.type = type;
            this.declared = declared;
            this.inlinee = inlinee;
        }

        void appendOn(StringBuffer buffer) {
            if (this.declared != null) {
                buffer.append(this.declared.toSourceString());
                buffer.append(' ');
            }
            this.inlinee.appendOn(buffer);
        }
    }
}

