/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.naming.MemberNaming;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ClassNaming {
    public final String originalName;
    final String renamedName;
    final Map<MemberNaming.Signature, MemberNaming> members = new LinkedHashMap<MemberNaming.Signature, MemberNaming>();

    ClassNaming(String renamedName, String originalName) {
        this.renamedName = renamedName;
        this.originalName = originalName;
    }

    void addMemberEntry(MemberNaming entry) {
        MemberNaming.Signature renamedSignature = entry.renamedSignature;
        this.members.put(renamedSignature, entry);
    }

    public MemberNaming lookup(MemberNaming.Signature renamedSignature) {
        return this.members.get(renamedSignature);
    }

    public MemberNaming lookupByOriginalSignature(MemberNaming.Signature original) {
        for (MemberNaming naming : this.members.values()) {
            if (!naming.signature.equals(original)) continue;
            return naming;
        }
        return null;
    }

    public void forAllMemberNaming(Consumer<MemberNaming> consumer) {
        this.members.values().forEach(consumer);
    }

    void write(Writer writer, boolean collapseRanges) throws IOException {
        writer.append(this.originalName);
        writer.append(" -> ");
        writer.append(this.renamedName);
        writer.append(":\n");
        for (MemberNaming member : this.members.values()) {
            member.write(writer, collapseRanges, true);
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer, false);
            return writer.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassNaming)) {
            return false;
        }
        ClassNaming that = (ClassNaming)o;
        return this.originalName.equals(that.originalName) && this.renamedName.equals(that.renamedName) && this.members.equals(that.members);
    }

    public int hashCode() {
        int result = this.originalName.hashCode();
        result = 31 * result + this.renamedName.hashCode();
        result = 31 * result + this.members.hashCode();
        return result;
    }
}

