/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.naming.ClassNameMapper;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class ClassRenamingMapper {
    public final ImmutableBiMap<String, String> translation;
    public final ImmutableSet<String> newClasses;
    public final ImmutableSet<String> unusedNames;

    public static ClassRenamingMapper from(ClassNameMapper originalMap, ClassNameMapper targetMap) {
        ImmutableBiMap.Builder translationBuilder = ImmutableBiMap.builder();
        ImmutableSet.Builder newClasses = ImmutableSet.builder();
        BiMap<String, String> sourceObfuscatedToOriginal = originalMap.getObfuscatedToOriginalMapping();
        BiMap sourceOriginalToObfuscated = sourceObfuscatedToOriginal.inverse();
        BiMap<String, String> targetObfuscatedToOriginal = targetMap.getObfuscatedToOriginalMapping();
        BiMap targetOriginalToObfuscated = targetObfuscatedToOriginal.inverse();
        for (String originalName : sourceOriginalToObfuscated.keySet()) {
            String sourceObfuscatedName = (String)sourceOriginalToObfuscated.get((Object)originalName);
            String targetObfuscatedName = (String)targetOriginalToObfuscated.get((Object)originalName);
            if (targetObfuscatedName == null) {
                newClasses.add((Object)originalName);
                continue;
            }
            translationBuilder.put((Object)sourceObfuscatedName, (Object)targetObfuscatedName);
        }
        ImmutableBiMap translation = translationBuilder.build();
        ImmutableSet unusedNames = ImmutableSet.copyOf((Collection)Sets.difference((Set)targetObfuscatedToOriginal.keySet(), (Set)translation.values()));
        return new ClassRenamingMapper((ImmutableBiMap<String, String>)translation, (ImmutableSet<String>)newClasses.build(), (ImmutableSet<String>)unusedNames);
    }

    private ClassRenamingMapper(ImmutableBiMap<String, String> translation, ImmutableSet<String> newClasses, ImmutableSet<String> unusedNames) {
        this.translation = translation;
        this.newClasses = newClasses;
        this.unusedNames = unusedNames;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Translation:\n\n");
        for (String name : this.translation.keySet()) {
            String newName;
            builder.append(name.equals(newName = (String)this.translation.get((Object)name)) ? "    " : " --- ").append(name).append(" -> ").append(newName).append('\n');
        }
        builder.append("\nNew classes:\n\n");
        for (String name : this.newClasses) {
            builder.append("    ").append(name).append('\n');
        }
        builder.append("\nUnused names:\n\n");
        for (String unused : this.unusedNames) {
            builder.append("    ").append(unused).append('\n');
        }
        return builder.toString();
    }
}

