/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.utils.FileUtils;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public final class PreloadedClassFileProvider
implements ClassFileResourceProvider {
    private final Map<String, byte[]> content;

    private PreloadedClassFileProvider(Map<String, byte[]> content) {
        this.content = content;
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Sets.newHashSet(this.content.keySet());
    }

    @Override
    public Resource getResource(String descriptor) {
        byte[] bytes = this.content.get(descriptor);
        if (bytes == null) {
            return null;
        }
        return Resource.fromBytes(Resource.Kind.CLASSFILE, bytes, Collections.singleton(descriptor));
    }

    public static ClassFileResourceProvider fromArchive(Path archive) throws IOException {
        assert (FileUtils.isArchive(archive));
        Builder builder = PreloadedClassFileProvider.builder();
        try (ZipInputStream stream = new ZipInputStream(new FileInputStream(archive.toFile()));){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                String name = entry.getName();
                if (!FileUtils.isClassFile(Paths.get(name, new String[0]))) continue;
                builder.addResource(PreloadedClassFileProvider.guessTypeDescriptor(name), ByteStreams.toByteArray((InputStream)stream));
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + archive + "': " + e.getMessage(), e);
        }
        return builder.build();
    }

    static String guessTypeDescriptor(Path name) {
        return PreloadedClassFileProvider.guessTypeDescriptor(name.toString());
    }

    private static String guessTypeDescriptor(String name) {
        assert (name != null);
        assert (name.endsWith(".class")) : "Name " + name + " must have " + ".class" + " suffix";
        String fileName = File.separatorChar == '/' ? name.toString() : name.toString().replace(File.separatorChar, '/');
        String descriptor = fileName.substring(0, fileName.length() - ".class".length());
        if (descriptor.contains(".")) {
            throw new CompilationError("Unexpected file name in the archive: " + fileName);
        }
        return 'L' + descriptor + ';';
    }

    public String toString() {
        return this.content.size() + " preloaded resources";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, byte[]> content = new HashMap<String, byte[]>();

        private Builder() {
        }

        public Builder addResource(String descriptor, byte[] bytes) {
            assert (this.content != null);
            assert (descriptor != null);
            assert (bytes != null);
            assert (!this.content.containsKey(descriptor));
            this.content.put(descriptor, bytes);
            return this;
        }

        public PreloadedClassFileProvider build() {
            assert (this.content != null);
            PreloadedClassFileProvider provider = new PreloadedClassFileProvider(this.content);
            this.content = null;
            return provider;
        }
    }
}

