/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.CompilationError;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    public static void iter(String zipFile, OnEntryHandler handler) throws IOException {
        try (ZipInputStream input = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                handler.onEntry(entry, input);
            }
        }
    }

    public static List<File> unzip(String zipFile, File outDirectory) throws IOException {
        return ZipUtils.unzip(zipFile, outDirectory, entry -> true);
    }

    public static List<File> unzip(String zipFile, File outDirectory, Predicate<ZipEntry> filter) throws IOException {
        Path outDirectoryPath = outDirectory.toPath();
        ArrayList<File> outFiles = new ArrayList<File>();
        ZipUtils.iter(zipFile, (entry, input) -> {
            String name = entry.getName();
            if (!entry.isDirectory() && filter.test(entry)) {
                if (name.contains("..")) {
                    throw new CompilationError("Invalid entry name \"" + name + "\"");
                }
                Path outPath = outDirectoryPath.resolve(name);
                File outFile = outPath.toFile();
                outFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(outFile);
                ByteStreams.copy((InputStream)input, (OutputStream)output);
                outFiles.add(outFile);
            }
        });
        return outFiles;
    }

    public static interface OnEntryHandler {
        public void onEntry(ZipEntry var1, ZipInputStream var2) throws IOException;
    }
}

