/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class R8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: r8 [options] <input-files>", (Object)" where <input-files> are any combination of dex, class, zip, jar, or apk files", (Object)" and options are:", (Object)"  --release                # Compile without debugging information (default).", (Object)"  --debug                  # Compile with debugging information.", (Object)"  --output <file>          # Output result in <file>.", (Object)"                           # <file> must be an existing directory or a zip file.", (Object)"  --lib <file>             # Add <file> as a library resource.", (Object)"  --min-api                # Minimum Android API level compatibility.", (Object)"  --pg-conf <file>         # Proguard configuration <file> (implies tree", (Object)"                           # shaking/minification).", (Object)"  --pg-map <file>          # Proguard map <file>.", (Object[])new String[]{"  --no-tree-shaking        # Force disable tree shaking of unreachable classes.", "  --no-minification        # Force disable minification of names.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version of r8.", "  --help                   # Print this message."}));
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final Path mainDexListOutput;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean useTreeShaking;
    private final boolean useMinification;
    private final boolean ignoreMissingClasses;

    public static Builder builder() {
        return new Builder();
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args) throws CompilationException, IOException {
        Builder builder = R8Command.builder();
        R8Command.parse(args, builder, new ParseState());
        return builder;
    }

    private static ParseState parse(String[] args, Builder builder, ParseState state) throws CompilationException, IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (state.mode == CompilationMode.RELEASE) {
                    throw new CompilationException("Cannot compile in both --debug and --release mode.");
                }
                state.mode = CompilationMode.DEBUG;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--release")) {
                if (state.mode == CompilationMode.DEBUG) {
                    throw new CompilationException("Cannot compile in both --debug and --release mode.");
                }
                state.mode = CompilationMode.RELEASE;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--output")) {
                String outputPath = args[++i];
                if (builder.getOutputPath() != null) {
                    throw new CompilationException("Cannot output both to '" + builder.getOutputPath().toString() + "' and '" + outputPath + "'");
                }
                builder.setOutputPath(Paths.get(outputPath, new String[0]));
                continue;
            }
            if (arg.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--min-api")) {
                builder.setMinApiLevel(Integer.valueOf(args[++i]));
                continue;
            }
            if (arg.equals("--no-tree-shaking")) {
                builder.setTreeShaking(false);
                continue;
            }
            if (arg.equals("--no-minification")) {
                builder.setMinification(false);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-map")) {
                builder.setProguardMapFile(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--ignore-missing-classes")) {
                builder.setIgnoreMissingClasses(true);
                continue;
            }
            if (arg.startsWith("@")) {
                String argsFile = arg.substring(1);
                try {
                    List<String> linesInFile = FileUtils.readTextFile(Paths.get(argsFile, new String[0]));
                    ArrayList<String> argsInFile = new ArrayList<String>();
                    for (String line : linesInFile) {
                        for (String word : line.split("\\s")) {
                            String trimmed = word.trim();
                            if (trimmed.isEmpty()) continue;
                            argsInFile.add(trimmed);
                        }
                    }
                    state = R8Command.parse(argsInFile.toArray(new String[argsInFile.size()]), builder, state);
                    continue;
                }
                catch (CompilationException | IOException e) {
                    throw new CompilationException("Failed to read arguments from file " + argsFile + ": " + e.getMessage());
                }
            }
            if (arg.startsWith("--")) {
                throw new CompilationException("Unknown option: " + arg);
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        return state;
    }

    private R8Command(AndroidApp inputApp, Path outputPath, OutputMode outputMode, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, Path mainDexListOutput, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, boolean useTreeShaking, boolean useMinification, boolean ignoreMissingClasses) {
        super(inputApp, outputPath, outputMode, mode, minApiLevel);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        assert (this.getOutputMode() == OutputMode.Indexed) : "Only regular mode is supported in R8";
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListOutput = mainDexListOutput;
        this.proguardConfiguration = proguardConfiguration;
        this.useTreeShaking = useTreeShaking;
        this.useMinification = useMinification;
        this.ignoreMissingClasses = ignoreMissingClasses;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListOutput = null;
        this.proguardConfiguration = null;
        this.useTreeShaking = false;
        this.useMinification = false;
        this.ignoreMissingClasses = false;
    }

    public boolean useTreeShaking() {
        return this.useTreeShaking;
    }

    public boolean useMinification() {
        return this.useMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration);
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.minApiLevel = this.getMinApiLevel();
        assert (!internal.skipMinification);
        boolean bl = internal.skipMinification = !this.useMinification() || !this.proguardConfiguration.isObfuscating();
        assert (internal.useTreeShaking);
        internal.useTreeShaking = this.useTreeShaking();
        assert (!internal.ignoreMissingClasses);
        internal.ignoreMissingClasses = this.ignoreMissingClasses;
        for (String pattern : this.proguardConfiguration.getAttributesRemovalPatterns()) {
            internal.attributeRemoval.applyPattern(pattern);
        }
        internal.ignoreMissingClasses |= this.proguardConfiguration.isIgnoreWarnings();
        assert (!internal.verbose);
        internal.verbose |= this.proguardConfiguration.isVerbose();
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = internal.debug;
        if (this.mainDexListOutput != null) {
            internal.printMainDexListFile = this.mainDexListOutput;
        }
        internal.outputMode = this.getOutputMode();
        if (internal.debug) {
            internal.removeSwitchMaps = false;
            internal.inlineAccessors = false;
        }
        return internal;
    }

    private static class ParseState {
        CompilationMode mode = null;

        private ParseState() {
        }
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<R8Command, Builder> {
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Path mainDexListOutput = null;
        private Consumer<ProguardConfiguration.Builder> proguardConfigurationConsumer = null;
        private final List<ProguardConfigurationSource> proguardConfigs = new ArrayList<ProguardConfigurationSource>();
        private Optional<Boolean> treeShaking = Optional.empty();
        private Optional<Boolean> minification = Optional.empty();
        private boolean ignoreMissingClasses = false;
        private Path packageDistributionFile = null;

        private Builder() {
            super(CompilationMode.RELEASE);
        }

        private Builder(AndroidApp app) {
            super(app, CompilationMode.RELEASE);
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setTreeShaking(boolean useTreeShaking) {
            this.treeShaking = Optional.of(useTreeShaking);
            return this.self();
        }

        public Builder setMinification(boolean useMinification) {
            this.minification = Optional.of(useMinification);
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            for (Path path : paths) {
                this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addMainDexRulesFiles(List<Path> paths) {
            for (Path path : paths) {
                this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines) {
            this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines));
            return this.self();
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListOutput = mainDexListOutputPath;
            return this.self();
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            for (Path path : paths) {
                this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            for (Path path : paths) {
                this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines) {
            this.proguardConfigs.add(new ProguardConfigurationSourceStrings(lines));
            return this.self();
        }

        public Builder addProguardConfigurationConsumer(Consumer<ProguardConfiguration.Builder> c) {
            Consumer<ProguardConfiguration.Builder> oldConsumer = this.proguardConfigurationConsumer;
            this.proguardConfigurationConsumer = builder -> {
                if (oldConsumer != null) {
                    oldConsumer.accept((ProguardConfiguration.Builder)builder);
                }
                c.accept((ProguardConfiguration.Builder)builder);
            };
            return this.self();
        }

        public Builder setProguardMapFile(Path path) {
            this.getAppBuilder().setProguardMapFile(path);
            return this.self();
        }

        public Builder setPackageDistributionFile(Path path) {
            this.packageDistributionFile = path;
            return this.self();
        }

        Builder setIgnoreMissingClasses(boolean ignoreMissingClasses) {
            this.ignoreMissingClasses = ignoreMissingClasses;
            return this.self();
        }

        @Override
        protected void validate() throws CompilationException {
            super.validate();
            if (this.mainDexListOutput != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                throw new CompilationException("Option --main-dex-list-output require --main-dex-rules and/or --main-dex-list");
            }
            if (this.getMode() == CompilationMode.DEBUG && this.packageDistributionFile != null) {
                throw new CompilationException("Package distribution file is not supported in debug mode");
            }
        }

        @Override
        public R8Command build() throws CompilationException, IOException {
            ProguardConfiguration configuration;
            ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new R8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.validate();
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory);
                try {
                    parser.parse(this.mainDexRules);
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
                mainDexKeepRules = parser.getConfig().getRules();
            }
            if (this.proguardConfigs.isEmpty()) {
                configuration = ProguardConfiguration.defaultConfiguration(factory);
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory);
                try {
                    parser.parse(this.proguardConfigs);
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
                ProguardConfiguration.Builder configurationBuilder = parser.getConfigurationBuilder();
                if (this.proguardConfigurationConsumer != null) {
                    this.proguardConfigurationConsumer.accept(configurationBuilder);
                }
                configuration = configurationBuilder.build();
                this.addProgramFiles((Collection<Path>)configuration.getInjars());
                this.addLibraryFiles((Collection<Path>)configuration.getLibraryjars());
            }
            if (this.packageDistributionFile != null) {
                this.getAppBuilder().setPackageDistributionFile(this.packageDistributionFile);
            }
            boolean useTreeShaking = this.treeShaking.orElse(configuration.isShrinking());
            boolean useMinification = this.minification.orElse(configuration.isObfuscating());
            return new R8Command(this.getAppBuilder().build(), this.getOutputPath(), this.getOutputMode(), mainDexKeepRules, this.mainDexListOutput, configuration, this.getMode(), this.getMinApiLevel(), useTreeShaking, useMinification, this.ignoreMissingClasses);
        }
    }
}

