/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.Resource;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OneShotByteResource;
import com.android.tools.r8.utils.PreloadedClassFileProvider;
import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

class ProgramFileArchiveReader {
    private final Path archive;
    private boolean ignoreDexInArchive;
    private List<Resource> dexResources = null;
    private List<Resource> classResources = null;

    ProgramFileArchiveReader(Path archive, boolean ignoreDexInArchive) {
        this.archive = archive;
        this.ignoreDexInArchive = ignoreDexInArchive;
    }

    private void readArchive() throws IOException {
        assert (FileUtils.isArchive(this.archive));
        this.dexResources = new ArrayList<Resource>();
        this.classResources = new ArrayList<Resource>();
        try (ZipInputStream stream = new ZipInputStream(new FileInputStream(this.archive.toFile()));){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                Path name = Paths.get(entry.getName(), new String[0]);
                if (FileUtils.isDexFile(name)) {
                    if (this.ignoreDexInArchive) continue;
                    OneShotByteResource resource = new OneShotByteResource(Resource.Kind.DEX, ByteStreams.toByteArray((InputStream)stream), null);
                    this.dexResources.add(resource);
                    continue;
                }
                if (!FileUtils.isClassFile(name)) continue;
                String descriptor = PreloadedClassFileProvider.guessTypeDescriptor(name);
                OneShotByteResource resource = new OneShotByteResource(Resource.Kind.CLASSFILE, ByteStreams.toByteArray((InputStream)stream), Collections.singleton(descriptor));
                this.classResources.add(resource);
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
        }
        if (!this.dexResources.isEmpty() && !this.classResources.isEmpty()) {
            throw new CompilationError("Cannot create android app from an archive '" + this.archive + "' containing both DEX and Java-bytecode content");
        }
    }

    public Collection<Resource> getDexProgramResources() throws IOException {
        if (this.dexResources == null) {
            this.readArchive();
        }
        List<Resource> result = this.dexResources;
        this.dexResources = null;
        return result;
    }

    public Collection<Resource> getClassProgramResources() throws IOException {
        if (this.classResources == null) {
            this.readArchive();
        }
        List<Resource> result = this.classResources;
        this.classResources = null;
        return result;
    }
}

