/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AbstractAapt;
import com.android.builder.internal.aapt.v2.AaptV2CommandBuilder;
import com.android.builder.model.Version;
import com.android.builder.utils.FileCache;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.tools.aapt2.Aapt2Jni;
import com.android.tools.aapt2.Aapt2RenamingConventions;
import com.android.tools.aapt2.Aapt2Result;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class AaptV2Jni
extends AbstractAapt {
    private final File intermediateDir;
    private final ProcessOutputHandler processOutputHandler;
    private final WaitableExecutor executor;
    private final Aapt2Jni aapt2Jni;

    public AaptV2Jni(File intermediateDir, WaitableExecutor executor, ProcessOutputHandler processOutputHandler, FileCache fileCache) throws IOException {
        this.intermediateDir = intermediateDir;
        this.executor = executor;
        this.processOutputHandler = processOutputHandler;
        this.aapt2Jni = new Aapt2Jni(new TempDirCache());
    }

    @Override
    protected ListenableFuture<Void> makeValidatedPackage(AaptPackageConfig config) throws AaptException {
        if (config.getResourceOutputApk() != null) {
            try {
                Files.deleteIfExists(config.getResourceOutputApk().toPath());
            }
            catch (IOException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        ImmutableList<String> args = AaptV2CommandBuilder.makeLink(config, this.intermediateDir);
        Aapt2Result aapt2Result = this.aapt2Jni.link((List<String>)args);
        AaptV2Jni.writeMessages(this.processOutputHandler, aapt2Result.getMessages());
        if (aapt2Result.getReturnCode() == 0) {
            return Futures.immediateFuture(null);
        }
        return Futures.immediateFailedFuture((Throwable)AaptV2Jni.buildException("link", args, aapt2Result));
    }

    public Future<File> compile(CompileResourceRequest request) throws Exception {
        return this.executor.execute(() -> {
            ImmutableList<String> args = AaptV2CommandBuilder.makeCompile(request);
            Aapt2Result aapt2Result = this.aapt2Jni.compile((List<String>)args);
            AaptV2Jni.writeMessages(this.processOutputHandler, aapt2Result.getMessages());
            if (aapt2Result.getReturnCode() == 0) {
                return new File(request.getOutput(), Aapt2RenamingConventions.compilationRename(request.getInput()));
            }
            throw AaptV2Jni.buildException("compile", args, aapt2Result);
        });
    }

    public void close() {
    }

    public File compileOutputFor(CompileResourceRequest request) {
        return new File(request.getOutput(), Aapt2RenamingConventions.compilationRename(request.getInput()));
    }

    private static AaptException buildException(String action, List<String> args, Aapt2Result aapt2Result) {
        StringBuilder builder = new StringBuilder();
        builder.append("AAPT2 ").append(action).append(" failed:\naapt2 ").append(action).append(" ").append(Joiner.on((char)' ').join(args)).append("\n");
        if (aapt2Result.getMessages().isEmpty()) {
            builder.append("No issues were reported");
        } else {
            builder.append("Issues:\n - ").append(Joiner.on((String)"\n - ").join(aapt2Result.getMessages()));
        }
        return new AaptException(builder.toString(), new Object[0]);
    }

    private static void writeMessages(ProcessOutputHandler processOutputHandler, List<Aapt2Result.Message> messages) throws AaptException {
        ProcessOutput output;
        if (messages.isEmpty()) {
            return;
        }
        try (ProcessOutput ignored = output = processOutputHandler.createOutput();
             PrintWriter err = new PrintWriter(output.getErrorOutput());
             PrintWriter out = new PrintWriter(output.getStandardOutput());){
            for (Aapt2Result.Message message : messages) {
                switch (message.getLevel()) {
                    case NOTE: {
                        out.println(message.toString());
                        break;
                    }
                    case ERROR: 
                    case WARN: {
                        err.println(message.toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AaptException(e, "Unexpected error handling AAPT output", new Object[0]);
        }
        try {
            processOutputHandler.handleOutput(output);
        }
        catch (ProcessException e) {
            throw new AaptException(e, "Unexpected error handling AAPT output", new Object[0]);
        }
    }

    private static class TempDirCache
    implements Aapt2Jni.Cache {
        private TempDirCache() {
        }

        @Override
        public Path getCachedDirectory(HashCode hashCode, Aapt2Jni.Creator creator) throws IOException {
            Path tempDir = Files.createTempDirectory("aapt2_", new FileAttribute[0]);
            creator.create(tempDir);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.walkFileTree(tempDir, new RecursiveDelete());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
            return tempDir;
        }

        private static class RecursiveDelete
        extends SimpleFileVisitor<Path> {
            private RecursiveDelete() {
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        }
    }

    private static class FileCacheAapt2JniCache
    implements Aapt2Jni.Cache {
        private final FileCache fileCache;

        FileCacheAapt2JniCache(FileCache fileCache) {
            this.fileCache = fileCache;
        }

        @Override
        public Path getCachedDirectory(HashCode hashCode, Aapt2Jni.Creator creator) throws IOException {
            FileCache.QueryResult result;
            String pluginVersion = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            if (pluginVersion.endsWith("-dev")) {
                pluginVersion = pluginVersion + "-" + LocalDateTime.now(ZoneOffset.ofHours(0)).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            FileCache.Inputs inputs = new FileCache.Inputs.Builder(FileCache.Command.EXTRACT_AAPT2_JNI).putString("hashcode", hashCode.toString()).putString("pluginVersion", pluginVersion).build();
            try {
                result = this.fileCache.createFileInCacheIfAbsent(inputs, file -> {
                    Files.createDirectory(file.toPath(), new FileAttribute[0]);
                    creator.create(file.toPath());
                });
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to create AAPT2 jni cache entry", e);
            }
            return ((File)Preconditions.checkNotNull((Object)result.getCachedFile())).toPath();
        }
    }
}

