/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationResult;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.D8Output;
import com.android.tools.r8.R8;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class D8 {
    private static final int STATUS_ERROR = 1;

    private D8() {
    }

    public static D8Output run(D8Command command) throws IOException, CompilationException {
        InternalOptions options = command.getInternalOptions();
        CompilationResult result = D8.runForTesting(command.getInputApp(), options);
        assert (result != null);
        D8Output output = new D8Output(result.androidApp, command.getOutputMode());
        if (command.getOutputPath() != null) {
            output.write(command.getOutputPath());
        }
        return output;
    }

    public static D8Output run(D8Command command, ExecutorService executor) throws IOException, CompilationException {
        InternalOptions options = command.getInternalOptions();
        CompilationResult result = D8.runForTesting(command.getInputApp(), options, executor);
        assert (result != null);
        D8Output output = new D8Output(result.androidApp, command.getOutputMode());
        if (command.getOutputPath() != null) {
            output.write(command.getOutputPath());
        }
        return output;
    }

    private static void run(String[] args) throws IOException, CompilationException {
        D8Command command;
        D8Command.Builder builder = D8Command.parse(args);
        if (builder.getOutputPath() == null) {
            builder.setOutputPath(Paths.get(".", new String[0]));
        }
        if ((command = builder.build()).isPrintHelp()) {
            System.out.println(D8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("D8 v0.2.0-dev");
            return;
        }
        D8.run(command);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(D8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        try {
            D8.run(args);
        }
        catch (NoSuchFileException e) {
            System.err.println("File not found: " + e.getFile());
            System.exit(1);
        }
        catch (FileAlreadyExistsException e) {
            System.err.println("File already exists: " + e.getFile());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Failed to read or write application files: " + e.getMessage());
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
        catch (CompilationException e) {
            System.err.println("Compilation failed: " + e.getMessageForD8());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompilationResult runForTesting(AndroidApp inputApp, InternalOptions options) throws IOException, CompilationException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        try {
            CompilationResult compilationResult = D8.runForTesting(inputApp, options, executor);
            return compilationResult;
        }
        finally {
            executor.shutdown();
        }
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        return new Marker(Marker.Tool.D8).put("version", "v0.2.0-dev").put("min-api", options.minApiLevel);
    }

    private static CompilationResult runForTesting(AndroidApp inputApp, InternalOptions options, ExecutorService executor) throws IOException, CompilationException {
        try {
            options.skipMinification = true;
            options.inlineAccessors = false;
            options.outline.enabled = false;
            Timing timing = new Timing("DX timer");
            DexApplication app = new ApplicationReader(inputApp, options, timing).read(executor);
            AppInfo appInfo = new AppInfo(app);
            app = D8.optimize(app, appInfo, options, timing, executor);
            if (options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                return null;
            }
            Marker marker = D8.getMarker(options);
            CompilationResult output = new CompilationResult(new ApplicationWriter(app, appInfo, options, marker, null, NamingLens.getIdentityLens(), null).write(executor), app, appInfo);
            options.printWarnings();
            return output;
        }
        catch (ExecutionException e) {
            R8.unwrapExecutionException(e);
            throw new AssertionError((Object)e);
        }
    }

    private static DexApplication optimize(DexApplication application, AppInfo appInfo, InternalOptions options, Timing timing, ExecutorService executor) throws IOException, ExecutionException, ApiLevelException {
        CfgPrinter printer = options.printCfg ? new CfgPrinter() : null;
        IRConverter converter = new IRConverter(timing, application, appInfo, options, printer);
        application = converter.convertToDex(executor);
        if (options.printCfg) {
            if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
                System.out.print(printer.toString());
            } else {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);){
                    writer.write(printer.toString());
                }
            }
        }
        return application;
    }
}

