/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationResult;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.DexOverflowException;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.ClassAndMemberPublicizer;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.EnumOrdinalMapCollector;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.SourceFileRewriter;
import com.android.tools.r8.optimize.BridgeMethodAnalysis;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.VisibilityBridgeRemover;
import com.android.tools.r8.shaking.AbstractMethodRemover;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.DiscardedChecker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ReasonPrinter;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.SimpleClassMerger;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.shaking.protolite.ProtoLiteExtension;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class R8 {
    private final Timing timing = new Timing("R8");
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        options.itemFactory.resetSortedIndices();
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        return new Marker(Marker.Tool.R8).put("version", "v0.2.0-dev").put("min-api", options.minApiLevel);
    }

    public static AndroidApp writeApplication(ExecutorService executorService, DexApplication application, AppInfo appInfo, byte[] deadCode, NamingLens namingLens, byte[] proguardSeedsData, InternalOptions options) throws ExecutionException, DexOverflowException {
        try {
            Marker marker = R8.getMarker(options);
            return new ApplicationWriter(application, appInfo, options, marker, deadCode, namingLens, proguardSeedsData).write(executorService);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write dex application", e);
        }
    }

    static DexApplication optimize(DexApplication application, AppInfoWithSubtyping appInfo, InternalOptions options) throws ApiLevelException, ExecutionException, IOException {
        return new R8(options).optimize(application, appInfo);
    }

    private DexApplication optimize(DexApplication application, AppInfoWithSubtyping appInfo) throws IOException, ApiLevelException, ExecutionException {
        return this.optimize(application, appInfo, GraphLense.getIdentityLense(), Executors.newSingleThreadExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexApplication optimize(DexApplication application, AppInfoWithSubtyping appInfo, GraphLense graphLense, ExecutorService executorService) throws IOException, ApiLevelException, ExecutionException {
        CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
        this.timing.begin("Create IR");
        try {
            IRConverter converter = new IRConverter(this.timing, application, appInfo, this.options, printer, graphLense);
            application = converter.optimize(executorService);
        }
        finally {
            this.timing.end();
        }
        if (this.options.printCfg) {
            if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                System.out.print(printer.toString());
            } else {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);){
                    writer.write(printer.toString());
                }
            }
        }
        return application;
    }

    private Set<DexType> filterMissingClasses(Set<DexType> missingClasses, ProguardClassNameList dontWarnPatterns) {
        HashSet<DexType> result = new HashSet<DexType>(missingClasses);
        dontWarnPatterns.forEachTypeMatcher(matcher -> {
            if (matcher instanceof ProguardTypeMatcher.MatchSpecificType) {
                result.remove(((ProguardTypeMatcher.MatchSpecificType)matcher).type);
            } else {
                result.removeIf(matcher::matches);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompilationResult runForTesting(AndroidApp app, InternalOptions options) throws IOException, CompilationException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        try {
            CompilationResult compilationResult = R8.runForTesting(app, options, executor);
            return compilationResult;
        }
        finally {
            executor.shutdown();
        }
    }

    private static CompilationResult runForTesting(AndroidApp app, InternalOptions options, ExecutorService executor) throws IOException, CompilationException {
        return new R8(options).run(app, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationResult run(AndroidApp inputApp, ExecutorService executorService) throws IOException, CompilationException {
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        try {
            TreePruner pruner;
            Enqueuer enqueuer;
            RootSetBuilder.RootSet rootSet;
            AndroidApiLevel oLevel = AndroidApiLevel.O;
            if (this.options.minApiLevel >= oLevel.getLevel() && !this.options.mainDexKeepRules.isEmpty()) {
                throw new CompilationError("Automatic main dex list is not supported when compiling for " + oLevel.getName() + " and later (--min-api " + oLevel.getLevel() + ")");
            }
            DexApplication application = new ApplicationReader(inputApp, this.options, this.timing).read(executorService).toDirect();
            AppInfoWithSubtyping appInfo = new AppInfoWithSubtyping(application);
            byte[] proguardSeedsData = null;
            this.timing.begin("Strip unused code");
            try {
                Set<DexType> missingClasses = appInfo.getMissingClasses();
                missingClasses = this.filterMissingClasses(missingClasses, this.options.proguardConfiguration.getDontWarnPatterns());
                if (!missingClasses.isEmpty()) {
                    missingClasses.forEach(clazz -> this.options.diagnosticsHandler.warning(new StringDiagnostic("Missing class: " + clazz.toSourceString())));
                    if (!this.options.ignoreMissingClasses) {
                        throw new CompilationError("Shrinking can't be performed because some library classes are missing.");
                    }
                }
                rootSet = new RootSetBuilder(application, appInfo, this.options.proguardConfiguration.getRules(), this.options).run(executorService);
                enqueuer = new Enqueuer(appInfo, this.options);
                enqueuer.addExtension(new ProtoLiteExtension(appInfo));
                appInfo = enqueuer.traceApplication(rootSet, this.timing);
                if (this.options.proguardConfiguration.isPrintSeeds()) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    PrintStream out = new PrintStream(bytes);
                    RootSetBuilder.writeSeeds(appInfo.withLiveness().pinnedItems, out);
                    out.flush();
                    proguardSeedsData = bytes.toByteArray();
                }
                if (this.options.useTreeShaking) {
                    pruner = new TreePruner(application, appInfo.withLiveness(), this.options);
                    application = pruner.run();
                    appInfo = appInfo.withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses());
                    new AbstractMethodRemover(appInfo).run();
                    new AnnotationRemover(appInfo.withLiveness(), this.options).run();
                }
            }
            finally {
                this.timing.end();
            }
            if (this.options.proguardConfiguration.isAccessModificationAllowed()) {
                ClassAndMemberPublicizer.run(application);
                application = new VisibilityBridgeRemover(appInfo, application).run();
            }
            GraphLense graphLense = GraphLense.getIdentityLense();
            if (appInfo.hasLiveness()) {
                graphLense = new MemberRebindingAnalysis(appInfo.withLiveness(), graphLense).run();
                if (!this.options.skipClassMerging && this.options.inlineAccessors) {
                    this.timing.begin("ClassMerger");
                    SimpleClassMerger classMerger = new SimpleClassMerger(application, appInfo.withLiveness(), graphLense, this.timing);
                    graphLense = classMerger.run();
                    this.timing.end();
                    appInfo = appInfo.withLiveness().prunedCopyFrom(application, classMerger.getRemovedClasses());
                }
                appInfo = appInfo.withLiveness().rewrittenWithLense(graphLense);
                new SwitchMapCollector(appInfo.withLiveness(), this.options).run();
                new EnumOrdinalMapCollector(appInfo.withLiveness(), this.options).run();
            }
            graphLense = new BridgeMethodAnalysis(graphLense, appInfo.withSubtyping()).run();
            application = this.optimize(application, appInfo, graphLense, executorService);
            this.timing.begin("Rename SourceFile");
            new SourceFileRewriter(appInfo, this.options).run();
            this.timing.end();
            if (!this.options.mainDexKeepRules.isEmpty()) {
                appInfo = new AppInfoWithSubtyping(application);
                enqueuer = new Enqueuer(appInfo, this.options);
                RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(application, appInfo, this.options.mainDexKeepRules, this.options).run(executorService);
                Set<DexType> mainDexBaseClasses = enqueuer.traceMainDex(mainDexRootSet, this.timing);
                application = application.builder().addToMainDexList(new MainDexListBuilder(mainDexBaseClasses, application).run()).build();
            }
            appInfo = new AppInfoWithSubtyping(application);
            if (this.options.useTreeShaking || !this.options.skipMinification) {
                this.timing.begin("Post optimization code stripping");
                try {
                    enqueuer = new Enqueuer(appInfo, this.options);
                    appInfo = enqueuer.traceApplication(rootSet, this.timing);
                    if (this.options.useTreeShaking) {
                        pruner = new TreePruner(application, appInfo.withLiveness(), this.options);
                        application = pruner.run();
                        appInfo = appInfo.withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses());
                        ReasonPrinter reasonPrinter = enqueuer.getReasonPrinter(rootSet.reasonAsked);
                        reasonPrinter.run(application);
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            if (this.options.useTreeShaking && !rootSet.checkDiscarded.isEmpty() && this.options.useDiscardedChecker) {
                new DiscardedChecker(rootSet, application, this.options).run();
            }
            this.timing.begin("Minification");
            NamingLens namingLens = this.options.skipMinification ? NamingLens.getIdentityLens() : new Minifier(appInfo.withLiveness(), rootSet, this.options).run(this.timing);
            this.timing.end();
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                pruner = null;
                return pruner;
            }
            AndroidApp androidApp = R8.writeApplication(executorService, application, appInfo, application.deadCode, namingLens, proguardSeedsData, this.options);
            this.options.printWarnings();
            CompilationResult compilationResult = new CompilationResult(androidApp, application, appInfo);
            return compilationResult;
        }
        catch (ExecutionException e) {
            R8.unwrapExecutionException(e);
            throw new AssertionError((Object)e);
        }
        finally {
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    static void unwrapExecutionException(ExecutionException executionException) throws CompilationException {
        Throwable cause = executionException.getCause();
        if (cause instanceof CompilationError) {
            cause.addSuppressed(executionException);
            throw (CompilationError)cause;
        }
        if (cause instanceof CompilationException) {
            cause.addSuppressed(executionException);
            throw (CompilationException)cause;
        }
        if (cause instanceof RuntimeException) {
            if (cause.getCause() != null && cause.getCause() instanceof CompilationException) {
                cause.addSuppressed(executionException);
                throw (CompilationException)cause.getCause();
            }
            if (cause.getCause() != null && cause.getCause().getCause() != null && cause.getCause().getCause() instanceof CompilationException) {
                cause.addSuppressed(executionException);
                throw (CompilationException)cause.getCause().getCause();
            }
            cause.addSuppressed(executionException);
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(executionException.getMessage(), cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidApp run(R8Command command) throws IOException, CompilationException {
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            AndroidApp androidApp = R8.run(command, executorService);
            return androidApp;
        }
        finally {
            executorService.shutdown();
        }
    }

    private static void writeProguardMapToPath(Path path, AndroidApp outputApp) throws IOException {
        try (Closer closer = Closer.create();){
            OutputStream mapOut = FileUtils.openPathWithDefault(closer, path, System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            outputApp.writeProguardMap(mapOut);
        }
    }

    static void writeOutputs(R8Command command, InternalOptions options, AndroidApp outputApp) throws IOException {
        Throwable throwable;
        Closer closer;
        if (command.getOutputPath() != null) {
            outputApp.write(command.getOutputPath(), options.outputMode);
        }
        if ((options.proguardConfiguration.isPrintMapping() || options.proguardMapOutput != null) && !options.skipMinification) {
            assert (outputApp.hasProguardMap());
            if (options.proguardConfiguration.isPrintMapping()) {
                R8.writeProguardMapToPath(options.proguardConfiguration.getPrintMappingFile(), outputApp);
            }
            if (options.proguardMapOutput != null) {
                R8.writeProguardMapToPath(options.proguardMapOutput, outputApp);
            }
        }
        if (options.proguardConfiguration.isPrintSeeds()) {
            assert (outputApp.hasProguardSeeds());
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream seedsOut = FileUtils.openPathWithDefault(closer, options.proguardConfiguration.getSeedFile(), System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeProguardSeeds(closer, seedsOut);
            }
            catch (Throwable seedsOut) {
                throwable = seedsOut;
                throw seedsOut;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable seedsOut) {
                            throwable.addSuppressed(seedsOut);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        if (outputApp.hasMainDexListOutput()) {
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream mainDexOut = FileUtils.openPathWithDefault(closer, options.printMainDexListFile, System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeMainDexList(closer, mainDexOut);
            }
            catch (Throwable mainDexOut) {
                throwable = mainDexOut;
                throw mainDexOut;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable mainDexOut) {
                            throwable.addSuppressed(mainDexOut);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        if (options.proguardConfiguration.isPrintUsage() && outputApp.hasDeadCode()) {
            closer = Closer.create();
            throwable = null;
            try {
                OutputStream deadCodeOut = FileUtils.openPathWithDefault(closer, options.proguardConfiguration.getPrintUsageFile(), System.out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                outputApp.writeDeadCode(closer, deadCodeOut);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
    }

    public static AndroidApp run(R8Command command, ExecutorService executor) throws IOException, CompilationException {
        InternalOptions options = command.getInternalOptions();
        AndroidApp outputApp = R8.runForTesting((AndroidApp)command.getInputApp(), (InternalOptions)options, (ExecutorService)executor).androidApp;
        R8.writeOutputs(command, options, outputApp);
        return outputApp;
    }

    private static void run(String[] args) throws IOException, ProguardRuleParserException, CompilationException {
        R8Command command;
        R8Command.Builder builder = R8Command.parse(args);
        if (builder.getOutputPath() == null) {
            builder.setOutputPath(Paths.get(".", new String[0]));
        }
        if ((command = builder.build()).isPrintHelp()) {
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("R8 v0.2.0-dev");
            return;
        }
        R8.run(command);
    }

    public static void main(String[] args) {
        try {
            R8.run(args);
        }
        catch (NoSuchFileException e) {
            System.err.println("File not found: " + e.getFile());
            System.exit(1);
        }
        catch (FileAlreadyExistsException e) {
            System.err.println("File already exists: " + e.getFile());
        }
        catch (IOException e) {
            System.err.println("Failed to read or write Android app: " + e.getMessage());
            System.exit(1);
        }
        catch (ProguardRuleParserException e) {
            System.err.println("Failed parsing proguard keep rules: " + e.getMessage());
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
        catch (CompilationException e) {
            System.err.println("Compilation failed: " + e.getMessageForR8());
            System.exit(1);
        }
    }
}

