/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Nop;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class FillArrayDataPayload
extends Nop {
    public final int element_width;
    public final long size;
    public final short[] data;

    FillArrayDataPayload(int high, BytecodeStream stream) {
        super(high, stream);
        this.element_width = FillArrayDataPayload.read16BitValue(stream);
        this.size = FillArrayDataPayload.read32BitValue(stream);
        assert (this.size * (long)this.element_width < Integer.MAX_VALUE);
        int numberOfShorts = (int)(this.size * (long)this.element_width + 1L) / 2;
        this.data = new short[numberOfShorts];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = FillArrayDataPayload.readSigned16BitValue(stream);
        }
    }

    public FillArrayDataPayload(int element_width, long size, short[] data) {
        this.element_width = element_width;
        this.size = size;
        this.data = data;
    }

    @Override
    public boolean isPayload() {
        return true;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(3, dest);
        this.write16BitValue(this.element_width, dest);
        this.write32BitValue(this.size, dest);
        for (int i = 0; i < this.data.length; ++i) {
            this.write16BitValue(this.data[i], dest);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        FillArrayDataPayload that = (FillArrayDataPayload)other;
        return this.size == that.size && this.element_width == that.element_width && Arrays.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.element_width;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int getSize() {
        return 4 + this.data.length;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return super.toString(naming) + "[FillArrayPayload], " + "width: " + this.element_width + ", size:  " + this.size;
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        builder.append("    ");
        builder.append(".array-data ");
        builder.append(StringUtils.hexString(this.element_width, 1));
        builder.append("  # ");
        builder.append(this.element_width);
        builder.append("\n");
        if (this.element_width == 1) {
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int value = this.data[i] >> j * 8 & 0xFF;
                    if ((long)(i * 2 + j) >= this.size) continue;
                    builder.append("      ");
                    builder.append(StringUtils.hexString(value, 2));
                    builder.append("  # ");
                    builder.append(value);
                    builder.append("\n");
                }
            }
        } else {
            assert (this.element_width == 2 || this.element_width == 4 || this.element_width == 8);
            long value = 0L;
            for (int i = 0; i < this.data.length; ++i) {
                value = Short.toUnsignedLong(this.data[i]) << 16 * (i % (this.element_width / 2)) | value;
                if ((i + 1) * 2 % this.element_width != 0) continue;
                builder.append("      ");
                builder.append(StringUtils.hexString(value, this.element_width * 2));
                builder.append("  # ");
                builder.append(value);
                builder.append("\n");
                value = 0L;
            }
        }
        builder.append("    ");
        builder.append(".end array-data");
        return builder.toString();
    }

    @Override
    public void buildIR(IRBuilder builder) {
    }
}

