/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.utils.LebUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class BaseFile {
    protected final ByteBuffer buffer;

    protected BaseFile(Resource resource) throws IOException {
        this.buffer = ByteBuffer.wrap(ByteStreams.toByteArray(resource.getStream()));
    }

    protected BaseFile(String name) throws IOException {
        Path path = Paths.get(name, new String[0]);
        this.buffer = ByteBuffer.wrap(Files.readAllBytes(path));
    }

    protected BaseFile(InputStream input) throws IOException {
        this.buffer = ByteBuffer.wrap(ByteStreams.toByteArray(input));
    }

    protected BaseFile(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    abstract void setByteOrder();

    byte[] getByteArray(int size) {
        byte[] result = new byte[size];
        this.buffer.get(result);
        return result;
    }

    int getUleb128() {
        return LebUtils.parseUleb128(this);
    }

    int getSleb128() {
        return LebUtils.parseSleb128(this);
    }

    int getUleb128p1() {
        return this.getUleb128() - 1;
    }

    int getUint() {
        int result = this.buffer.getInt();
        assert (result >= 0);
        return result;
    }

    int getUshort() {
        int result = this.buffer.getShort() & 0xFFFF;
        assert (result >= 0);
        return result;
    }

    short getShort() {
        return this.buffer.getShort();
    }

    int getUint(int offset) {
        int result = this.buffer.getInt(offset);
        assert (result >= 0);
        return result;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    int position() {
        return this.buffer.position();
    }

    void position(int position) {
        this.buffer.position(position);
    }

    void align(int alignment) {
        assert ((alignment & alignment - 1) == 0);
        int p = this.buffer.position();
        p += alignment - p % alignment & alignment - 1;
        this.buffer.position(p);
    }

    public byte get() {
        return this.buffer.get();
    }

    int getUbyte() {
        int result = this.buffer.get() & 0xFF;
        assert (result >= 0);
        return result;
    }

    int end() {
        return this.buffer.capacity();
    }
}

