/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;

public class ArrayLength
extends Instruction {
    public ArrayLength(Value dest, Value array) {
        super(dest, array);
    }

    public Value dest() {
        return this.outValue;
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public boolean isArrayLength() {
        return true;
    }

    @Override
    public ArrayLength asArrayLength() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        builder.add((Instruction)this, new com.android.tools.r8.code.ArrayLength(dest, array));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        if (super.identicalAfterRegisterAllocation(other, allocator)) {
            return this.array() == other.asArrayLength().array();
        }
        return false;
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        assert (other.isArrayLength());
        return true;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isArrayLength());
        return 0;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.ALWAYS;
    }
}

