/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlockInstructionIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;

public class BasicBlock {
    private Int2ReferenceMap<DebugLocalInfo> localsAtEntry;
    private final List<BasicBlock> successors = new ArrayList<BasicBlock>();
    private final List<BasicBlock> predecessors = new ArrayList<BasicBlock>();
    private CatchHandlers<Integer> catchHandlers = CatchHandlers.EMPTY_INDICES;
    private LinkedList<Instruction> instructions = new LinkedList();
    private int number = -1;
    private List<Phi> phis = new ArrayList<Phi>();
    private boolean filled = false;
    private boolean sealed = false;
    private Map<Integer, Phi> incompletePhis = new HashMap<Integer, Phi>();
    private int estimatedPredecessorsCount = 0;
    private int unfilledPredecessorsCount = 0;
    private int color = 0;
    private Map<Integer, Value> currentDefinitions = new HashMap<Integer, Value>();

    public void setLocalsAtEntry(Int2ReferenceMap<DebugLocalInfo> localsAtEntry) {
        this.localsAtEntry = localsAtEntry;
    }

    public Int2ReferenceMap<DebugLocalInfo> getLocalsAtEntry() {
        return this.localsAtEntry;
    }

    public void replaceLastInstruction(Instruction instruction) {
        InstructionListIterator iterator = this.listIterator(this.getInstructions().size());
        iterator.previous();
        iterator.replaceCurrentInstruction(instruction);
    }

    public List<BasicBlock> getSuccessors() {
        return this.successors;
    }

    public List<BasicBlock> getNormalSuccessors() {
        if (!this.hasCatchHandlers()) {
            return this.successors;
        }
        Set<Integer> handlers = this.catchHandlers.getUniqueTargets();
        ImmutableList.Builder normals = ImmutableList.builder();
        for (int i = 0; i < this.successors.size(); ++i) {
            if (handlers.contains(i)) continue;
            normals.add(this.successors.get(i));
        }
        return normals.build();
    }

    public List<BasicBlock> getPredecessors() {
        return this.predecessors;
    }

    public List<BasicBlock> getNormalPredecessors() {
        ImmutableList.Builder normals = ImmutableList.builder();
        for (BasicBlock predecessor : this.predecessors) {
            if (predecessor.hasCatchSuccessor(this)) continue;
            normals.add(predecessor);
        }
        return normals.build();
    }

    public void removeSuccessor(BasicBlock block) {
        int index = this.successors.indexOf(block);
        assert (index >= 0) : "removeSuccessor did not find the successor to remove";
        this.removeSuccessorsByIndex(Collections.singletonList(index));
    }

    public void removePredecessor(BasicBlock block) {
        int index = this.predecessors.indexOf(block);
        assert (index >= 0) : "removePredecessor did not find the predecessor to remove";
        this.predecessors.remove(index);
        if (this.phis != null) {
            for (Phi phi : this.getPhis()) {
                phi.removeOperand(index);
            }
            ArrayList<Phi> trivials = new ArrayList<Phi>();
            for (Phi phi : this.getPhis()) {
                if (!phi.isTrivialPhi()) continue;
                trivials.add(phi);
            }
            for (Phi phi : trivials) {
                phi.removeTrivialPhi();
            }
        }
    }

    private void swapSuccessors(int x, int y) {
        assert (x != y);
        if (this.hasCatchHandlers()) {
            ArrayList<Integer> targets = new ArrayList<Integer>(this.catchHandlers.getAllTargets());
            for (int i = 0; i < targets.size(); ++i) {
                if ((Integer)targets.get(i) == x) {
                    targets.set(i, y);
                    continue;
                }
                if ((Integer)targets.get(i) != y) continue;
                targets.set(i, x);
            }
            this.catchHandlers = new CatchHandlers<Integer>(this.catchHandlers.getGuards(), targets);
        }
        BasicBlock tmp = this.successors.get(x);
        this.successors.set(x, this.successors.get(y));
        this.successors.set(y, tmp);
    }

    public void replaceSuccessor(BasicBlock block, BasicBlock newBlock) {
        block18: {
            block13: {
                block15: {
                    int indexOfNewBlock;
                    int indexOfOldBlock;
                    block16: {
                        block17: {
                            block14: {
                                assert (this.successors.contains(block)) : "attempt to replace non-existent successor";
                                if (!this.successors.contains(newBlock)) break block13;
                                indexOfOldBlock = this.successors.indexOf(block);
                                indexOfNewBlock = this.successors.indexOf(newBlock);
                                if (this.hasCatchHandlers()) {
                                    ArrayList<Integer> targets = new ArrayList<Integer>(this.catchHandlers.getAllTargets());
                                    for (int i = 0; i < targets.size(); ++i) {
                                        if ((Integer)targets.get(i) == indexOfOldBlock) {
                                            targets.set(i, indexOfNewBlock);
                                        }
                                        if ((Integer)targets.get(i) <= indexOfOldBlock) continue;
                                        targets.set(i, (Integer)targets.get(i) - 1);
                                    }
                                    this.catchHandlers = new CatchHandlers<Integer>(this.catchHandlers.getGuards(), targets);
                                }
                                if (!this.exit().isGoto()) break block14;
                                if (indexOfOldBlock == this.successors.size() - 1 && indexOfNewBlock != this.successors.size() - 2) {
                                    this.swapSuccessors(indexOfOldBlock - 1, indexOfNewBlock);
                                }
                                break block15;
                            }
                            if (!this.exit().isIf()) break block16;
                            if (indexOfNewBlock < this.successors.size() - 2 || indexOfOldBlock < this.successors.size() - 2) break block17;
                            Instruction instruction = this.getInstructions().removeLast();
                            for (Value value : instruction.inValues()) {
                                if (!value.hasUsersInfo()) continue;
                                value.removeUser(instruction);
                            }
                            Goto exit = new Goto();
                            exit.setBlock(this);
                            this.getInstructions().addLast(exit);
                            break block15;
                        }
                        if (indexOfOldBlock < this.successors.size() - 2) break block15;
                        this.swapSuccessors(indexOfOldBlock - 1, indexOfNewBlock);
                        break block15;
                    }
                    if (this.exit().isSwitch()) {
                        Switch exit = this.exit().asSwitch();
                        if (exit.getFallthroughBlockIndex() == indexOfOldBlock) {
                            exit.setFallthroughBlockIndex(indexOfNewBlock);
                        }
                        if (exit.getFallthroughBlockIndex() > indexOfOldBlock) {
                            exit.setFallthroughBlockIndex(exit.getFallthroughBlockIndex() - 1);
                        }
                        int[] indices = exit.targetBlockIndices();
                        for (int i = 0; i < indices.length; ++i) {
                            if (indices[i] == indexOfOldBlock) {
                                indices[i] = indexOfNewBlock;
                            }
                            if (indices[i] <= indexOfOldBlock) continue;
                            indices[i] = indices[i] - 1;
                        }
                    }
                }
                boolean removed = this.successors.remove(block);
                assert (removed);
                break block18;
            }
            for (int i = 0; i < this.successors.size(); ++i) {
                if (this.successors.get(i) != block) continue;
                this.successors.set(i, newBlock);
                return;
            }
        }
    }

    public void replacePredecessor(BasicBlock block, BasicBlock newBlock) {
        for (int i = 0; i < this.predecessors.size(); ++i) {
            if (this.predecessors.get(i) != block) continue;
            this.predecessors.set(i, newBlock);
            return;
        }
        assert (false) : "replaceSuccessor did not find the predecessor to replace";
    }

    public void swapSuccessorsByIndex(int index1, int index2) {
        BasicBlock t = this.successors.get(index1);
        this.successors.set(index1, this.successors.get(index2));
        this.successors.set(index2, t);
    }

    public void removeSuccessorsByIndex(List<Integer> successorsToRemove) {
        if (successorsToRemove.isEmpty()) {
            return;
        }
        ArrayList<BasicBlock> copy = new ArrayList<BasicBlock>(this.successors);
        this.successors.clear();
        int current = 0;
        for (int i : successorsToRemove) {
            this.successors.addAll(copy.subList(current, i));
            current = i + 1;
        }
        this.successors.addAll(copy.subList(current, copy.size()));
        if (this.hasCatchHandlers()) {
            int size = this.catchHandlers.size();
            ArrayList<DexType> guards = new ArrayList<DexType>(size);
            ArrayList<Integer> targets = new ArrayList<Integer>(size);
            current = 0;
            for (int i = 0; i < this.catchHandlers.getAllTargets().size(); ++i) {
                if (!successorsToRemove.contains(this.catchHandlers.getAllTargets().get(i))) continue;
                guards.addAll(this.catchHandlers.getGuards().subList(current, i));
                targets.addAll(this.catchHandlers.getAllTargets().subList(current, i));
                current = i + 1;
            }
            this.catchHandlers = guards.isEmpty() ? CatchHandlers.EMPTY_INDICES : new CatchHandlers(guards, targets);
        }
    }

    public void removePredecessorsByIndex(List<Integer> predecessorsToRemove) {
        if (predecessorsToRemove.isEmpty()) {
            return;
        }
        ArrayList<BasicBlock> copy = new ArrayList<BasicBlock>(this.predecessors);
        this.predecessors.clear();
        int current = 0;
        for (int i : predecessorsToRemove) {
            this.predecessors.addAll(copy.subList(current, i));
            current = i + 1;
        }
        this.predecessors.addAll(copy.subList(current, copy.size()));
    }

    public void removePhisByIndex(List<Integer> predecessorsToRemove) {
        for (Phi phi : this.phis) {
            phi.removeOperandsByIndex(predecessorsToRemove);
        }
    }

    public List<Phi> getPhis() {
        return this.phis;
    }

    public void setPhis(List<Phi> phis) {
        this.phis = phis;
    }

    public boolean isFilled() {
        return this.filled;
    }

    void setFilledForTesting() {
        this.filled = true;
    }

    public boolean hasCatchHandlers() {
        assert (this.catchHandlers != null);
        return !this.catchHandlers.isEmpty();
    }

    public int getNumber() {
        assert (this.number >= 0);
        return this.number;
    }

    public void setNumber(int number) {
        assert (number >= 0);
        this.number = number;
    }

    public LinkedList<Instruction> getInstructions() {
        return this.instructions;
    }

    public Instruction entry() {
        return this.instructions.get(0);
    }

    public JumpInstruction exit() {
        assert (this.filled);
        assert (this.instructions.get(this.instructions.size() - 1).isJumpInstruction());
        return this.instructions.get(this.instructions.size() - 1).asJumpInstruction();
    }

    public Instruction exceptionalExit() {
        assert (this.hasCatchHandlers());
        InstructionListIterator it = this.listIterator(this.instructions.size());
        while (it.hasPrevious()) {
            Instruction instruction = (Instruction)it.previous();
            if (!instruction.instructionTypeCanThrow()) continue;
            return instruction;
        }
        throw new Unreachable();
    }

    public void clearUserInfo() {
        this.phis = null;
        this.instructions.forEach(Instruction::clearUserInfo);
    }

    public void buildDex(DexBuilder builder) {
        for (Instruction instruction : this.instructions) {
            instruction.buildDex(builder);
        }
    }

    public void mark() {
        assert (this.color == 0);
        this.color = 1;
    }

    public void clearMark() {
        this.color = 0;
    }

    public boolean isMarked() {
        return this.color == 1;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasColor(int color) {
        return this.color == color;
    }

    public void incrementUnfilledPredecessorCount() {
        ++this.unfilledPredecessorsCount;
        ++this.estimatedPredecessorsCount;
    }

    public void decrementUnfilledPredecessorCount(int n) {
        this.unfilledPredecessorsCount -= n;
        this.estimatedPredecessorsCount -= n;
    }

    public void decrementUnfilledPredecessorCount() {
        --this.unfilledPredecessorsCount;
        --this.estimatedPredecessorsCount;
    }

    public boolean verifyFilledPredecessors() {
        assert (this.estimatedPredecessorsCount == this.predecessors.size());
        assert (this.unfilledPredecessorsCount == 0);
        return true;
    }

    public void addPhi(Phi phi) {
        this.phis.add(phi);
    }

    public void removePhi(Phi phi) {
        this.phis.remove(phi);
    }

    public void add(Instruction next) {
        assert (!this.isFilled());
        this.instructions.add(next);
        next.setBlock(this);
    }

    public void close(IRBuilder builder) {
        assert (!this.isFilled());
        assert (!this.instructions.isEmpty());
        this.filled = true;
        boolean bl = this.sealed = this.unfilledPredecessorsCount == 0;
        assert (this.exit().isJumpInstruction());
        assert (this.verifyNoValuesAfterThrowingInstruction());
        for (BasicBlock successor : this.successors) {
            successor.filledPredecessor(builder);
        }
    }

    public void link(BasicBlock successor) {
        assert (!this.successors.contains(successor));
        assert (!successor.predecessors.contains(this));
        this.successors.add(successor);
        successor.predecessors.add(this);
    }

    private static boolean allPredecessorsDominated(BasicBlock block, DominatorTree dominator) {
        for (BasicBlock pred : block.predecessors) {
            if (dominator.dominatedBy(pred, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean blocksClean(List<BasicBlock> blocks) {
        blocks.forEach(b -> {
            assert (b.predecessors.size() == 0);
            assert (b.successors.size() == 0);
        });
        return true;
    }

    public BasicBlock unlinkSinglePredecessor() {
        assert (this.predecessors.size() == 1);
        assert (this.predecessors.get((int)0).successors.size() == 1);
        BasicBlock unlinkedBlock = this.predecessors.get(0);
        this.predecessors.get((int)0).successors.clear();
        this.predecessors.clear();
        return unlinkedBlock;
    }

    public BasicBlock unlinkSingleSuccessor() {
        assert (!this.hasCatchHandlers());
        assert (this.successors.size() == 1);
        assert (this.successors.get((int)0).predecessors.size() == 1);
        BasicBlock unlinkedBlock = this.successors.get(0);
        this.successors.get((int)0).predecessors.clear();
        this.successors.clear();
        return unlinkedBlock;
    }

    public BasicBlock unlinkSingle() {
        this.unlinkSinglePredecessor();
        return this.unlinkSingleSuccessor();
    }

    public void detachAllSuccessors() {
        for (BasicBlock successor : this.successors) {
            successor.predecessors.remove(this);
        }
        this.successors.clear();
    }

    public List<BasicBlock> unlink(BasicBlock successor, DominatorTree dominator) {
        assert (this.successors.contains(successor));
        assert (successor.predecessors.contains(this));
        ArrayList<BasicBlock> removedBlocks = new ArrayList<BasicBlock>();
        TreeSet<Pair> worklist = new TreeSet<Pair>();
        worklist.add(new Pair(this, successor));
        while (!worklist.isEmpty()) {
            Pair pair = (Pair)worklist.pollFirst();
            BasicBlock pred = pair.first;
            BasicBlock succ = pair.second;
            assert (pred.successors.contains(succ));
            assert (succ.predecessors.contains(pred));
            int size = pred.successors.size();
            pred.removeSuccessor(succ);
            assert (size == pred.successors.size() + 1);
            size = succ.predecessors.size();
            succ.removePredecessor(pred);
            assert (size == succ.predecessors.size() + 1);
            if (!BasicBlock.allPredecessorsDominated(succ, dominator)) continue;
            removedBlocks.add(succ);
            for (BasicBlock block : succ.successors) {
                worklist.add(new Pair(succ, block));
            }
            for (Instruction instruction : succ.getInstructions()) {
                for (Value value : instruction.inValues) {
                    value.removeUser(instruction);
                }
                for (Value value : instruction.getDebugValues()) {
                    value.removeDebugUser(instruction);
                }
            }
        }
        assert (BasicBlock.blocksClean(removedBlocks));
        return removedBlocks;
    }

    public void linkCatchSuccessors(List<DexType> guards, List<BasicBlock> targets) {
        ArrayList<Integer> successorIndexes = new ArrayList<Integer>(targets.size());
        for (BasicBlock target : targets) {
            int index = this.successors.indexOf(target);
            if (index < 0) {
                index = this.successors.size();
                this.link(target);
            }
            successorIndexes.add(index);
        }
        this.catchHandlers = new CatchHandlers(guards, successorIndexes);
    }

    public void clearCurrentDefinitions() {
        this.currentDefinitions = null;
        for (Phi phi : this.getPhis()) {
            phi.clearDefinitionsUsers();
        }
    }

    private static int onThrowValueRegister(int register) {
        return -(register + 1);
    }

    private Value readOnThrowValue(int register, EdgeType readingEdge) {
        if (readingEdge == EdgeType.EXCEPTIONAL) {
            return this.currentDefinitions.get(BasicBlock.onThrowValueRegister(register));
        }
        return null;
    }

    private boolean isOnThrowValue(int register, EdgeType readingEdge) {
        return this.readOnThrowValue(register, readingEdge) != null;
    }

    public Value readCurrentDefinition(int register, EdgeType readingEdge) {
        Value result = this.readOnThrowValue(register, readingEdge);
        if (result != null) {
            return result == Value.UNDEFINED ? null : result;
        }
        return this.currentDefinitions.get(register);
    }

    public void replaceCurrentDefinitions(Value oldValue, Value newValue) {
        assert (oldValue.definition.getBlock() == this);
        assert (!oldValue.isUsed());
        this.currentDefinitions.replaceAll((index, value3) -> value3 == oldValue ? newValue : value3);
    }

    public void updateCurrentDefinition(int register, Value value, EdgeType readingEdge) {
        if (this.isOnThrowValue(register, readingEdge)) {
            register = BasicBlock.onThrowValueRegister(register);
        }
        Value previousValue = this.currentDefinitions.get(register);
        if (value.isPhi()) {
            value.asPhi().addDefinitionsUser(this.currentDefinitions);
        }
        assert (this.verifyOnThrowWrite(register));
        this.currentDefinitions.put(register, value);
        if (previousValue != null && previousValue.isPhi() && !this.currentDefinitions.values().contains(previousValue)) {
            previousValue.asPhi().removeDefinitionsUser(this.currentDefinitions);
        }
    }

    public void writeCurrentDefinition(int register, Value value, ThrowingInfo throwing) {
        if (throwing == ThrowingInfo.CAN_THROW) {
            Value previous = this.currentDefinitions.get(register);
            assert (this.verifyOnThrowWrite(register));
            this.currentDefinitions.put(BasicBlock.onThrowValueRegister(register), previous == null ? Value.UNDEFINED : previous);
        }
        this.updateCurrentDefinition(register, value, EdgeType.NON_EDGE);
    }

    public void filledPredecessor(IRBuilder builder) {
        assert (this.unfilledPredecessorsCount > 0);
        if (--this.unfilledPredecessorsCount == 0) {
            assert (this.estimatedPredecessorsCount == this.predecessors.size());
            for (Map.Entry<Integer, Phi> entry : this.incompletePhis.entrySet()) {
                int register = entry.getKey();
                if (register < 0) {
                    register = BasicBlock.onThrowValueRegister(register);
                }
                entry.getValue().addOperands(builder, register);
            }
            this.sealed = true;
            this.incompletePhis.clear();
        }
    }

    public EdgeType getEdgeType(BasicBlock successor) {
        assert (this.successors.indexOf(successor) >= 0);
        return this.hasCatchSuccessor(successor) ? EdgeType.EXCEPTIONAL : EdgeType.NORMAL;
    }

    public boolean hasCatchSuccessor(BasicBlock block) {
        if (!this.hasCatchHandlers()) {
            return false;
        }
        return this.catchHandlers.getAllTargets().contains(this.successors.indexOf(block));
    }

    public int guardsForCatchSuccessor(BasicBlock block) {
        assert (this.hasCatchSuccessor(block));
        int index = this.successors.indexOf(block);
        int count = 0;
        for (int handler : this.catchHandlers.getAllTargets()) {
            if (handler != index) continue;
            ++count;
        }
        assert (count > 0);
        return count;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void addIncompletePhi(int register, Phi phi, EdgeType readingEdge) {
        if (this.isOnThrowValue(register, readingEdge)) {
            register = BasicBlock.onThrowValueRegister(register);
        }
        assert (!this.incompletePhis.containsKey(register));
        this.incompletePhis.put(register, phi);
    }

    public boolean hasIncompletePhis() {
        return !this.incompletePhis.isEmpty();
    }

    public Collection<Integer> getIncompletePhiRegisters() {
        return this.incompletePhis.keySet();
    }

    private static void appendBasicBlockList(StringBuilder builder, List<BasicBlock> list, Function<BasicBlock, String> postfix) {
        if (list.size() > 0) {
            for (BasicBlock block : list) {
                builder.append(block.number >= 0 ? Integer.valueOf(block.number) : "<unknown>");
                builder.append(postfix.apply(block));
                builder.append(' ');
            }
        } else {
            builder.append('-');
        }
    }

    public String toString() {
        return this.toDetailedString();
    }

    public String toSimpleString() {
        return this.number < 0 ? super.toString() : "block " + this.number;
    }

    private String predecessorPostfix(BasicBlock block) {
        if (this.hasCatchSuccessor(block)) {
            return new String(new char[this.guardsForCatchSuccessor(block)]).replace("\u0000", "*");
        }
        return "";
    }

    public String toDetailedString() {
        StringBuilder builder = new StringBuilder();
        builder.append("block ");
        builder.append(this.number);
        builder.append(", pred-counts: " + this.predecessors.size());
        if (this.unfilledPredecessorsCount > 0) {
            builder.append(" (" + this.unfilledPredecessorsCount + " unfilled)");
        }
        builder.append(", succ-count: " + this.successors.size());
        builder.append(", filled: " + this.isFilled());
        builder.append(", sealed: " + this.isSealed());
        builder.append('\n');
        builder.append("predecessors: ");
        BasicBlock.appendBasicBlockList(builder, this.predecessors, b -> "");
        builder.append('\n');
        builder.append("successors: ");
        BasicBlock.appendBasicBlockList(builder, this.successors, this::predecessorPostfix);
        if (this.successors.size() > 0) {
            builder.append(" (");
            if (this.hasCatchHandlers()) {
                builder.append(this.catchHandlers.size());
            } else {
                builder.append("no");
            }
            builder.append(" try/catch successors)");
        }
        builder.append('\n');
        if (this.phis != null && this.phis.size() > 0) {
            for (Phi phi : this.phis) {
                builder.append(phi.printPhi());
                if (this.incompletePhis.values().contains(phi)) {
                    builder.append(" (incomplete)");
                }
                builder.append('\n');
            }
        } else {
            builder.append("no phis\n");
        }
        if (this.localsAtEntry != null) {
            builder.append("locals: ");
            StringUtils.append(builder, this.localsAtEntry.int2ReferenceEntrySet(), ", ", StringUtils.BraceType.NONE);
            builder.append('\n');
        }
        for (Instruction instruction : this.instructions) {
            StringUtils.appendLeftPadded(builder, Integer.toString(instruction.getNumber()), 6);
            builder.append(": ");
            StringUtils.appendRightPadded(builder, instruction.toString(), 20);
            if (DebugLocalInfo.PRINT_LEVEL != DebugLocalInfo.PrintLevel.NONE) {
                ArrayList<Value> localEnds = new ArrayList<Value>(instruction.getDebugValues().size());
                ArrayList<Value> localStarts = new ArrayList<Value>(instruction.getDebugValues().size());
                ArrayList<Value> localLive = new ArrayList<Value>(instruction.getDebugValues().size());
                for (Value value : instruction.getDebugValues()) {
                    if (value.getDebugLocalEnds().contains(instruction)) {
                        localEnds.add(value);
                        continue;
                    }
                    if (value.getDebugLocalStarts().contains(instruction)) {
                        localStarts.add(value);
                        continue;
                    }
                    assert (value.debugUsers().contains(instruction));
                    localLive.add(value);
                }
                this.printDebugValueSet("live", localLive, builder);
                this.printDebugValueSet("end", localEnds, builder);
                this.printDebugValueSet("start", localStarts, builder);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private void printDebugValueSet(String header, List<Value> locals, StringBuilder builder) {
        if (!locals.isEmpty()) {
            builder.append(" [").append(header).append(": ");
            StringUtils.append(builder, locals, ", ", StringUtils.BraceType.NONE);
            builder.append("]");
        }
    }

    public void print(CfgPrinter printer) {
        printer.begin("block");
        printer.print("name \"B").append(this.number).append("\"\n");
        printer.print("from_bci -1\n");
        printer.print("to_bci -1\n");
        printer.print("predecessors");
        BasicBlock.printBlockList(printer, this.predecessors);
        printer.ln();
        printer.print("successors");
        BasicBlock.printBlockList(printer, this.successors);
        printer.ln();
        printer.print("xhandlers\n");
        printer.print("flags\n");
        printer.print("first_lir_id ").print(this.instructions.get(0).getNumber()).ln();
        printer.print("last_lir_id ").print(this.instructions.get(this.instructions.size() - 1).getNumber()).ln();
        printer.begin("HIR");
        if (this.phis != null) {
            for (Phi phi : this.phis) {
                phi.print(printer);
                printer.append(" <|@\n");
            }
        }
        for (Instruction instruction : this.instructions) {
            instruction.print(printer);
            printer.append(" <|@\n");
        }
        printer.end("HIR");
        printer.begin("LIR");
        for (Instruction instruction : this.instructions) {
            instruction.printLIR(printer);
            printer.append(" <|@\n");
        }
        printer.end("LIR");
        printer.end("block");
    }

    private static void printBlockList(CfgPrinter printer, List<BasicBlock> blocks) {
        for (BasicBlock block : blocks) {
            printer.append(" \"B").append(block.number).append("\"");
        }
    }

    public void addPhiMove(Move move) {
        JumpInstruction branch = this.exit();
        this.instructions.set(this.instructions.size() - 1, move);
        this.instructions.add(branch);
    }

    public void setInstructions(LinkedList<Instruction> instructions) {
        this.instructions = instructions;
    }

    public void removeInstructions(List<Integer> toRemove) {
        if (!toRemove.isEmpty()) {
            LinkedList<Instruction> newInstructions = new LinkedList<Instruction>();
            int nextIndex = 0;
            for (Integer index : toRemove) {
                assert (index >= nextIndex);
                newInstructions.addAll(this.instructions.subList(nextIndex, index));
                this.instructions.get(index).clearBlock();
                nextIndex = index + 1;
            }
            if (nextIndex < this.instructions.size()) {
                newInstructions.addAll(this.instructions.subList(nextIndex, this.instructions.size()));
            }
            assert (this.instructions.size() == newInstructions.size() + toRemove.size());
            this.setInstructions(newInstructions);
        }
    }

    public void removeInstruction(Instruction toRemove) {
        int index = this.instructions.indexOf(toRemove);
        assert (index >= 0);
        this.removeInstructions(Collections.singletonList(index));
    }

    public static BasicBlock createGotoBlock(BasicBlock target, int blockNumber) {
        BasicBlock block = BasicBlock.createGotoBlock(blockNumber);
        block.getSuccessors().add(target);
        return block;
    }

    public static BasicBlock createGotoBlock(int blockNumber) {
        BasicBlock block = new BasicBlock();
        block.add(new Goto());
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public static BasicBlock createIfBlock(int blockNumber, If theIf) {
        BasicBlock block = new BasicBlock();
        block.add(theIf);
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public static BasicBlock createIfBlock(int blockNumber, If theIf, Instruction instruction) {
        BasicBlock block = new BasicBlock();
        block.add(instruction);
        block.add(theIf);
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public static BasicBlock createSwitchBlock(int blockNumber, Switch theSwitch) {
        BasicBlock block = new BasicBlock();
        block.add(theSwitch);
        block.close(null);
        block.setNumber(blockNumber);
        return block;
    }

    public boolean isTrivialGoto() {
        return this.instructions.size() == 1 && this.exit().isGoto();
    }

    public boolean hasOneNormalExit() {
        return this.successors.size() == 1 && this.exit().isGoto();
    }

    public CatchHandlers<BasicBlock> getCatchHandlers() {
        if (!this.hasCatchHandlers()) {
            return CatchHandlers.EMPTY_BASIC_BLOCK;
        }
        List<BasicBlock> targets = ListUtils.map(this.catchHandlers.getAllTargets(), this.successors::get);
        return new CatchHandlers<BasicBlock>(this.catchHandlers.getGuards(), targets);
    }

    public CatchHandlers<Integer> getCatchHandlersWithSuccessorIndexes() {
        return this.catchHandlers;
    }

    public void clearCatchHandlers() {
        this.catchHandlers = CatchHandlers.EMPTY_INDICES;
    }

    public void transferCatchHandlers(BasicBlock other) {
        this.catchHandlers = other.catchHandlers;
        other.catchHandlers = CatchHandlers.EMPTY_INDICES;
    }

    public boolean canThrow() {
        for (Instruction instruction : this.instructions) {
            if (!instruction.instructionTypeCanThrow()) continue;
            return true;
        }
        return false;
    }

    private boolean verifyOnThrowWrite(int register) {
        if (register >= 0) {
            return true;
        }
        for (Integer other : this.currentDefinitions.keySet()) {
            assert (other >= 0 || other == register);
        }
        return true;
    }

    private boolean verifyNoValuesAfterThrowingInstruction() {
        if (this.hasCatchHandlers()) {
            InstructionListIterator iterator = this.listIterator(this.instructions.size());
            while (iterator.hasPrevious()) {
                Instruction instruction = (Instruction)iterator.previous();
                if (instruction.instructionTypeCanThrow()) {
                    return true;
                }
                assert (instruction.outValue() == null);
            }
        }
        return true;
    }

    public InstructionIterator iterator() {
        return new BasicBlockInstructionIterator(this);
    }

    public InstructionListIterator listIterator() {
        return new BasicBlockInstructionIterator(this);
    }

    public InstructionListIterator listIterator(int index) {
        return new BasicBlockInstructionIterator(this, index);
    }

    public InstructionListIterator listIterator(Instruction instruction) {
        return new BasicBlockInstructionIterator(this, instruction);
    }

    BasicBlock createSplitBlock(int blockNumber, boolean keepCatchHandlers) {
        boolean hadCatchHandlers = this.hasCatchHandlers();
        BasicBlock newBlock = new BasicBlock();
        newBlock.setNumber(blockNumber);
        newBlock.successors.addAll(this.successors);
        for (BasicBlock successor : newBlock.getSuccessors()) {
            successor.replacePredecessor(this, newBlock);
        }
        this.successors.clear();
        newBlock.catchHandlers = this.catchHandlers;
        this.catchHandlers = CatchHandlers.EMPTY_INDICES;
        if (keepCatchHandlers && hadCatchHandlers) {
            this.moveCatchHandlers(newBlock);
        }
        this.link(newBlock);
        newBlock.filled = true;
        newBlock.sealed = true;
        return newBlock;
    }

    public void moveCatchHandlers(BasicBlock fromBlock) {
        List<BasicBlock> catchSuccessors = this.appendCatchHandlers(fromBlock);
        for (BasicBlock successor : catchSuccessors) {
            fromBlock.successors.remove(successor);
            successor.removePredecessor(fromBlock);
        }
        fromBlock.catchHandlers = CatchHandlers.EMPTY_INDICES;
    }

    public void copyCatchHandlers(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock fromBlock) {
        if (this.catchHandlers != null && this.catchHandlers.hasCatchAll()) {
            return;
        }
        List<BasicBlock> catchSuccessors = this.appendCatchHandlers(fromBlock);
        for (BasicBlock catchSuccessor : catchSuccessors) {
            catchSuccessor.splitCriticalExceptionEdges(code.valueNumberGenerator, newBlock -> {
                newBlock.setNumber(code.getHighestBlockNumber() + 1);
                blockIterator.add((BasicBlock)newBlock);
            });
        }
    }

    public void splitCriticalExceptionEdges(ValueNumberGenerator valueNumberGenerator, Consumer<BasicBlock> onNewBlock) {
        List<BasicBlock> predecessors = this.getPredecessors();
        boolean hasMoveException = this.entry().isMoveException();
        MoveException move = null;
        DebugPosition position = null;
        if (hasMoveException) {
            move = this.entry().asMoveException();
            position = move.getPosition();
            assert (move.getDebugValues().isEmpty());
            this.getInstructions().remove(0);
        }
        ArrayList<BasicBlock> newPredecessors = new ArrayList<BasicBlock>();
        ArrayList<Value> values = new ArrayList<Value>(predecessors.size());
        for (BasicBlock predecessor : predecessors) {
            if (!predecessor.hasCatchSuccessor(this)) {
                throw new CompilationError("Invalid block structure: catch block reachable via non-exceptional flow.");
            }
            BasicBlock newBlock = new BasicBlock();
            newPredecessors.add(newBlock);
            if (hasMoveException) {
                Value value = new Value(valueNumberGenerator.next(), MoveType.OBJECT, move.getLocalInfo());
                values.add(value);
                MoveException newMove = new MoveException(value);
                newBlock.add(newMove);
                if (position != null) {
                    newMove.setPosition(new DebugPosition(position.line, position.file));
                }
            }
            newBlock.add(new Goto());
            newBlock.close(null);
            newBlock.getSuccessors().add(this);
            newBlock.getPredecessors().add(predecessor);
            predecessor.replaceSuccessor(this, newBlock);
            onNewBlock.accept(newBlock);
            assert (newBlock.getNumber() >= 0) : "Number must be assigned by `onNewBlock`";
        }
        predecessors.clear();
        predecessors.addAll(newPredecessors);
        if (hasMoveException) {
            Phi phi = new Phi(valueNumberGenerator.next(), this, MoveType.OBJECT, move.getLocalInfo());
            phi.addOperands(values);
            move.outValue().replaceUsers(phi);
        }
    }

    private List<BasicBlock> appendCatchHandlers(BasicBlock fromBlock) {
        assert (fromBlock.hasCatchHandlers());
        List<Integer> prevCatchTargets = fromBlock.catchHandlers.getAllTargets();
        List<DexType> prevCatchGuards = fromBlock.catchHandlers.getGuards();
        ArrayList<BasicBlock> catchSuccessors = new ArrayList<BasicBlock>();
        ArrayList<DexType> newCatchGuards = new ArrayList<DexType>();
        ArrayList<Integer> newCatchTargets = new ArrayList<Integer>();
        if (this.hasCatchHandlers()) {
            newCatchGuards.addAll(this.catchHandlers.getGuards());
            newCatchTargets.addAll(this.catchHandlers.getAllTargets());
            Iterator iterator = newCatchTargets.iterator();
            while (iterator.hasNext()) {
                int newCatchTarget = (Integer)iterator.next();
                BasicBlock catchSuccessor = this.successors.get(newCatchTarget);
                if (!catchSuccessors.contains(catchSuccessor)) {
                    catchSuccessors.add(catchSuccessor);
                }
                int index = catchSuccessors.indexOf(catchSuccessor);
                assert (index == newCatchTarget);
            }
        }
        int formerCatchHandlersCount = catchSuccessors.size();
        for (int i = 0; i < prevCatchTargets.size(); ++i) {
            int prevCatchTarget = prevCatchTargets.get(i);
            DexType prevCatchGuard = prevCatchGuards.get(i);
            BasicBlock catchSuccessor = fromBlock.successors.get(prevCatchTarget);
            assert (catchSuccessor.getPredecessors().size() == 1);
            assert (catchSuccessor.getPhis().isEmpty());
            int index = catchSuccessors.indexOf(catchSuccessor);
            if (index == -1) {
                catchSuccessors.add(catchSuccessor);
                index = catchSuccessors.size() - 1;
            }
            newCatchGuards.add(prevCatchGuard);
            newCatchTargets.add(index);
        }
        ArrayList<BasicBlock> formerSuccessors = new ArrayList<BasicBlock>(this.successors);
        this.successors.clear();
        ArrayList<BasicBlock> sharedCatchSuccessors = new ArrayList<BasicBlock>();
        for (int i = 0; i < catchSuccessors.size(); ++i) {
            if (i < formerCatchHandlersCount) {
                assert (((BasicBlock)catchSuccessors.get(i)).getPredecessors().contains(this));
                this.successors.add((BasicBlock)catchSuccessors.get(i));
                continue;
            }
            assert (!((BasicBlock)catchSuccessors.get(i)).getPredecessors().contains(this));
            this.link((BasicBlock)catchSuccessors.get(i));
            sharedCatchSuccessors.add((BasicBlock)catchSuccessors.get(i));
        }
        this.catchHandlers = new CatchHandlers(newCatchGuards, newCatchTargets);
        int catchSuccessorsCount = this.successors.size();
        for (BasicBlock formerSuccessor : formerSuccessors) {
            if (this.successors.contains(formerSuccessor)) continue;
            assert (!this.exit().isThrow());
            this.successors.add(formerSuccessor);
        }
        assert (this.successors.size() == catchSuccessorsCount || !this.exit().isThrow());
        return sharedCatchSuccessors;
    }

    public static class Pair
    implements Comparable<Pair> {
        public BasicBlock first;
        public BasicBlock second;

        public Pair(BasicBlock first, BasicBlock second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.first != o.first) {
                return this.first.getNumber() - o.first.getNumber();
            }
            if (this.second != o.second) {
                return this.second.getNumber() - o.second.getNumber();
            }
            return 0;
        }
    }

    public static enum EdgeType {
        NON_EDGE,
        NORMAL,
        EXCEPTIONAL;

    }

    public static enum ThrowingInfo {
        NO_THROW,
        CAN_THROW;

    }
}

