/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Format12x;
import com.android.tools.r8.code.NegDouble;
import com.android.tools.r8.code.NegFloat;
import com.android.tools.r8.code.NegInt;
import com.android.tools.r8.code.NegLong;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Unop;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;

public class Neg
extends Unop {
    public final NumericType type;

    public Neg(NumericType type, Value dest, Value source) {
        super(dest, source);
        this.type = type;
    }

    @Override
    public boolean canBeFolded() {
        return (this.type == NumericType.INT || this.type == NumericType.LONG || this.type == NumericType.FLOAT || this.type == NumericType.DOUBLE) && this.source().isConstant();
    }

    @Override
    public ConstInstruction fold(IRCode code) {
        assert (this.canBeFolded());
        if (this.type == NumericType.INT) {
            int result = -this.source().getConstInstruction().asConstNumber().getIntValue();
            Value value = code.createValue(MoveType.SINGLE, this.getLocalInfo());
            return new ConstNumber(ConstType.INT, value, result);
        }
        if (this.type == NumericType.LONG) {
            long result = -this.source().getConstInstruction().asConstNumber().getLongValue();
            Value value = code.createValue(MoveType.WIDE, this.getLocalInfo());
            return new ConstNumber(ConstType.LONG, value, result);
        }
        if (this.type == NumericType.FLOAT) {
            float result = -this.source().getConstInstruction().asConstNumber().getFloatValue();
            Value value = code.createValue(MoveType.SINGLE, this.getLocalInfo());
            return new ConstNumber(ConstType.FLOAT, value, Float.floatToIntBits(result));
        }
        assert (this.type == NumericType.DOUBLE);
        double result = -this.source().getConstInstruction().asConstNumber().getDoubleValue();
        Value value = code.createValue(MoveType.WIDE, this.getLocalInfo());
        return new ConstNumber(ConstType.DOUBLE, value, Double.doubleToLongBits(result));
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return other.asNeg().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asNeg().type.ordinal();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format12x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int src = builder.allocatedRegister(this.source(), this.getNumber());
        switch (this.type) {
            case INT: {
                instruction = new NegInt(dest, src);
                break;
            }
            case LONG: {
                instruction = new NegLong(dest, src);
                break;
            }
            case FLOAT: {
                instruction = new NegFloat(dest, src);
                break;
            }
            case DOUBLE: {
                instruction = new NegDouble(dest, src);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean isNeg() {
        return true;
    }

    @Override
    public Neg asNeg() {
        return this;
    }
}

