/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.ArrayLength;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.DebugLocalRead;
import com.android.tools.r8.ir.code.DebugLocalUninitialized;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.Neg;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Not;
import com.android.tools.r8.ir.code.NumberConversion;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Or;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Shl;
import com.android.tools.r8.ir.code.Shr;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Ushr;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class IRBuilder {
    public static final int INITIAL_BLOCK_OFFSET = -1;
    private final Int2ReferenceSortedMap<BlockInfo> targets = new Int2ReferenceAVLTreeMap<BlockInfo>();
    private final Queue<Integer> traceBlocksWorklist = new LinkedList<Integer>();
    private boolean[] processedInstructions = null;
    private Set<Integer> processedSubroutineInstructions = null;
    private final Queue<WorklistItem> ssaWorklist = new LinkedList<WorklistItem>();
    private LinkedList<BasicBlock> blocks = new LinkedList();
    private BasicBlock currentBlock = null;
    private Long2ObjectMap<ConstNumber> intConstants = new Long2ObjectArrayMap<ConstNumber>();
    private Long2ObjectMap<ConstNumber> longConstants = new Long2ObjectArrayMap<ConstNumber>();
    private Long2ObjectMap<ConstNumber> floatConstants = new Long2ObjectArrayMap<ConstNumber>();
    private Long2ObjectMap<ConstNumber> doubleConstants = new Long2ObjectArrayMap<ConstNumber>();
    private Long2ObjectMap<ConstNumber> nullConstants = new Long2ObjectArrayMap<ConstNumber>();
    private List<BasicBlock.Pair> needGotoToCatchBlocks = new ArrayList<BasicBlock.Pair>();
    private final ValueNumberGenerator valueNumberGenerator;
    private DexEncodedMethod method;
    private SourceCode source;
    boolean throwingInstructionInCurrentBlock = false;
    private final InternalOptions options;
    private Value previousLocalValue = null;
    private List<Value> debugLocalReads = new ArrayList<Value>();
    private int nextBlockNumber = 0;

    public IRBuilder(DexEncodedMethod method, SourceCode source, InternalOptions options) {
        this(method, source, new ValueNumberGenerator(), options);
    }

    public IRBuilder(DexEncodedMethod method, SourceCode source, ValueNumberGenerator valueNumberGenerator, InternalOptions options) {
        assert (source != null);
        this.method = method;
        this.source = source;
        this.valueNumberGenerator = valueNumberGenerator;
        this.options = options;
    }

    public Int2ReferenceSortedMap<BlockInfo> getCFG() {
        return this.targets;
    }

    private void addToWorklist(BasicBlock block, int firstInstructionIndex) {
        if (!block.isFilled()) {
            this.ssaWorklist.add(new WorklistItem(block, firstInstructionIndex));
        }
    }

    private void setCurrentBlock(BasicBlock block) {
        this.currentBlock = block;
    }

    public IRCode build() throws ApiLevelException {
        assert (this.source != null);
        this.source.setUp();
        this.targets.put(-1, new BlockInfo());
        this.processedInstructions = new boolean[this.source.instructionCount()];
        this.traceBlocksWorklist.add(0);
        block0: while (!this.traceBlocksWorklist.isEmpty()) {
            int startOfBlockOffset = this.traceBlocksWorklist.remove();
            int startOfBlockIndex = this.source.instructionIndex(startOfBlockOffset);
            if (this.isIndexProcessed(startOfBlockIndex)) continue;
            for (int index = startOfBlockIndex; index < this.source.instructionCount(); ++index) {
                int nextOffset;
                this.markIndexProcessed(index);
                int closedAt = this.source.traceInstruction(index, this);
                if (closedAt != -1) {
                    if (closedAt + 1 >= this.source.instructionCount()) continue block0;
                    this.ensureBlockWithoutEnqueuing(this.source.instructionOffset(closedAt + 1));
                    continue block0;
                }
                if (index + 1 >= this.source.instructionCount() || this.targets.get(nextOffset = this.source.instructionOffset(index + 1)) == null) continue;
                this.ensureNormalSuccessorBlock(startOfBlockOffset, nextOffset);
                continue block0;
            }
        }
        this.processedInstructions = null;
        this.setCurrentBlock(((BlockInfo)this.targets.get((int)-1)).block);
        this.source.buildPrelude(this);
        this.addToWorklist(this.currentBlock, 0);
        this.processWorklist();
        assert (this.currentBlock == null);
        this.handleFallthroughToCatchBlock();
        assert (this.verifyFilledPredecessors());
        for (BasicBlock block : this.blocks) {
            block.clearCurrentDefinitions();
        }
        this.joinPredecessorsWithIdenticalPhis();
        this.splitCriticalEdges();
        IRCode ir = new IRCode(this.method, this.blocks, this.valueNumberGenerator);
        if (this.options.testing.invertConditionals) {
            IRBuilder.invertConditionalsForTesting(ir);
        }
        ir.traceBlocks();
        this.source.clear();
        this.clearCanonicalizationMaps();
        this.source = null;
        assert (ir.isConsistentSSA());
        return ir;
    }

    private void clearCanonicalizationMaps() {
        this.intConstants = null;
        this.longConstants = null;
        this.floatConstants = null;
        this.doubleConstants = null;
        this.nullConstants = null;
    }

    private boolean verifyFilledPredecessors() {
        for (BasicBlock block : this.blocks) {
            assert (this.verifyFilledPredecessors(block));
        }
        return true;
    }

    private boolean verifyFilledPredecessors(BasicBlock block) {
        assert (block.verifyFilledPredecessors());
        for (BlockInfo info : this.targets.values()) {
            if (info == null || info.block != block) continue;
            assert (info.predecessorCount() == block.getPredecessors().size());
            assert (info.normalSuccessors.size() == block.getNormalSuccessors().size());
            if (block.hasCatchHandlers() ? !$assertionsDisabled && info.exceptionalSuccessors.size() != block.getCatchHandlers().getUniqueTargets().size() : !$assertionsDisabled && block.canThrow() && !info.exceptionalSuccessors.isEmpty() && (info.exceptionalSuccessors.size() != 1 || info.exceptionalSuccessors.iterator().nextInt() >= 0)) {
                throw new AssertionError();
            }
            return true;
        }
        return true;
    }

    private void processWorklist() throws ApiLevelException {
        WorklistItem item = this.ssaWorklist.poll();
        while (item != null) {
            if (!item.block.isFilled()) {
                this.setCurrentBlock(item.block);
                this.blocks.add(this.currentBlock);
                this.currentBlock.setNumber(this.nextBlockNumber++);
                if (item instanceof MoveExceptionWorklistItem) {
                    this.processMoveExceptionItem((MoveExceptionWorklistItem)item);
                } else {
                    for (int i = item.firstInstructionIndex; i < this.source.instructionCount() && this.currentBlock != null; ++i) {
                        BlockInfo info = (BlockInfo)this.targets.get(this.source.instructionOffset(i));
                        if (info != null && info.block != this.currentBlock) {
                            this.source.closingCurrentBlockWithFallthrough(i, this);
                            this.closeCurrentBlockWithFallThrough(info.block);
                            this.addToWorklist(info.block, i);
                            break;
                        }
                        this.source.buildInstruction(this, i);
                    }
                }
            }
            item = this.ssaWorklist.poll();
        }
    }

    private void processMoveExceptionItem(MoveExceptionWorklistItem moveExceptionItem) {
        int moveExceptionDest = this.source.getMoveExceptionRegister();
        assert (moveExceptionDest >= 0);
        int targetIndex = this.source.instructionIndex(moveExceptionItem.targetOffset);
        Value out = this.writeRegister(moveExceptionDest, MoveType.OBJECT, BasicBlock.ThrowingInfo.NO_THROW, null);
        MoveException moveException = new MoveException(out);
        moveException.setPosition(this.source.getDebugPositionAtOffset(moveExceptionItem.targetOffset));
        this.currentBlock.add(moveException);
        this.currentBlock.add(new Goto());
        BasicBlock targetBlock = this.getTarget(moveExceptionItem.targetOffset);
        this.currentBlock.link(targetBlock);
        this.addToWorklist(targetBlock, targetIndex);
        this.closeCurrentBlock();
    }

    public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset) {
        this.source.resolveAndBuildSwitch(value, fallthroughOffset, payloadOffset, this);
    }

    public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset) {
        this.source.resolveAndBuildNewArrayFilledData(arrayRef, payloadOffset, this);
    }

    public void add(Instruction ir) {
        assert (!ir.isJumpInstruction());
        this.addInstruction(ir);
    }

    public void addThisArgument(int register) {
        DebugLocalInfo local = this.getCurrentLocal(register);
        Value value = this.writeRegister(register, MoveType.OBJECT, BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addInstruction(new Argument(value));
        value.markAsThis();
    }

    public void addNonThisArgument(int register, MoveType moveType) {
        DebugLocalInfo local = this.getCurrentLocal(register);
        Value value = this.writeRegister(register, moveType, BasicBlock.ThrowingInfo.NO_THROW, local);
        this.addInstruction(new Argument(value));
    }

    public void addBooleanNonThisArgument(int register) {
        DebugLocalInfo local = this.getCurrentLocal(register);
        Value value = this.writeRegister(register, MoveType.SINGLE, BasicBlock.ThrowingInfo.NO_THROW, local);
        value.setKnownToBeBoolean(true);
        this.addInstruction(new Argument(value));
    }

    public void addDebugUninitialized(int register, ConstType type) {
        if (!this.options.debug) {
            return;
        }
        Value value = this.writeRegister(register, MoveType.fromConstType(type), BasicBlock.ThrowingInfo.NO_THROW, null);
        assert (!value.hasLocalInfo());
        this.addInstruction(new DebugLocalUninitialized(type, value));
    }

    public void addDebugPosition(int line, DexString file) {
        this.addInstruction(new DebugPosition(line, file));
    }

    private void addDebugLocalWrite(MoveType type, int dest, Value in) {
        assert (this.options.debug);
        Value out = this.writeRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        DebugLocalWrite write = new DebugLocalWrite(out, in);
        assert (!write.instructionTypeCanThrow());
        this.addInstruction(write);
    }

    private Value getLocalValue(int register, DebugLocalInfo local) {
        assert (this.options.debug);
        assert (local != null);
        assert (local == this.getCurrentLocal(register));
        MoveType moveType = MoveType.fromDexType(local.type);
        return this.readRegisterIgnoreLocal(register, moveType);
    }

    private static boolean isValidFor(Value value, DebugLocalInfo local) {
        return !value.isUninitializedLocal() && value.getLocalInfo() == local;
    }

    public void addDebugLocalRead(int register, DebugLocalInfo local) {
        if (!this.options.debug) {
            return;
        }
        Value value = this.getLocalValue(register, local);
        if (IRBuilder.isValidFor(value, local)) {
            this.debugLocalReads.add(value);
        }
    }

    public void addDebugLocalStart(int register, DebugLocalInfo local) {
        if (!this.options.debug) {
            return;
        }
        Value value = this.getLocalValue(register, local);
        if (value.isPhi() || value.getLocalInfo() != local) {
            this.addDebugLocalWrite(MoveType.fromDexType(local.type), register, value);
            return;
        }
        if (!IRBuilder.isValidFor(value, local)) {
            return;
        }
        if (this.currentBlock.getInstructions().isEmpty()) {
            this.addInstruction(new DebugLocalRead());
        }
        Instruction instruction = this.currentBlock.getInstructions().getLast();
        assert (instruction.outValue() != value);
        instruction.addDebugValue(value);
        value.addDebugLocalStart(instruction);
    }

    public void addDebugLocalEnd(int register, DebugLocalInfo local) {
        Instruction instruction;
        if (!this.options.debug) {
            return;
        }
        Value value = this.getLocalValue(register, local);
        if (!IRBuilder.isValidFor(value, local)) {
            return;
        }
        if (this.currentBlock.getInstructions().isEmpty()) {
            this.addInstruction(new DebugLocalRead());
        }
        if ((instruction = this.currentBlock.getInstructions().getLast()).outValue() != value) {
            instruction.addDebugValue(value);
            value.addDebugLocalEnd(instruction);
            return;
        }
        assert (!instruction.outValue().isUsed());
        if (instruction.isDebugLocalWrite()) {
            DebugLocalWrite write = instruction.asDebugLocalWrite();
            this.currentBlock.replaceCurrentDefinitions(value, write.src());
            this.currentBlock.listIterator(write).removeOrReplaceByDebugLocalRead();
        } else {
            instruction.outValue().clearLocalInfo();
        }
    }

    public void addAdd(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Add instruction = new Add(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAddLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Add instruction = new Add(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAnd(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        And instruction = new And(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addAndLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        And instruction = new And(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addArrayGet(MemberType type, int dest, int array, int index) {
        Value in1 = this.readRegister(array, MoveType.OBJECT);
        Value in2 = this.readRegister(index, MoveType.SINGLE);
        Value out = this.writeRegister(dest, MoveType.fromMemberType(type), BasicBlock.ThrowingInfo.CAN_THROW);
        out.setKnownToBeBoolean(type == MemberType.BOOLEAN);
        ArrayGet instruction = new ArrayGet(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addArrayLength(int dest, int array) {
        Value in = this.readRegister(array, MoveType.OBJECT);
        Value out = this.writeRegister(dest, MoveType.SINGLE, BasicBlock.ThrowingInfo.CAN_THROW);
        ArrayLength instruction = new ArrayLength(out, in);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addArrayPut(MemberType type, int value, int array, int index) {
        ArrayList<Value> ins = new ArrayList<Value>(3);
        ins.add(this.readRegister(value, MoveType.fromMemberType(type)));
        ins.add(this.readRegister(array, MoveType.OBJECT));
        ins.add(this.readRegister(index, MoveType.SINGLE));
        ArrayPut instruction = new ArrayPut(type, ins);
        this.add(instruction);
    }

    public void addCheckCast(int value, DexType type) {
        Value in = this.readRegister(value, MoveType.OBJECT);
        Value out = this.writeRegister(value, MoveType.OBJECT, BasicBlock.ThrowingInfo.CAN_THROW);
        CheckCast instruction = new CheckCast(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addCmp(NumericType type, Cmp.Bias bias, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeRegister(dest, MoveType.SINGLE, BasicBlock.ThrowingInfo.NO_THROW);
        Cmp instruction = new Cmp(type, bias, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addConst(MoveType type, int dest, long value) {
        ConstNumber instruction;
        if (type == MoveType.SINGLE) {
            Value out = this.writeRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new ConstNumber(ConstType.INT_OR_FLOAT, out, value);
        } else {
            assert (type == MoveType.WIDE);
            Value out = this.writeRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new ConstNumber(ConstType.LONG_OR_DOUBLE, out, value);
        }
        assert (!instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    private void canonicalizeAndAddConst(ConstType type, int dest, long value, Long2ObjectMap<ConstNumber> table) {
        ConstNumber existing = (ConstNumber)table.get(value);
        if (existing != null) {
            this.currentBlock.writeCurrentDefinition(dest, existing.outValue(), BasicBlock.ThrowingInfo.NO_THROW);
        } else {
            Value out = this.writeRegister(dest, MoveType.fromConstType(type), BasicBlock.ThrowingInfo.NO_THROW);
            ConstNumber instruction = new ConstNumber(type, out, value);
            BasicBlock entryBlock = this.blocks.get(0);
            if (this.currentBlock != entryBlock) {
                InstructionListIterator it = entryBlock.listIterator();
                while (it.hasNext()) {
                    if (((Instruction)it.next()).isArgument()) continue;
                    it.previous();
                    break;
                }
                it.add(instruction);
            } else {
                this.add(instruction);
            }
            table.put(value, instruction);
        }
    }

    public void addLongConst(int dest, long value) {
        this.canonicalizeAndAddConst(ConstType.LONG, dest, value, this.longConstants);
    }

    public void addDoubleConst(int dest, long value) {
        this.canonicalizeAndAddConst(ConstType.DOUBLE, dest, value, this.doubleConstants);
    }

    public void addIntConst(int dest, long value) {
        this.canonicalizeAndAddConst(ConstType.INT, dest, value, this.intConstants);
    }

    public void addFloatConst(int dest, long value) {
        this.canonicalizeAndAddConst(ConstType.FLOAT, dest, value, this.floatConstants);
    }

    public void addNullConst(int dest, long value) {
        this.canonicalizeAndAddConst(ConstType.OBJECT, dest, value, this.nullConstants);
    }

    public void addConstClass(int dest, DexType type) {
        Value out = this.writeRegister(dest, MoveType.OBJECT, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstClass instruction = new ConstClass(out, type);
        assert (instruction.instructionTypeCanThrow());
        this.add(instruction);
    }

    public void addConstMethodHandle(int dest, DexMethodHandle methodHandle) throws ApiLevelException {
        if (!this.options.canUseConstantMethodHandle()) {
            throw new ApiLevelException(AndroidApiLevel.P, "Const-method-handle", null);
        }
        Value out = this.writeRegister(dest, MoveType.OBJECT, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstMethodHandle instruction = new ConstMethodHandle(out, methodHandle);
        this.add(instruction);
    }

    public void addConstString(int dest, DexString string) {
        Value out = this.writeRegister(dest, MoveType.OBJECT, BasicBlock.ThrowingInfo.CAN_THROW);
        ConstString instruction = new ConstString(out, string);
        this.add(instruction);
    }

    public void addDiv(NumericType type, int dest, int left, int right) {
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Div instruction = new Div(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.add(instruction);
    }

    public void addDivLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Div instruction = new Div(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.add(instruction);
    }

    public Monitor addMonitor(Monitor.Type type, int monitor) {
        Value in = this.readRegister(monitor, MoveType.OBJECT);
        Monitor monitorEnter = new Monitor(type, in);
        this.add(monitorEnter);
        return monitorEnter;
    }

    public void addMove(MoveType type, int dest, int src) {
        DebugLocalInfo destLocal;
        Value in = this.readRegister(src, type);
        if (this.options.debug && (destLocal = this.getCurrentLocal(dest)) != null && destLocal != in.getLocalInfo()) {
            this.addDebugLocalWrite(type, dest, in);
            return;
        }
        this.currentBlock.writeCurrentDefinition(dest, in, BasicBlock.ThrowingInfo.NO_THROW);
    }

    public void addMul(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Mul instruction = new Mul(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addMulLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Mul instruction = new Mul(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addRem(NumericType type, int dest, int left, int right) {
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Rem instruction = new Rem(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.addInstruction(instruction);
    }

    public void addRemLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        boolean canThrow = type != NumericType.DOUBLE && type != NumericType.FLOAT;
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, canThrow ? BasicBlock.ThrowingInfo.CAN_THROW : BasicBlock.ThrowingInfo.NO_THROW);
        Rem instruction = new Rem(type, out, in1, in2);
        assert (instruction.instructionTypeCanThrow() == canThrow);
        this.addInstruction(instruction);
    }

    public void addGoto(int targetOffset) {
        this.addInstruction(new Goto());
        BasicBlock targetBlock = this.getTarget(targetOffset);
        if (this.currentBlock.hasCatchSuccessor(targetBlock)) {
            this.needGotoToCatchBlocks.add(new BasicBlock.Pair(this.currentBlock, targetBlock));
        } else {
            this.currentBlock.link(targetBlock);
        }
        this.addToWorklist(targetBlock, this.source.instructionIndex(targetOffset));
        this.closeCurrentBlock();
    }

    private void addTrivialIf(int trueTargetOffset, int falseTargetOffset) {
        assert (trueTargetOffset == falseTargetOffset);
        BasicBlock target = this.getTarget(trueTargetOffset);
        target.decrementUnfilledPredecessorCount();
        this.addInstruction(new Goto());
        this.currentBlock.link(target);
        this.addToWorklist(target, this.source.instructionIndex(trueTargetOffset));
        this.closeCurrentBlock();
    }

    private void addNonTrivialIf(If instruction, int trueTargetOffset, int falseTargetOffset) {
        this.addInstruction(instruction);
        BasicBlock trueTarget = this.getTarget(trueTargetOffset);
        BasicBlock falseTarget = this.getTarget(falseTargetOffset);
        this.currentBlock.link(trueTarget);
        this.currentBlock.link(falseTarget);
        this.addToWorklist(falseTarget, this.source.instructionIndex(falseTargetOffset));
        this.addToWorklist(trueTarget, this.source.instructionIndex(trueTargetOffset));
        this.closeCurrentBlock();
    }

    public void addIf(If.Type type, int value1, int value2, int trueTargetOffset, int falseTargetOffset) {
        if (trueTargetOffset == falseTargetOffset) {
            this.addTrivialIf(trueTargetOffset, falseTargetOffset);
        } else {
            ArrayList<Value> values = new ArrayList<Value>(2);
            values.add(this.readRegister(value1, MoveType.SINGLE));
            values.add(this.readRegister(value2, MoveType.SINGLE));
            If instruction = new If(type, values);
            this.addNonTrivialIf(instruction, trueTargetOffset, falseTargetOffset);
        }
    }

    public void addIfZero(If.Type type, int value, int trueTargetOffset, int falseTargetOffset) {
        if (trueTargetOffset == falseTargetOffset) {
            this.addTrivialIf(trueTargetOffset, falseTargetOffset);
        } else {
            If instruction = new If(type, this.readRegister(value, MoveType.SINGLE));
            this.addNonTrivialIf(instruction, trueTargetOffset, falseTargetOffset);
        }
    }

    public void addInstanceGet(MemberType type, int dest, int object, DexField field) {
        Value in = this.readRegister(object, MoveType.OBJECT);
        Value out = this.writeRegister(dest, MoveType.fromMemberType(type), BasicBlock.ThrowingInfo.CAN_THROW);
        out.setKnownToBeBoolean(type == MemberType.BOOLEAN);
        InstanceGet instruction = new InstanceGet(type, out, in, field);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addInstanceOf(int dest, int value, DexType type) {
        Value in = this.readRegister(value, MoveType.OBJECT);
        Value out = this.writeRegister(dest, MoveType.SINGLE, BasicBlock.ThrowingInfo.CAN_THROW);
        InstanceOf instruction = new InstanceOf(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addInstancePut(MemberType type, int value, int object, DexField field) {
        ArrayList<Value> values = new ArrayList<Value>(2);
        values.add(this.readRegister(value, MoveType.fromMemberType(type)));
        values.add(this.readRegister(object, MoveType.OBJECT));
        InstancePut instruction = new InstancePut(type, values, field);
        this.add(instruction);
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<Value> arguments) throws ApiLevelException {
        if (type == Invoke.Type.POLYMORPHIC && !this.options.canUseInvokePolymorphic()) {
            throw new ApiLevelException(AndroidApiLevel.O, "MethodHandle.invoke and MethodHandle.invokeExact", null);
        }
        this.add(Invoke.create(type, item, callSiteProto, null, arguments));
    }

    public void addInvoke(Invoke.Type type, DexItem item, DexProto callSiteProto, List<MoveType> types, List<Integer> registers) throws ApiLevelException {
        assert (types.size() == registers.size());
        ArrayList<Value> arguments = new ArrayList<Value>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            arguments.add(this.readRegister(registers.get(i), types.get(i)));
        }
        this.addInvoke(type, item, callSiteProto, arguments);
    }

    public void addInvokeCustomRegisters(DexCallSite callSite, int argumentRegisterCount, int[] argumentRegisters) {
        int registerIndex = 0;
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        ArrayList<Value> arguments = new ArrayList<Value>(argumentRegisterCount);
        if (!bootstrapMethod.isStaticHandle()) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], MoveType.OBJECT));
            registerIndex += MoveType.OBJECT.requiredRegisters();
        }
        String shorty = callSite.methodProto.shorty.toString();
        for (int i = 1; i < shorty.length(); ++i) {
            MoveType moveType = MoveType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(argumentRegisters[registerIndex], moveType));
            registerIndex += moveType.requiredRegisters();
        }
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeCustomRange(DexCallSite callSite, int argumentCount, int firstArgumentRegister) {
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount);
        int register = firstArgumentRegister;
        if (!bootstrapMethod.isStaticHandle()) {
            arguments.add(this.readRegister(register, MoveType.OBJECT));
            register += MoveType.OBJECT.requiredRegisters();
        }
        String shorty = callSite.methodProto.shorty.toString();
        for (int i = 1; i < shorty.length(); ++i) {
            MoveType moveType = MoveType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(register, moveType));
            register += moveType.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeCustom(DexCallSite callSite, List<MoveType> types, List<Integer> registers) {
        assert (types.size() == registers.size());
        ArrayList<Value> arguments = new ArrayList<Value>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            arguments.add(this.readRegister(registers.get(i), types.get(i)));
        }
        this.add(new InvokeCustom(callSite, null, arguments));
    }

    public void addInvokeRegisters(Invoke.Type type, DexMethod method, DexProto callSiteProto, int argumentRegisterCount, int[] argumentRegisters) throws ApiLevelException {
        ArrayList<Value> arguments = new ArrayList<Value>(argumentRegisterCount);
        int registerIndex = 0;
        if (type != Invoke.Type.STATIC) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], MoveType.OBJECT));
            registerIndex += MoveType.OBJECT.requiredRegisters();
        }
        DexString methodShorty = type == Invoke.Type.POLYMORPHIC ? callSiteProto.shorty : method.proto.shorty;
        String shorty = methodShorty.toString();
        for (int i = 1; i < methodShorty.size; ++i) {
            MoveType moveType = MoveType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(argumentRegisters[registerIndex], moveType));
            registerIndex += moveType.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(registerIndex, argumentRegisterCount);
        this.addInvoke(type, method, callSiteProto, arguments);
    }

    public void addInvokeNewArray(DexType type, int argumentCount, int[] argumentRegisters) throws ApiLevelException {
        int registerIndex;
        String descriptor = type.descriptor.toString();
        assert (descriptor.charAt(0) == '[');
        assert (descriptor.length() >= 2);
        MoveType moveType = MoveType.fromTypeDescriptorChar(descriptor.charAt(1));
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount / moveType.requiredRegisters());
        for (registerIndex = 0; registerIndex < argumentCount; registerIndex += moveType.requiredRegisters()) {
            arguments.add(this.readRegister(argumentRegisters[registerIndex], moveType));
            if (moveType != MoveType.WIDE) continue;
            assert (registerIndex < argumentCount - 1);
            assert (argumentRegisters[registerIndex] == argumentRegisters[registerIndex + 1] + 1);
        }
        this.checkInvokeArgumentRegisters(registerIndex, argumentCount);
        this.addInvoke(Invoke.Type.NEW_ARRAY, type, null, arguments);
    }

    public void addInvokeRange(Invoke.Type type, DexMethod method, DexProto callSiteProto, int argumentCount, int firstArgumentRegister) throws ApiLevelException {
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount);
        int register = firstArgumentRegister;
        if (type != Invoke.Type.STATIC) {
            arguments.add(this.readRegister(register, MoveType.OBJECT));
            register += MoveType.OBJECT.requiredRegisters();
        }
        DexString methodShorty = type == Invoke.Type.POLYMORPHIC ? callSiteProto.shorty : method.proto.shorty;
        String shorty = methodShorty.toString();
        for (int i = 1; i < methodShorty.size; ++i) {
            MoveType moveType = MoveType.fromTypeDescriptorChar(shorty.charAt(i));
            arguments.add(this.readRegister(register, moveType));
            register += moveType.requiredRegisters();
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.addInvoke(type, method, callSiteProto, arguments);
    }

    public void addInvokeRangeNewArray(DexType type, int argumentCount, int firstArgumentRegister) throws ApiLevelException {
        int register;
        String descriptor = type.descriptor.toString();
        assert (descriptor.charAt(0) == '[');
        assert (descriptor.length() >= 2);
        MoveType moveType = MoveType.fromTypeDescriptorChar(descriptor.charAt(1));
        ArrayList<Value> arguments = new ArrayList<Value>(argumentCount / moveType.requiredRegisters());
        for (register = firstArgumentRegister; register < firstArgumentRegister + argumentCount; register += moveType.requiredRegisters()) {
            arguments.add(this.readRegister(register, moveType));
        }
        this.checkInvokeArgumentRegisters(register, firstArgumentRegister + argumentCount);
        this.addInvoke(Invoke.Type.NEW_ARRAY, type, null, arguments);
    }

    private void checkInvokeArgumentRegisters(int expected, int actual) {
        if (expected != actual) {
            throw new CompilationError("Invalid invoke instruction. Expected use of " + expected + " argument registers, " + "found actual use of " + actual);
        }
    }

    public void addMoveException(int dest) {
        Value out = this.writeRegister(dest, MoveType.OBJECT, BasicBlock.ThrowingInfo.NO_THROW);
        assert (!out.hasLocalInfo());
        MoveException instruction = new MoveException(out);
        assert (!instruction.instructionTypeCanThrow());
        if (!this.currentBlock.getInstructions().isEmpty() && this.currentBlock.getInstructions().getLast().isDebugPosition()) {
            DebugPosition position = this.currentBlock.getInstructions().getLast().asDebugPosition();
            position.moveDebugValues(instruction);
            instruction.setPosition(position);
            this.currentBlock.removeInstruction(position);
        }
        if (!this.currentBlock.getInstructions().isEmpty()) {
            throw new CompilationError("Invalid MoveException instruction encountered. The MoveException instruction is not the first instruction in the block in " + this.method.qualifiedName() + ".");
        }
        this.addInstruction(instruction);
    }

    public void addMoveResult(MoveType type, int dest) {
        LinkedList<Instruction> instructions = this.currentBlock.getInstructions();
        Invoke invoke = ((Instruction)instructions.get(instructions.size() - 1)).asInvoke();
        assert (invoke.outValue() == null);
        assert (invoke.instructionTypeCanThrow());
        invoke.setOutValue(this.writeRegister(dest, type, BasicBlock.ThrowingInfo.CAN_THROW));
    }

    public void addBooleanMoveResult(MoveType type, int dest) {
        LinkedList<Instruction> instructions = this.currentBlock.getInstructions();
        Invoke invoke = ((Instruction)instructions.get(instructions.size() - 1)).asInvoke();
        assert (invoke.outValue() == null);
        assert (invoke.instructionTypeCanThrow());
        Value outValue = this.writeRegister(dest, type, BasicBlock.ThrowingInfo.CAN_THROW);
        outValue.setKnownToBeBoolean(true);
        invoke.setOutValue(outValue);
    }

    public void addNeg(NumericType type, int dest, int value) {
        Value in = this.readNumericRegister(value, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Neg instruction = new Neg(type, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNot(NumericType type, int dest, int value) {
        Value in = this.readNumericRegister(value, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Not instruction = new Not(type, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewArrayEmpty(int dest, int size, DexType type) {
        assert (type.isArrayType());
        Value in = this.readRegister(size, MoveType.SINGLE);
        Value out = this.writeRegister(dest, MoveType.OBJECT, BasicBlock.ThrowingInfo.CAN_THROW);
        NewArrayEmpty instruction = new NewArrayEmpty(out, in, type);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addNewArrayFilledData(int arrayRef, int elementWidth, long size, short[] data) {
        this.add(new NewArrayFilledData(this.readRegister(arrayRef, MoveType.OBJECT), elementWidth, size, data));
    }

    public void addNewInstance(int dest, DexType type) {
        Value out = this.writeRegister(dest, MoveType.OBJECT, BasicBlock.ThrowingInfo.CAN_THROW);
        NewInstance instruction = new NewInstance(type, out);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addReturn(MoveType type, int value) {
        Value in = this.readRegister(value, type);
        this.source.buildPostlude(this);
        this.addInstruction(new Return(in, type));
        this.closeCurrentBlock();
    }

    public void addReturn() {
        this.source.buildPostlude(this);
        this.addInstruction(new Return());
        this.closeCurrentBlock();
    }

    public void addStaticGet(MemberType type, int dest, DexField field) {
        Value out = this.writeRegister(dest, MoveType.fromMemberType(type), BasicBlock.ThrowingInfo.CAN_THROW);
        out.setKnownToBeBoolean(type == MemberType.BOOLEAN);
        StaticGet instruction = new StaticGet(type, out, field);
        assert (instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addStaticPut(MemberType type, int value, DexField field) {
        Value in = this.readRegister(value, MoveType.fromMemberType(type));
        this.add(new StaticPut(type, in, field));
    }

    public void addSub(NumericType type, int dest, int left, int right) {
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Sub instruction = new Sub(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addRsubLiteral(NumericType type, int dest, int value, int constant) {
        assert (type != NumericType.DOUBLE);
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Sub instruction = new Sub(type, out, in2, in1);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    private void addSwitchIf(int key, int value, int caseOffset, int fallthroughOffset) {
        if (key == 0) {
            this.addIfZero(If.Type.EQ, value, caseOffset, fallthroughOffset);
        } else if (caseOffset == fallthroughOffset) {
            this.addTrivialIf(caseOffset, fallthroughOffset);
        } else {
            ArrayList<Value> values = new ArrayList<Value>(2);
            values.add(this.readRegister(value, MoveType.SINGLE));
            values.add(this.readLiteral(NumericType.INT, key));
            If instruction = new If(If.Type.EQ, values);
            this.addNonTrivialIf(instruction, caseOffset, fallthroughOffset);
        }
    }

    public void addSwitch(int value, int[] keys, int fallthroughOffset, int[] labelOffsets) {
        int numberOfTargets = labelOffsets.length;
        assert (keys.length == 1 || keys.length == numberOfTargets);
        if (numberOfTargets == 0) {
            this.addGoto(fallthroughOffset);
            return;
        }
        Value switchValue = this.readRegister(value, MoveType.SINGLE);
        IntArrayList nonFallthroughKeys = new IntArrayList(numberOfTargets);
        IntArrayList nonFallthroughOffsets = new IntArrayList(numberOfTargets);
        int numberOfFallthroughs = 0;
        if (keys.length == 1) {
            int key = keys[0];
            for (int i = 0; i < numberOfTargets; ++i) {
                if (labelOffsets[i] != fallthroughOffset) {
                    nonFallthroughKeys.add(key);
                    nonFallthroughOffsets.add(labelOffsets[i]);
                } else {
                    ++numberOfFallthroughs;
                }
                ++key;
            }
        } else {
            assert (keys.length == numberOfTargets);
            for (int i = 0; i < numberOfTargets; ++i) {
                if (labelOffsets[i] != fallthroughOffset) {
                    nonFallthroughKeys.add(keys[i]);
                    nonFallthroughOffsets.add(labelOffsets[i]);
                    continue;
                }
                ++numberOfFallthroughs;
            }
        }
        ((BlockInfo)this.targets.get((int)fallthroughOffset)).block.decrementUnfilledPredecessorCount(numberOfFallthroughs);
        if (numberOfFallthroughs == numberOfTargets) {
            assert (nonFallthroughKeys.size() == 0);
            this.addGoto(fallthroughOffset);
            return;
        }
        keys = nonFallthroughKeys.toIntArray();
        labelOffsets = nonFallthroughOffsets.toIntArray();
        this.addInstruction(this.createSwitch(switchValue, keys, fallthroughOffset, labelOffsets));
        this.closeCurrentBlock();
    }

    private Switch createSwitch(Value value, int[] keys, int fallthroughOffset, int[] targetOffsets) {
        assert (keys.length == targetOffsets.length);
        int[] targetBlockIndices = new int[targetOffsets.length];
        HashMap<Integer, Integer> offsetToBlockIndex = new HashMap<Integer, Integer>();
        BasicBlock fallthroughBlock = this.getTarget(fallthroughOffset);
        this.currentBlock.link(fallthroughBlock);
        this.addToWorklist(fallthroughBlock, this.source.instructionIndex(fallthroughOffset));
        int fallthroughBlockIndex = this.currentBlock.getSuccessors().size() - 1;
        offsetToBlockIndex.put(fallthroughOffset, fallthroughBlockIndex);
        for (int i = 0; i < targetOffsets.length; ++i) {
            int targetOffset = targetOffsets[i];
            BasicBlock targetBlock = this.getTarget(targetOffset);
            Integer targetBlockIndex = (Integer)offsetToBlockIndex.get(targetOffset);
            if (targetBlockIndex == null) {
                this.currentBlock.link(targetBlock);
                this.addToWorklist(targetBlock, this.source.instructionIndex(targetOffset));
                int successorIndex = this.currentBlock.getSuccessors().size() - 1;
                offsetToBlockIndex.put(targetOffset, successorIndex);
                targetBlockIndices[i] = successorIndex;
                continue;
            }
            targetBlock.decrementUnfilledPredecessorCount();
            targetBlockIndices[i] = targetBlockIndex;
        }
        return new Switch(value, keys, targetBlockIndices, fallthroughBlockIndex);
    }

    public void addThrow(int value) {
        Value in = this.readRegister(value, MoveType.OBJECT);
        this.addInstruction(new Throw(in));
        this.closeCurrentBlock();
    }

    public void addOr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Or instruction = new Or(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addOrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Or instruction = new Or(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShl(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, MoveType.SINGLE);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shl instruction = new Shl(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShlLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shl instruction = new Shl(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, MoveType.SINGLE);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shr instruction = new Shr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addShrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Shr instruction = new Shr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addUshr(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readRegister(right, MoveType.SINGLE);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Ushr instruction = new Ushr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addUshrLiteral(NumericType type, int dest, int value, int constant) {
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        Value in2 = this.readLiteral(type, constant);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Ushr instruction = new Ushr(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addXor(NumericType type, int dest, int left, int right) {
        assert (this.isIntegerType(type));
        Value in1 = this.readNumericRegister(left, type);
        Value in2 = this.readNumericRegister(right, type);
        Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
        Instruction instruction = in2.isConstNumber() && in2.getConstInstruction().asConstNumber().isIntegerNegativeOne(type) ? new Not(type, out, in1) : new Xor(type, out, in1, in2);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addXorLiteral(NumericType type, int dest, int value, int constant) {
        Instruction instruction;
        assert (this.isNonLongIntegerType(type));
        Value in1 = this.readNumericRegister(value, type);
        if (constant == -1) {
            Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new Not(type, out, in1);
        } else {
            Value in2 = this.readLiteral(type, constant);
            Value out = this.writeNumericRegister(dest, type, BasicBlock.ThrowingInfo.NO_THROW);
            instruction = new Xor(type, out, in1, in2);
        }
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public void addConversion(NumericType to, NumericType from, int dest, int source) {
        Value in = this.readNumericRegister(source, from);
        Value out = this.writeNumericRegister(dest, to, BasicBlock.ThrowingInfo.NO_THROW);
        NumberConversion instruction = new NumberConversion(from, to, out, in);
        assert (!instruction.instructionTypeCanThrow());
        this.addInstruction(instruction);
    }

    public Value readRegister(int register, MoveType type) {
        DebugLocalInfo local = this.getCurrentLocal(register);
        Value value = this.readRegister(register, this.currentBlock, BasicBlock.EdgeType.NON_EDGE, type, local);
        if (local != null && value.getLocalInfo() != local && !value.isUninitializedLocal()) {
            throw new InvalidDebugInfoException("Attempt to read local " + local + " but no local information was associated with the value being read.");
        }
        assert (!value.hasLocalInfo() || value.getDebugLocalEnds() != null || this.source.verifyLocalInScope(value.getLocalInfo()));
        return value;
    }

    public Value readRegisterIgnoreLocal(int register, MoveType type) {
        DebugLocalInfo local = this.getCurrentLocal(register);
        return this.readRegister(register, this.currentBlock, BasicBlock.EdgeType.NON_EDGE, type, local);
    }

    public Value readRegister(int register, BasicBlock block, BasicBlock.EdgeType readingEdge, MoveType type, DebugLocalInfo local) {
        this.checkRegister(register);
        Value value = block.readCurrentDefinition(register, readingEdge);
        return value != null ? value : this.readRegisterRecursive(register, block, readingEdge, type, local);
    }

    private Value readRegisterRecursive(int register, BasicBlock block, BasicBlock.EdgeType readingEdge, MoveType type, DebugLocalInfo local) {
        Value value;
        if (!block.isSealed()) {
            assert (!this.blocks.isEmpty()) : "No write to " + register;
            Phi phi = new Phi(this.valueNumberGenerator.next(), block, type, local);
            block.addIncompletePhi(register, phi, readingEdge);
            value = phi;
        } else if (block.getPredecessors().size() == 1) {
            assert (block.verifyFilledPredecessors());
            BasicBlock pred = block.getPredecessors().get(0);
            BasicBlock.EdgeType edgeType = pred.getEdgeType(block);
            value = this.readRegister(register, pred, edgeType, type, local);
        } else {
            Phi phi = new Phi(this.valueNumberGenerator.next(), block, type, local);
            block.updateCurrentDefinition(register, phi, readingEdge);
            phi.addOperands(this, register);
            value = block.readCurrentDefinition(register, readingEdge);
        }
        block.updateCurrentDefinition(register, value, readingEdge);
        return value;
    }

    public Value readNumericRegister(int register, NumericType type) {
        return this.readRegister(register, type.moveTypeFor());
    }

    public Value readLiteral(NumericType type, long constant) {
        Value value = new Value(this.valueNumberGenerator.next(), MoveType.fromNumericType(type), null);
        this.add(new ConstNumber(ConstType.fromNumericType(type), value, constant));
        return value;
    }

    private Value writeRegister(int register, MoveType type, BasicBlock.ThrowingInfo throwing, DebugLocalInfo local) {
        this.checkRegister(register);
        Value value = new Value(this.valueNumberGenerator.next(), type, local);
        this.currentBlock.writeCurrentDefinition(register, value, throwing);
        return value;
    }

    public Value writeRegister(int register, MoveType type, BasicBlock.ThrowingInfo throwing) {
        DebugLocalInfo local = this.getCurrentLocal(register);
        this.previousLocalValue = local == null ? null : this.readRegisterIgnoreLocal(register, type);
        return this.writeRegister(register, type, throwing, local);
    }

    public Value writeNumericRegister(int register, NumericType type, BasicBlock.ThrowingInfo throwing) {
        return this.writeRegister(register, type.moveTypeFor(), throwing);
    }

    private DebugLocalInfo getCurrentLocal(int register) {
        return this.options.debug ? this.source.getCurrentLocal(register) : null;
    }

    private void checkRegister(int register) {
        if (register < 0) {
            throw new InternalCompilerError("Invalid register");
        }
        if (!this.source.verifyRegister(register)) {
            throw new CompilationError("Invalid use of register " + register);
        }
    }

    void ensureBlockForThrowingInstruction() {
        if (!this.throwingInstructionInCurrentBlock) {
            return;
        }
        BasicBlock block = new BasicBlock();
        block.setNumber(this.nextBlockNumber++);
        this.blocks.add(block);
        block.incrementUnfilledPredecessorCount();
        int freshOffset = -2;
        while (this.targets.containsKey(freshOffset)) {
            --freshOffset;
        }
        this.targets.put(freshOffset, (BlockInfo)null);
        for (int offset : this.source.getCurrentCatchHandlers().getUniqueTargets()) {
            BlockInfo target = (BlockInfo)this.targets.get(offset);
            assert (!target.block.isSealed());
            target.block.incrementUnfilledPredecessorCount();
            target.addExceptionalPredecessor(freshOffset);
        }
        this.addInstruction(new Goto());
        this.currentBlock.link(block);
        this.closeCurrentBlock();
        this.setCurrentBlock(block);
    }

    private void addInstruction(Instruction ir) {
        this.attachLocalValues(ir);
        this.currentBlock.add(ir);
        if (ir.instructionTypeCanThrow()) {
            assert (this.source.verifyCurrentInstructionCanThrow());
            CatchHandlers<Integer> catchHandlers = this.source.getCurrentCatchHandlers();
            if (catchHandlers != null) {
                assert (!this.throwingInstructionInCurrentBlock);
                this.throwingInstructionInCurrentBlock = true;
                ArrayList<BasicBlock> targets = new ArrayList<BasicBlock>(catchHandlers.getAllTargets().size());
                int moveExceptionDest = this.source.getMoveExceptionRegister();
                if (moveExceptionDest < 0) {
                    for (int targetOffset : catchHandlers.getAllTargets()) {
                        BasicBlock target = this.getTarget(targetOffset);
                        this.addToWorklist(target, this.source.instructionIndex(targetOffset));
                        targets.add(target);
                    }
                } else {
                    IdentityHashMap<BasicBlock, BasicBlock> moveExceptionHeaders = new IdentityHashMap<BasicBlock, BasicBlock>(catchHandlers.getUniqueTargets().size());
                    for (int targetOffset : catchHandlers.getAllTargets()) {
                        BasicBlock target = this.getTarget(targetOffset);
                        BasicBlock header = (BasicBlock)moveExceptionHeaders.get(target);
                        if (header == null) {
                            header = new BasicBlock();
                            header.incrementUnfilledPredecessorCount();
                            moveExceptionHeaders.put(target, header);
                            this.ssaWorklist.add(new MoveExceptionWorklistItem(header, targetOffset));
                        }
                        targets.add(header);
                    }
                }
                this.currentBlock.linkCatchSuccessors(catchHandlers.getGuards(), targets);
            }
        }
    }

    private void attachLocalValues(Instruction ir) {
        if (!this.options.debug) {
            assert (this.previousLocalValue == null);
            assert (this.debugLocalReads.isEmpty());
            return;
        }
        if (this.previousLocalValue != null && this.previousLocalValue.getLocalInfo() == ir.getLocalInfo()) {
            assert (ir.outValue() != null);
            ir.addDebugValue(this.previousLocalValue);
        }
        for (Value value : this.debugLocalReads) {
            ir.addDebugValue(value);
        }
        this.previousLocalValue = null;
        this.debugLocalReads.clear();
    }

    BlockInfo ensureBlockWithoutEnqueuing(int offset) {
        assert (offset != -1);
        BlockInfo info = (BlockInfo)this.targets.get(offset);
        if (info == null) {
            if (offset >= 0 && this.isOffsetProcessed(offset)) {
                int blockStartOffset = this.getBlockStartOffset(offset);
                BlockInfo existing = (BlockInfo)this.targets.get(blockStartOffset);
                info = existing.split(blockStartOffset, offset, this.targets);
            } else {
                info = new BlockInfo();
            }
            this.targets.put(offset, info);
        }
        return info;
    }

    private int getBlockStartOffset(int offset) {
        if (this.targets.containsKey(offset)) {
            return offset;
        }
        return this.targets.headMap(offset).lastIntKey();
    }

    private BlockInfo ensureBlock(int offset) {
        if (offset >= 0 && !this.isOffsetProcessed(offset)) {
            this.traceBlocksWorklist.add(offset);
        }
        return this.ensureBlockWithoutEnqueuing(offset);
    }

    private boolean isOffsetProcessed(int offset) {
        return this.isIndexProcessed(this.source.instructionIndex(offset));
    }

    private boolean isIndexProcessed(int index) {
        if (index < this.processedInstructions.length) {
            return this.processedInstructions[index];
        }
        this.ensureSubroutineProcessedInstructions();
        return this.processedSubroutineInstructions.contains(index);
    }

    private void markIndexProcessed(int index) {
        assert (!this.isIndexProcessed(index));
        if (index < this.processedInstructions.length) {
            this.processedInstructions[index] = true;
            return;
        }
        this.ensureSubroutineProcessedInstructions();
        this.processedSubroutineInstructions.add(index);
    }

    private void ensureSubroutineProcessedInstructions() {
        if (this.processedSubroutineInstructions == null) {
            this.processedSubroutineInstructions = new HashSet<Integer>();
        }
    }

    private void ensureSuccessorBlock(int sourceOffset, int targetOffset, boolean normal) {
        BlockInfo targetInfo = this.ensureBlock(targetOffset);
        int sourceStartOffset = this.getBlockStartOffset(sourceOffset);
        BlockInfo sourceInfo = (BlockInfo)this.targets.get(sourceStartOffset);
        if (normal) {
            sourceInfo.addNormalSuccessor(targetOffset);
            targetInfo.addNormalPredecessor(sourceStartOffset);
        } else {
            sourceInfo.addExceptionalSuccessor(targetOffset);
            targetInfo.addExceptionalPredecessor(sourceStartOffset);
        }
        targetInfo.block.incrementUnfilledPredecessorCount();
    }

    void ensureNormalSuccessorBlock(int sourceOffset, int targetOffset) {
        this.ensureSuccessorBlock(sourceOffset, targetOffset, true);
    }

    void ensureExceptionalSuccessorBlock(int sourceOffset, int targetOffset) {
        this.ensureSuccessorBlock(sourceOffset, targetOffset, false);
    }

    private BasicBlock getTarget(int offset) {
        return ((BlockInfo)this.targets.get((int)offset)).block;
    }

    private void closeCurrentBlock() {
        assert (this.currentBlock != null);
        this.currentBlock.close(this);
        this.setCurrentBlock(null);
        this.throwingInstructionInCurrentBlock = false;
    }

    private void closeCurrentBlockWithFallThrough(BasicBlock nextBlock) {
        assert (this.currentBlock != null);
        this.addInstruction(new Goto());
        if (this.currentBlock.hasCatchSuccessor(nextBlock)) {
            this.needGotoToCatchBlocks.add(new BasicBlock.Pair(this.currentBlock, nextBlock));
        } else {
            this.currentBlock.link(nextBlock);
        }
        this.closeCurrentBlock();
    }

    private void handleFallthroughToCatchBlock() {
        for (BasicBlock.Pair pair : this.needGotoToCatchBlocks) {
            BasicBlock source = pair.first;
            BasicBlock target = pair.second;
            BasicBlock newBlock = BasicBlock.createGotoBlock(target, this.nextBlockNumber++);
            this.blocks.add(newBlock);
            newBlock.incrementUnfilledPredecessorCount();
            source.replaceSuccessor(target, newBlock);
            newBlock.getPredecessors().add(source);
            source.getSuccessors().add(target);
            target.getPredecessors().add(newBlock);
            assert (source.hasCatchSuccessor(newBlock));
            assert (!source.hasCatchSuccessor(target));
            if (source.isFilled()) {
                newBlock.filledPredecessor(this);
            }
            target.filledPredecessor(this);
        }
    }

    public void joinPredecessorsWithIdenticalPhis() {
        ArrayList<BasicBlock> blocksToAdd = new ArrayList<BasicBlock>();
        for (BasicBlock block : this.blocks) {
            if (block.hasIncompletePhis()) {
                throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not define on all control-flow paths leading to the use.");
            }
            if (block.entry() instanceof MoveException) continue;
            ArrayList<Integer> operandsToRemove = new ArrayList<Integer>();
            HashMap<ValueList, Integer> values = new HashMap<ValueList, Integer>();
            HashMap<Integer, BasicBlock> joinBlocks = new HashMap<Integer, BasicBlock>();
            if (block.getPhis().size() > 0) {
                Phi phi = block.getPhis().get(0);
                for (int operandIndex = 0; operandIndex < phi.getOperands().size(); ++operandIndex) {
                    ValueList v = ValueList.fromPhis(block.getPhis(), operandIndex);
                    BasicBlock predecessor = block.getPredecessors().get(operandIndex);
                    if (values.containsKey(v)) {
                        int otherPredecessorIndex = (Integer)values.get(v);
                        BasicBlock joinBlock = (BasicBlock)joinBlocks.get(otherPredecessorIndex);
                        if (joinBlock == null) {
                            joinBlock = BasicBlock.createGotoBlock(block, this.blocks.size() + blocksToAdd.size());
                            joinBlocks.put(otherPredecessorIndex, joinBlock);
                            blocksToAdd.add(joinBlock);
                            BasicBlock otherPredecessor = block.getPredecessors().get(otherPredecessorIndex);
                            joinBlock.getPredecessors().add(otherPredecessor);
                            otherPredecessor.replaceSuccessor(block, joinBlock);
                            block.getPredecessors().set(otherPredecessorIndex, joinBlock);
                        }
                        joinBlock.getPredecessors().add(predecessor);
                        predecessor.replaceSuccessor(block, joinBlock);
                        operandsToRemove.add(operandIndex);
                        continue;
                    }
                    values.put(v, operandIndex);
                }
            }
            block.removePredecessorsByIndex(operandsToRemove);
            block.removePhisByIndex(operandsToRemove);
        }
        this.blocks.addAll(blocksToAdd);
    }

    private void splitCriticalEdges() {
        ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() <= 1) continue;
            if (block.entry() instanceof MoveException) {
                block.splitCriticalExceptionEdges(this.valueNumberGenerator, newBlock -> {
                    newBlock.setNumber(this.blocks.size() + newBlocks.size());
                    newBlocks.add((BasicBlock)newBlock);
                });
                continue;
            }
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                BasicBlock pred = predecessors.get(predIndex);
                if (pred.hasOneNormalExit()) continue;
                int blockNumber = this.blocks.size() + newBlocks.size();
                BasicBlock newBlock2 = BasicBlock.createGotoBlock(block, blockNumber);
                newBlocks.add(newBlock2);
                pred.replaceSuccessor(block, newBlock2);
                newBlock2.getPredecessors().add(pred);
                predecessors.set(predIndex, newBlock2);
            }
        }
        this.blocks.addAll(newBlocks);
    }

    boolean isIntegerType(NumericType type) {
        return type != NumericType.FLOAT && type != NumericType.DOUBLE;
    }

    boolean isNonLongIntegerType(NumericType type) {
        return type != NumericType.FLOAT && type != NumericType.DOUBLE && type != NumericType.LONG;
    }

    private static void invertConditionalsForTesting(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.exit().isIf()) continue;
            block.exit().asIf().invert();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static class BlockInfo {
        BasicBlock block = new BasicBlock();
        IntSet normalPredecessors = new IntArraySet();
        IntSet normalSuccessors = new IntArraySet();
        IntSet exceptionalPredecessors = new IntArraySet();
        IntSet exceptionalSuccessors = new IntArraySet();

        void addNormalPredecessor(int offset) {
            this.normalPredecessors.add(offset);
        }

        void addNormalSuccessor(int offset) {
            this.normalSuccessors.add(offset);
        }

        void replaceNormalPredecessor(int existing, int replacement) {
            this.normalPredecessors.remove(existing);
            this.normalPredecessors.add(replacement);
        }

        void addExceptionalPredecessor(int offset) {
            this.exceptionalPredecessors.add(offset);
        }

        void addExceptionalSuccessor(int offset) {
            this.exceptionalSuccessors.add(offset);
        }

        int predecessorCount() {
            return this.normalPredecessors.size() + this.exceptionalPredecessors.size();
        }

        BlockInfo split(int blockStartOffset, int fallthroughOffset, Int2ReferenceMap<BlockInfo> targets) {
            BlockInfo fallthroughInfo = new BlockInfo();
            fallthroughInfo.normalPredecessors = new IntArraySet(Collections.singleton(blockStartOffset));
            fallthroughInfo.block.incrementUnfilledPredecessorCount();
            IntIterator normalSuccessorIterator = this.normalSuccessors.iterator();
            while (normalSuccessorIterator.hasNext()) {
                BlockInfo normalSuccessor = (BlockInfo)targets.get(normalSuccessorIterator.nextInt());
                normalSuccessor.replaceNormalPredecessor(blockStartOffset, fallthroughOffset);
            }
            fallthroughInfo.normalSuccessors = this.normalSuccessors;
            this.normalSuccessors = new IntArraySet(Collections.singleton(fallthroughOffset));
            IntIterator exceptionalSuccessorIterator = fallthroughInfo.exceptionalSuccessors.iterator();
            while (exceptionalSuccessorIterator.hasNext()) {
                BlockInfo exceptionalSuccessor = (BlockInfo)targets.get(exceptionalSuccessorIterator.nextInt());
                exceptionalSuccessor.addExceptionalPredecessor(fallthroughOffset);
            }
            fallthroughInfo.exceptionalSuccessors = new IntArraySet(this.exceptionalSuccessors);
            return fallthroughInfo;
        }
    }

    private static class ValueList {
        private List<Value> values = new ArrayList<Value>();

        private ValueList() {
        }

        public static ValueList fromPhis(List<Phi> phis, int index) {
            ValueList result = new ValueList();
            for (Phi phi : phis) {
                result.values.add(phi.getOperand(index));
            }
            return result;
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ValueList)) {
                return false;
            }
            ValueList o = (ValueList)other;
            if (o.values.size() != this.values.size()) {
                return false;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) == o.values.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static class MoveExceptionWorklistItem
    extends WorklistItem {
        private final int targetOffset;

        private MoveExceptionWorklistItem(BasicBlock block, int targetOffset) {
            super(block, -1);
            this.targetOffset = targetOffset;
        }
    }

    private static class WorklistItem {
        private final BasicBlock block;
        private final int firstInstructionIndex;

        private WorklistItem(BasicBlock block, int firstInstructionIndex) {
            assert (block != null);
            this.block = block;
            this.firstInstructionIndex = firstInstructionIndex;
        }
    }
}

