/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Arrays;

public class SourceFileRewriter {
    private final AppInfo appInfo;
    private final InternalOptions options;

    public SourceFileRewriter(AppInfo appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.options = options;
    }

    public void run() {
        String renameSourceFile = this.options.proguardConfiguration.getRenameSourceFileAttribute();
        if (renameSourceFile == null && this.options.keepAttributes.sourceFile) {
            return;
        }
        DexString dexRenameSourceFile = renameSourceFile == null ? this.appInfo.dexItemFactory.createString("") : this.appInfo.dexItemFactory.createString(renameSourceFile);
        for (DexClass dexClass : this.appInfo.classes()) {
            dexClass.sourceFile = dexRenameSourceFile;
            dexClass.forEachMethod(encodedMethod -> {
                if (encodedMethod.accessFlags.isAbstract()) {
                    return;
                }
                Code code = encodedMethod.getCode();
                if (code == null || !code.isDexCode()) {
                    return;
                }
                if (code.asDexCode().getDebugInfo() == null) {
                    return;
                }
                DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
                dexDebugInfo.events = (DexDebugEvent[])Arrays.stream(dexDebugInfo.events).filter(dexDebugEvent -> !(dexDebugEvent instanceof DexDebugEvent.SetFile)).toArray(DexDebugEvent[]::new);
            });
        }
    }
}

