/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.org.apache.commons.compress.parallel;

import com.android.tools.r8.org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileBasedScatterGatherBackingStore
implements ScatterGatherBackingStore {
    private final File target;
    private final FileOutputStream os;
    private boolean closed;

    public FileBasedScatterGatherBackingStore(File target) throws FileNotFoundException {
        this.target = target;
        this.os = new FileOutputStream(target);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.target);
    }

    @Override
    public void closeForWriting() throws IOException {
        if (!this.closed) {
            this.os.close();
            this.closed = true;
        }
    }

    @Override
    public void writeOut(byte[] data, int offset, int length) throws IOException {
        this.os.write(data, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.closeForWriting();
        this.target.delete();
    }
}

