/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardNameMatcher;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.StringUtils;
import java.util.List;

public class ProguardMemberRule {
    private final ProguardTypeMatcher annotation;
    private final DexAccessFlags accessFlags;
    private final DexAccessFlags negatedAccessFlags;
    private final ProguardMemberType ruleType;
    private final ProguardNameMatcher name;
    private final ProguardTypeMatcher type;
    private final List<ProguardTypeMatcher> arguments;
    private final ProguardMemberRuleReturnValue returnValue;

    private ProguardMemberRule(ProguardTypeMatcher annotation, DexAccessFlags accessFlags, DexAccessFlags negatedAccessFlags, ProguardMemberType ruleType, ProguardNameMatcher name, ProguardTypeMatcher type, List<ProguardTypeMatcher> arguments, ProguardMemberRuleReturnValue returnValue) {
        this.annotation = annotation;
        this.accessFlags = accessFlags;
        this.negatedAccessFlags = negatedAccessFlags;
        this.ruleType = ruleType;
        this.name = name;
        this.type = type;
        this.arguments = arguments != null ? ImmutableList.copyOf(arguments) : null;
        this.returnValue = returnValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ProguardTypeMatcher getAnnotation() {
        return this.annotation;
    }

    public DexAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public DexAccessFlags getNegatedAccessFlags() {
        return this.negatedAccessFlags;
    }

    public ProguardMemberType getRuleType() {
        return this.ruleType;
    }

    public ProguardNameMatcher getName() {
        return this.name;
    }

    public ProguardTypeMatcher getType() {
        return this.type;
    }

    public List<ProguardTypeMatcher> getArguments() {
        return this.arguments;
    }

    public boolean hasReturnValue() {
        return this.returnValue != null;
    }

    public ProguardMemberRuleReturnValue getReturnValue() {
        return this.returnValue;
    }

    public ProguardTypeMatcher getTypeMatcher() {
        return this.type;
    }

    public boolean matches(DexEncodedField field, RootSetBuilder builder) {
        switch (this.getRuleType()) {
            case ALL: 
            case ALL_FIELDS: {
                if (!field.accessFlags.containsAllOf(this.getAccessFlags()) || !field.accessFlags.containsNoneOf(this.getNegatedAccessFlags())) break;
                return RootSetBuilder.containsAnnotation(this.annotation, field.annotations);
            }
            case FIELD: {
                String name = builder.lookupString(field.field.name);
                if (!this.getName().matches(name) || !field.accessFlags.containsAllOf(this.getAccessFlags()) || !field.accessFlags.containsNoneOf(this.getNegatedAccessFlags()) || !this.type.matches(field.field.type) || !RootSetBuilder.containsAnnotation(this.annotation, field.annotations)) break;
                return true;
            }
        }
        return false;
    }

    public boolean matches(DexEncodedMethod method, RootSetBuilder builder) {
        switch (this.getRuleType()) {
            case ALL_METHODS: {
                if (method.isClassInitializer()) break;
            }
            case ALL: {
                if (!method.accessFlags.containsAllOf(this.getAccessFlags()) || !method.accessFlags.containsNoneOf(this.getNegatedAccessFlags())) break;
                return RootSetBuilder.containsAnnotation(this.annotation, method.annotations);
            }
            case METHOD: {
                if (!this.type.matches(method.method.proto.returnType)) break;
            }
            case INIT: 
            case CONSTRUCTOR: {
                int i;
                String name = builder.lookupString(method.method.name);
                if (!this.getName().matches(name) || !method.accessFlags.containsAllOf(this.getAccessFlags()) || !method.accessFlags.containsNoneOf(this.getNegatedAccessFlags()) || !RootSetBuilder.containsAnnotation(this.annotation, method.annotations)) break;
                List<ProguardTypeMatcher> arguments = this.getArguments();
                if (arguments.size() == 1 && arguments.get(0).isTripleDotPattern()) {
                    return true;
                }
                DexType[] parameters = method.method.proto.parameters.values;
                if (parameters.length != arguments.size()) break;
                for (i = 0; i < parameters.length && arguments.get(i).matches(parameters[i]); ++i) {
                }
                if (i != parameters.length) break;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProguardMemberRule)) {
            return false;
        }
        ProguardMemberRule that = (ProguardMemberRule)o;
        if (this.annotation != null ? !this.annotation.equals(that.annotation) : that.annotation != null) {
            return false;
        }
        if (!this.accessFlags.equals(that.accessFlags)) {
            return false;
        }
        if (!this.negatedAccessFlags.equals(that.negatedAccessFlags)) {
            return false;
        }
        if (this.ruleType != that.ruleType) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
    }

    public int hashCode() {
        int result = this.annotation != null ? this.annotation.hashCode() : 0;
        result = 31 * result + this.accessFlags.hashCode();
        result = 31 * result + this.negatedAccessFlags.hashCode();
        result = 31 * result + (this.ruleType != null ? this.ruleType.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ProguardKeepRule.appendNonEmpty(result, "@", this.annotation, " ");
        ProguardKeepRule.appendNonEmpty(result, null, this.accessFlags, " ");
        ProguardKeepRule.appendNonEmpty(result, null, this.negatedAccessFlags.toString().replace(" ", " !"), " ");
        switch (this.getRuleType()) {
            case ALL_FIELDS: {
                result.append("<fields>");
                break;
            }
            case ALL_METHODS: {
                result.append("<methods>");
                break;
            }
            case METHOD: {
                result.append(this.getType());
                result.append(' ');
            }
            case INIT: 
            case CONSTRUCTOR: {
                result.append(this.getName());
                result.append('(');
                result.append(StringUtils.join(this.getArguments(), ","));
                result.append(')');
                break;
            }
            case FIELD: {
                result.append(this.getType());
                result.append(' ');
                result.append(this.getName());
                break;
            }
            case ALL: {
                result.append("<all>");
                break;
            }
            default: {
                throw new Unreachable("Unknown kind of member rule");
            }
        }
        if (this.hasReturnValue()) {
            result.append(this.returnValue.toString());
        }
        return result.toString();
    }

    public static ProguardMemberRule defaultKeepAllRule() {
        Builder ruleBuilder = new Builder();
        ruleBuilder.setRuleType(ProguardMemberType.ALL);
        return ruleBuilder.build();
    }

    public static class Builder {
        private ProguardTypeMatcher annotation;
        private DexAccessFlags accessFlags = new DexAccessFlags(0);
        private DexAccessFlags negatedAccessFlags = new DexAccessFlags(0);
        private ProguardMemberType ruleType;
        private ProguardNameMatcher name;
        private ProguardTypeMatcher type;
        private List<ProguardTypeMatcher> arguments;
        private ProguardMemberRuleReturnValue returnValue;

        private Builder() {
        }

        public void setAnnotation(ProguardTypeMatcher annotation) {
            this.annotation = annotation;
        }

        public DexAccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public void setAccessFlags(DexAccessFlags flags) {
            this.accessFlags = flags;
        }

        public DexAccessFlags getNegatedAccessFlags() {
            return this.negatedAccessFlags;
        }

        public void setNegatedAccessFlags(DexAccessFlags flags) {
            this.negatedAccessFlags = flags;
        }

        public void setRuleType(ProguardMemberType ruleType) {
            this.ruleType = ruleType;
        }

        public void setName(String name) {
            this.name = ProguardNameMatcher.create(name);
        }

        public ProguardTypeMatcher getTypeMatcher() {
            return this.type;
        }

        public void setTypeMatcher(ProguardTypeMatcher type) {
            this.type = type;
        }

        public void setArguments(List<ProguardTypeMatcher> arguments) {
            this.arguments = arguments;
        }

        public void setReturnValue(ProguardMemberRuleReturnValue value) {
            this.returnValue = value;
        }

        public boolean isValid() {
            return this.ruleType != null;
        }

        public ProguardMemberRule build() {
            assert (this.isValid());
            return new ProguardMemberRule(this.annotation, this.accessFlags, this.negatedAccessFlags, this.ruleType, this.name, this.type, this.arguments, this.returnValue);
        }
    }
}

