/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.ClassProvider;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class ClassMap<T extends DexClass> {
    private final Map<DexType, Supplier<T>> classes;
    private ClassProvider<T> classProvider;

    ClassMap(Map<DexType, Supplier<T>> classes, ClassProvider<T> classProvider) {
        this.classes = classes == null ? new IdentityHashMap() : classes;
        this.classProvider = classProvider;
        assert (this.classProvider == null || this.classProvider.getClassKind() == this.getClassKind());
    }

    abstract T resolveClassConflict(T var1, T var2);

    abstract Supplier<T> getTransparentSupplier(T var1);

    abstract ClassKind getClassKind();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<DexType, Supplier<T>> map = this.classes;
        synchronized (map) {
            return this.classes.size() + " loaded, provider: " + (this.classProvider == null ? "none" : this.classProvider.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DexType type) {
        Supplier<T> supplier;
        Map<DexType, Supplier<T>> map = this.classes;
        synchronized (map) {
            supplier = this.classes.get(type);
            if (supplier == null) {
                if (this.classProvider == null) {
                    return null;
                }
                supplier = new ConcurrentClassLoader<T>(this, this.classProvider, type);
                this.classes.put(type, supplier);
            }
        }
        return (T)((DexClass)supplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAllClasses() {
        ArrayList<DexClass> loadedClasses = new ArrayList<DexClass>();
        Map<DexType, Supplier<T>> map = this.classes;
        synchronized (map) {
            if (this.classProvider != null) {
                throw new Unreachable("Getting all classes from not fully loaded collection.");
            }
            for (Supplier<T> supplier : this.classes.values()) {
                DexClass clazz = (DexClass)supplier.get();
                assert (clazz != null);
                loadedClasses.add(clazz);
            }
        }
        return loadedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoad(Predicate<DexType> load) {
        Set<DexType> knownClasses;
        ClassProvider<T> classProvider;
        Map<DexType, Supplier<T>> map = this.classes;
        synchronized (map) {
            classProvider = this.classProvider;
            if (classProvider == null) {
                return;
            }
            knownClasses = Sets.newIdentityHashSet();
            knownClasses.addAll(this.classes.keySet());
        }
        knownClasses.addAll(classProvider.collectTypes());
        for (DexType type : knownClasses) {
            if (!load.test(type)) continue;
            this.get(type);
        }
        map = this.classes;
        synchronized (map) {
            if (this.classProvider == null) {
                return;
            }
            Iterator<Map.Entry<DexType, Supplier<T>>> iterator = this.classes.entrySet().iterator();
            while (iterator.hasNext()) {
                DexClass clazz;
                Map.Entry<DexType, Supplier<T>> e = iterator.next();
                if (knownClasses.contains(e.getKey()) && (clazz = (DexClass)e.getValue().get()) != null) {
                    assert (clazz.type == e.getKey());
                    e.setValue(this.getTransparentSupplier(clazz));
                    continue;
                }
                iterator.remove();
            }
            this.classProvider = null;
        }
    }

    private static class ConcurrentClassLoader<T extends DexClass>
    implements Supplier<T> {
        private ClassMap<T> classMap;
        private ClassProvider<T> provider;
        private DexType type;
        private T clazz = null;
        private volatile boolean ready = false;

        ConcurrentClassLoader(ClassMap<T> classMap, ClassProvider<T> provider, DexType type) {
            this.classMap = classMap;
            this.provider = provider;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.ready) {
                return this.clazz;
            }
            ConcurrentClassLoader concurrentClassLoader = this;
            synchronized (concurrentClassLoader) {
                if (!this.ready) {
                    assert (this.classMap != null && this.provider != null && this.type != null);
                    this.provider.collectClass(this.type, createdClass -> {
                        assert (createdClass != null);
                        assert (this.classMap.getClassKind().isOfKind((DexClass)createdClass));
                        assert (!this.ready);
                        if (createdClass.type != this.type) {
                            throw new CompilationError("Class content provided for type descriptor " + this.type.toSourceString() + " actually defines class " + createdClass.type.toSourceString());
                        }
                        if (this.clazz == null) {
                            this.clazz = createdClass;
                        } else {
                            T oldClass = this.clazz;
                            this.clazz = null;
                            this.clazz = this.classMap.resolveClassConflict((DexClass)oldClass, (DexClass)createdClass);
                        }
                    });
                    this.classMap = null;
                    this.provider = null;
                    this.type = null;
                    this.ready = true;
                }
            }
            assert (this.ready);
            assert (this.classMap == null && this.provider == null && this.type == null);
            return this.clazz;
        }
    }
}

