/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DesugarProcessBuilder
extends ProcessEnvBuilder<DesugarProcessBuilder> {
    public static final int MIN_SUPPORTED_API_TRY_WITH_RESOURCES = 19;
    private static final String DESUGAR_MAIN = "com.google.devtools.build.android.desugar.Desugar";
    static final int MAX_PATH_ARGS_FOR_WINDOWS = 100;
    private final Path java8LangSupportJar;
    private final boolean verbose;
    private final Map<Path, Path> inputsToOutputs;
    private final List<Path> classpath;
    private final List<Path> bootClasspath;
    private final int minSdkVersion;
    private final Path tmpDir;

    public DesugarProcessBuilder(Path java8LangSupportJar, boolean verbose, Map<Path, Path> inputsToOutputs, List<Path> classpath, List<Path> bootClasspath, int minSdkVersion, Path tmpDir) {
        this.java8LangSupportJar = java8LangSupportJar;
        this.verbose = verbose;
        this.inputsToOutputs = ImmutableMap.copyOf(inputsToOutputs);
        this.classpath = classpath;
        this.bootClasspath = bootClasspath;
        this.minSdkVersion = minSdkVersion;
        this.tmpDir = tmpDir;
    }

    public JavaProcessInfo build(boolean isWindows) throws ProcessException, IOException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        builder.setClasspath(this.java8LangSupportJar.toString());
        builder.setMain(DESUGAR_MAIN);
        builder.addJvmArg("-Xmx64M");
        int pathArgs = 2 * this.inputsToOutputs.size() + this.classpath.size() + this.bootClasspath.size();
        ArrayList<String> args = new ArrayList<String>(8 * pathArgs + 5);
        if (this.verbose) {
            args.add("--verbose");
        }
        this.inputsToOutputs.forEach((in, out) -> {
            args.add("--input");
            args.add(in.toString());
            args.add("--output");
            args.add(out.toString());
        });
        this.classpath.forEach(c -> {
            args.add("--classpath_entry");
            args.add(c.toString());
        });
        this.bootClasspath.forEach(b -> {
            args.add("--bootclasspath_entry");
            args.add(b.toString());
        });
        args.add("--min_sdk_version");
        args.add(Integer.toString(this.minSdkVersion));
        if (this.minSdkVersion < 19) {
            args.add("--desugar_try_with_resources_if_needed");
        } else {
            args.add("--nodesugar_try_with_resources_if_needed");
        }
        args.add("--desugar_try_with_resources_omit_runtime_classes");
        if (isWindows && pathArgs > 100) {
            if (!Files.exists(this.tmpDir, new LinkOption[0])) {
                Files.createDirectories(this.tmpDir, new FileAttribute[0]);
            }
            Path argsFile = Files.createTempFile(this.tmpDir, "desugar_args", "", new FileAttribute[0]);
            Files.write(argsFile, args, Charsets.UTF_8, new OpenOption[0]);
            builder.addArgs("@" + argsFile.toString());
        } else {
            builder.addArgs(args);
        }
        return builder.createJavaProcess();
    }
}

