/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DominatorTree {
    private BasicBlock[] sorted;
    private BasicBlock[] doms;
    private BasicBlock normalExitBlock = new BasicBlock();

    public DominatorTree(IRCode code) {
        this(code, Collections.emptyList());
    }

    DominatorTree(IRCode code, List<BasicBlock> blocksToIgnore) {
        BasicBlock[] blocks;
        for (BasicBlock block : blocks = code.topologicallySortedBlocks(blocksToIgnore)) {
            if (!block.exit().isReturn()) continue;
            this.normalExitBlock.getPredecessors().add(block);
        }
        this.sorted = new BasicBlock[blocks.length + 1];
        System.arraycopy(blocks, 0, this.sorted, 0, blocks.length);
        this.sorted[blocks.length] = this.normalExitBlock;
        this.numberBlocks();
        this.build();
    }

    public BasicBlock immediateDominator(BasicBlock block) {
        return this.doms[block.getNumber()];
    }

    public boolean dominatedBy(BasicBlock subject, BasicBlock dominator) {
        if (subject == dominator) {
            return true;
        }
        return this.strictlyDominatedBy(subject, dominator);
    }

    public boolean strictlyDominatedBy(BasicBlock subject, BasicBlock dominator) {
        if (subject.getNumber() == 0 || subject == this.normalExitBlock) {
            return false;
        }
        BasicBlock idom;
        while ((idom = this.immediateDominator(subject)).getNumber() >= dominator.getNumber()) {
            if (idom == dominator) {
                return true;
            }
            subject = idom;
        }
        return false;
    }

    public BasicBlock closestDominator(Collection<BasicBlock> blocks) {
        if (blocks.size() == 0) {
            return null;
        }
        Iterator<BasicBlock> it = blocks.iterator();
        BasicBlock dominator = it.next();
        while (it.hasNext()) {
            dominator = this.intersect(dominator, it.next());
        }
        return dominator;
    }

    public Iterable<BasicBlock> dominatedBlocks(final BasicBlock dominator) {
        return () -> new Iterator<BasicBlock>(){
            private int current;
            {
                this.current = dominator.getNumber();
            }

            @Override
            public boolean hasNext() {
                return DominatorTree.this.dominatedBy(DominatorTree.this.sorted[this.current], dominator);
            }

            @Override
            public BasicBlock next() {
                if (!this.hasNext()) {
                    return null;
                }
                return DominatorTree.this.sorted[this.current++];
            }
        };
    }

    public Iterable<BasicBlock> dominatorBlocks(final BasicBlock dominated) {
        return () -> new Iterator<BasicBlock>(){
            private BasicBlock current;
            {
                this.current = dominated;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public BasicBlock next() {
                if (!this.hasNext()) {
                    return null;
                }
                BasicBlock result = this.current;
                if (this.current.getNumber() == 0) {
                    this.current = null;
                } else {
                    this.current = DominatorTree.this.immediateDominator(this.current);
                    assert (this.current != result);
                }
                return result;
            }
        };
    }

    public Iterable<BasicBlock> normalExitDominatorBlocks() {
        return this.dominatorBlocks(this.normalExitBlock);
    }

    public BasicBlock[] getSortedBlocks() {
        return this.sorted;
    }

    private void numberBlocks() {
        for (int i = 0; i < this.sorted.length; ++i) {
            this.sorted[i].setNumber(i);
        }
    }

    private boolean postorderCompareLess(BasicBlock b1, BasicBlock b2) {
        return b1.getNumber() > b2.getNumber();
    }

    private void build() {
        this.doms = new BasicBlock[this.sorted.length];
        this.doms[0] = this.sorted[0];
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 1; i < this.sorted.length; ++i) {
                BasicBlock p;
                int j;
                BasicBlock b = this.sorted[i];
                BasicBlock newIDom = null;
                int picked = -1;
                for (j = 0; newIDom == null && j < b.getPredecessors().size(); ++j) {
                    p = b.getPredecessors().get(j);
                    if (this.doms[p.getNumber()] == null) continue;
                    picked = j;
                    newIDom = p;
                }
                for (j = 0; j < b.getPredecessors().size(); ++j) {
                    p = b.getPredecessors().get(j);
                    if (j == picked || this.doms[p.getNumber()] == null) continue;
                    newIDom = this.intersect(p, newIDom);
                }
                if (this.doms[b.getNumber()] == newIDom) continue;
                this.doms[b.getNumber()] = newIDom;
                changed = true;
            }
        }
    }

    private BasicBlock intersect(BasicBlock b1, BasicBlock b2) {
        BasicBlock finger1 = b1;
        BasicBlock finger2 = b2;
        while (finger1 != finger2) {
            while (this.postorderCompareLess(finger1, finger2)) {
                finger1 = this.doms[finger1.getNumber()];
            }
            while (this.postorderCompareLess(finger2, finger1)) {
                finger2 = this.doms[finger2.getNumber()];
            }
        }
        return finger1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dominators\n");
        for (BasicBlock block : this.sorted) {
            builder.append(block.getNumber());
            builder.append(": ");
            builder.append(this.doms[block.getNumber()].getNumber());
            builder.append("\n");
        }
        return builder.toString();
    }
}

