/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;

public enum NumericType {
    BYTE,
    CHAR,
    SHORT,
    INT,
    LONG,
    FLOAT,
    DOUBLE;


    public DexType dexTypeFor(DexItemFactory factory) {
        switch (this) {
            case BYTE: {
                return factory.byteType;
            }
            case CHAR: {
                return factory.charType;
            }
            case SHORT: {
                return factory.shortType;
            }
            case INT: {
                return factory.intType;
            }
            case LONG: {
                return factory.longType;
            }
            case FLOAT: {
                return factory.floatType;
            }
            case DOUBLE: {
                return factory.doubleType;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)this) + "'");
    }

    public static NumericType fromDexType(DexType type) {
        switch (type.descriptor.content[0]) {
            case 66: {
                return BYTE;
            }
            case 83: {
                return SHORT;
            }
            case 67: {
                return CHAR;
            }
            case 73: {
                return INT;
            }
            case 70: {
                return FLOAT;
            }
            case 74: {
                return LONG;
            }
            case 68: {
                return DOUBLE;
            }
        }
        return null;
    }
}

