/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AbstractMethodRemover {
    private final AppInfoWithSubtyping appInfo;
    private ScopedDexItemSet scope;

    public AbstractMethodRemover(AppInfoWithSubtyping appInfo) {
        this.appInfo = appInfo;
    }

    public void run() {
        assert (this.scope == null);
        this.processClass(this.appInfo.dexItemFactory.objectType);
    }

    private void processClass(DexType type) {
        DexClass holder = this.appInfo.definitionFor(type);
        this.scope = new ScopedDexItemSet(this.scope);
        if (holder != null && !holder.isLibraryClass()) {
            holder.setVirtualMethods(this.processMethods(holder.virtualMethods()));
        }
        type.forAllExtendsSubtypes(this::processClass);
        this.scope = this.scope.getParent();
    }

    private DexEncodedMethod[] processMethods(DexEncodedMethod[] virtualMethods) {
        if (virtualMethods == null) {
            return null;
        }
        ArrayList<DexEncodedMethod> methods = null;
        for (int i = 0; i < virtualMethods.length; ++i) {
            DexEncodedMethod method = virtualMethods[i];
            if (this.scope.addMethod(method.method) || !method.accessFlags.isAbstract()) {
                if (methods == null) continue;
                methods.add(method);
                continue;
            }
            if (methods != null) continue;
            methods = new ArrayList<DexEncodedMethod>(virtualMethods.length - 1);
            for (int j = 0; j < i; ++j) {
                methods.add(virtualMethods[j]);
            }
        }
        return methods == null ? virtualMethods : methods.toArray(new DexEncodedMethod[methods.size()]);
    }

    private static class ScopedDexItemSet {
        private static Equivalence<DexMethod> METHOD_EQUIVALENCE = MethodSignatureEquivalence.get();
        private final ScopedDexItemSet parent;
        private final Set<Equivalence.Wrapper<DexMethod>> items = new HashSet<Equivalence.Wrapper<DexMethod>>();

        private ScopedDexItemSet(ScopedDexItemSet parent) {
            this.parent = parent;
        }

        private boolean contains(Equivalence.Wrapper<DexMethod> item) {
            return this.items.contains(item) || this.parent != null && this.parent.contains(item);
        }

        boolean addMethod(DexMethod method) {
            Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap(method);
            return !this.contains(wrapped) && this.items.add(wrapped);
        }

        ScopedDexItemSet getParent() {
            return this.parent;
        }
    }
}

