/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexArchiveMergerException;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexingType;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.DexOverflowException;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class D8DexArchiveMerger
implements DexArchiveMerger {
    private static final Logger LOGGER = Logger.getLogger(D8DexArchiveMerger.class.getName());
    private static final String ERROR_MULTIDEX = "Cannot fit requested classes in a single dex file";
    private final OutputStream errorStream;
    private final int minSdkVersion;
    private final CompilationMode compilationMode;

    public D8DexArchiveMerger(OutputStream errorStream, int minSdkVersion, CompilationMode compilationMode) {
        this.errorStream = errorStream;
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = compilationMode;
    }

    @Override
    public void mergeDexArchives(Iterable<Path> inputs, Path outputDir, Path mainDexClasses, DexingType dexingType) throws DexArchiveMergerException {
        LOGGER.log(Level.INFO, "Merging to '" + outputDir.toAbsolutePath().toString() + "' with D8 from " + Streams.stream(inputs).map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining(", ")));
        if (Iterables.isEmpty(inputs)) {
            return;
        }
        D8Command.Builder builder = D8Command.builder();
        builder.setEnableDesugaring(false);
        for (Path input : inputs) {
            try {
                DexArchive archive = DexArchives.fromInput(input);
                Throwable throwable = null;
                try {
                    for (DexArchiveEntry dexArchiveEntry : archive.getFiles()) {
                        builder.addDexProgramData(new byte[][]{dexArchiveEntry.getDexFileContent()});
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (archive == null) continue;
                    if (throwable != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    archive.close();
                }
            }
            catch (IOException e) {
                throw this.getExceptionToRethrow(e, input);
            }
        }
        try {
            if (mainDexClasses != null) {
                builder.addMainDexListFiles(mainDexClasses);
            }
            ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.setMinApiLevel(this.minSdkVersion)).setMode(this.compilationMode)).setOutputPath(outputDir)).setEnableDesugaring(false)).setIntermediate(false);
            D8.run(builder.build());
        }
        catch (CompilationException | CompilationError | IOException e) {
            throw this.getExceptionToRethrow(e, inputs);
        }
    }

    private DexArchiveMergerException getExceptionToRethrow(Throwable t, Iterable<Path> inputs) {
        StringBuilder msg = new StringBuilder("Error while merging dex archives: ");
        msg.append(Joiner.on((String)", ").join(inputs));
        msg.append(System.lineSeparator());
        if (t instanceof DexOverflowException && t.getMessage().startsWith(ERROR_MULTIDEX)) {
            msg.append("The number of method references in a .dex file cannot exceed 64K.\nLearn how to resolve this issue at https://developer.android.com/tools/building/multidex.html");
        }
        return new DexArchiveMergerException(msg.toString(), t);
    }
}

