/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.google.common.base.Preconditions;

public final class DexArchiveEntry {
    private final byte[] dexFileContent;
    private final String relativePathInArchive;

    public DexArchiveEntry(byte[] dexFileContent, String relativePathInArchive) {
        this.relativePathInArchive = relativePathInArchive;
        this.dexFileContent = dexFileContent;
    }

    public static String withClassExtension(String dexEntryPath) {
        Preconditions.checkState((boolean)dexEntryPath.endsWith(".dex"), (Object)"Dex archives: setting .CLASS extension only for .DEX files");
        return dexEntryPath.substring(0, dexEntryPath.length() - ".dex".length()) + ".class";
    }

    public byte[] getDexFileContent() {
        return this.dexFileContent;
    }

    public String getRelativePathInArchive() {
        return this.relativePathInArchive;
    }
}

