/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstProtoRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;

public class InvokePolymorphicInsn
extends Insn {
    private static final CstString INVOKE_DESCRIPTOR = new CstString("([Ljava/lang/Object;)Ljava/lang/Object;");
    private final TypeList catches;
    private final CstMethodRef callSiteMethod;
    private final CstMethodRef invokeMethod;
    private final CstProtoRef callSiteProto;

    public InvokePolymorphicInsn(Rop opcode, SourcePosition position, RegisterSpecList sources, TypeList catches, CstMethodRef callSiteMethod) {
        super(opcode, position, null, sources);
        if (opcode.getBranchingness() != 6) {
            throw new IllegalArgumentException("opcode with invalid branchingness: " + opcode.getBranchingness());
        }
        if (catches == null) {
            throw new NullPointerException("catches == null");
        }
        this.catches = catches;
        if (callSiteMethod == null) {
            throw new NullPointerException("callSiteMethod == null");
        }
        if (!callSiteMethod.isSignaturePolymorphic()) {
            throw new IllegalArgumentException("callSiteMethod is not signature polymorphic");
        }
        this.callSiteMethod = callSiteMethod;
        this.invokeMethod = InvokePolymorphicInsn.makeInvokeMethod(callSiteMethod);
        this.callSiteProto = InvokePolymorphicInsn.makeCallSiteProto(callSiteMethod);
    }

    @Override
    public TypeList getCatches() {
        return this.catches;
    }

    @Override
    public void accept(Insn.Visitor visitor) {
        visitor.visitInvokePolymorphicInsn(this);
    }

    @Override
    public Insn withAddedCatch(Type type) {
        return new InvokePolymorphicInsn(this.getOpcode(), this.getPosition(), this.getSources(), this.catches.withAddedType(type), this.getCallSiteMethod());
    }

    @Override
    public Insn withRegisterOffset(int delta) {
        return new InvokePolymorphicInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(delta), this.catches, this.getCallSiteMethod());
    }

    @Override
    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new InvokePolymorphicInsn(this.getOpcode(), this.getPosition(), sources, this.catches, this.getCallSiteMethod());
    }

    public CstMethodRef getCallSiteMethod() {
        return this.callSiteMethod;
    }

    public CstMethodRef getInvokeMethod() {
        return this.invokeMethod;
    }

    public CstProtoRef getCallSiteProto() {
        return this.callSiteProto;
    }

    @Override
    public String getInlineString() {
        return this.getInvokeMethod().toString() + " " + this.getCallSiteProto().toString() + " " + ThrowingInsn.toCatchString(this.catches);
    }

    private static CstMethodRef makeInvokeMethod(CstMethodRef callSiteMethod) {
        CstNat cstNat = new CstNat(callSiteMethod.getNat().getName(), INVOKE_DESCRIPTOR);
        return new CstMethodRef(callSiteMethod.getDefiningClass(), cstNat);
    }

    private static CstProtoRef makeCallSiteProto(CstMethodRef callSiteMethod) {
        return new CstProtoRef(callSiteMethod.getPrototype(true));
    }
}

