/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class Resource {
    public final Origin origin;

    protected Resource(Origin origin) {
        this.origin = origin;
    }

    public static Resource fromFile(Path file) {
        return new FileResource(file);
    }

    public static Resource fromBytes(Origin origin, byte[] bytes) {
        return Resource.fromBytes(origin, bytes, null);
    }

    public static Resource fromBytes(Origin origin, byte[] bytes, Set<String> typeDescriptors) {
        return new ByteResource(origin, bytes, typeDescriptors);
    }

    public abstract Set<String> getClassDescriptors();

    public abstract InputStream getStream() throws IOException;

    private static class ByteResource
    extends Resource {
        final Set<String> classDescriptors;
        final byte[] bytes;

        ByteResource(Origin origin, byte[] bytes, Set<String> classDescriptors) {
            super(origin);
            assert (bytes != null);
            this.classDescriptors = classDescriptors;
            this.bytes = bytes;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.classDescriptors;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    private static class FileResource
    extends Resource {
        final Path file;

        FileResource(Path file) {
            super(new PathOrigin(file, Origin.root()));
            assert (file != null);
            this.file = file;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return null;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file.toFile());
        }
    }

    public static class PathOrigin
    extends Origin {
        private final Path path;

        public PathOrigin(Path path, Origin parent) {
            super(parent);
            assert (path != null);
            this.path = path;
        }

        @Override
        public String part() {
            return this.path.toString();
        }
    }

    public static abstract class Origin
    implements Comparable<Origin> {
        private static final Origin ROOT = new Origin(){

            @Override
            public String part() {
                return "";
            }

            @Override
            List<String> buildParts(int size) {
                return new ArrayList<String>(size);
            }
        };
        private static final Origin UNKNOWN = new Origin(){

            @Override
            public String part() {
                return "<unknown>";
            }

            @Override
            List<String> buildParts(int size) {
                ArrayList<String> parts = new ArrayList<String>(size + 1);
                parts.add(this.part());
                return parts;
            }
        };
        private final Origin parent;

        public static Origin root() {
            return ROOT;
        }

        public static Origin unknown() {
            return UNKNOWN;
        }

        private Origin() {
            this.parent = null;
        }

        protected Origin(Origin parent) {
            assert (parent != null);
            this.parent = parent;
        }

        public abstract String part();

        public Origin parent() {
            return this.parent;
        }

        public List<String> parts() {
            return this.buildParts(0);
        }

        List<String> buildParts(int size) {
            List<String> parts = this.parent().buildParts(size + 1);
            parts.add(this.part());
            return parts;
        }

        public boolean equals(Object obj) {
            Origin other;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Origin)) {
                return false;
            }
            Origin self = this;
            for (other = (Origin)obj; self != null && other != null && self.part().equals(other.part()); self = self.parent(), other = other.parent()) {
            }
            return self == other;
        }

        @Override
        public int compareTo(Origin other) {
            List<String> thisParts = this.parts();
            List<String> otherParts = other.parts();
            int len = Math.min(thisParts.size(), otherParts.size());
            for (int i = 0; i < len; ++i) {
                int compare = thisParts.get(i).compareTo(otherParts.get(i));
                if (compare == 0) continue;
                return compare;
            }
            return Integer.compare(thisParts.size(), otherParts.size());
        }

        public int hashCode() {
            int hash = 1;
            for (String part : this.parts()) {
                hash = 31 * hash + part.hashCode();
            }
            return hash;
        }

        public String toString() {
            return String.join((CharSequence)":", this.parts());
        }
    }
}

