/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEntryBuilder;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexString;
import java.util.Arrays;
import java.util.List;

public class DexDebugInfo
extends CachedHashValueDexItem {
    public final int startLine;
    public final DexString[] parameters;
    public DexDebugEvent[] events;

    public DexDebugInfo(int startLine, DexString[] parameters, DexDebugEvent[] events) {
        assert (startLine >= 0);
        this.startLine = startLine;
        this.parameters = parameters;
        this.events = events;
        this.hashCode();
    }

    public List<DexDebugEntry> computeEntries() {
        DexDebugEntryBuilder builder = new DexDebugEntryBuilder(this.startLine);
        for (DexDebugEvent event : this.events) {
            event.addToBuilder(builder);
        }
        return builder.build();
    }

    @Override
    public int computeHashCode() {
        return this.startLine + Arrays.hashCode(this.parameters) * 7 + Arrays.hashCode(this.events) * 13;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexDebugInfo) {
            DexDebugInfo o = (DexDebugInfo)other;
            if (this.startLine != o.startLine) {
                return false;
            }
            if (!Arrays.equals(this.parameters, o.parameters)) {
                return false;
            }
            return Arrays.equals(this.events, o.events);
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection collection) {
        DexDebugInfo.collectAll((IndexedItemCollection)collection, (DexItem[])this.parameters);
        DexDebugInfo.collectAll((IndexedItemCollection)collection, (DexItem[])this.events);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection collection) {
        collection.add(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DebugInfo (line " + this.startLine + ") events: [\n");
        for (DexDebugEvent event : this.events) {
            builder.append("  ").append(event).append("\n");
        }
        builder.append("  END_SEQUENCE\n");
        builder.append("]\n");
        return builder.toString();
    }
}

