/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.Resource;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.utils.ProgramResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class DexProgramClass
extends DexClass
implements Supplier<DexProgramClass> {
    private static DexEncodedArray SENTINEL_NOT_YET_COMPUTED = new DexEncodedArray(new DexValue[0]);
    private final ProgramResource.Kind originKind;
    private DexEncodedArray staticValues = SENTINEL_NOT_YET_COMPUTED;
    private final Collection<DexProgramClass> synthesizedFrom;
    private int classFileVersion = -1;

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Resource.Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods) {
        this(type, originKind, origin, accessFlags, superType, interfaces, sourceFile, classAnnotations, staticFields, instanceFields, directMethods, virtualMethods, Collections.emptyList());
    }

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Resource.Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, Collection<DexProgramClass> synthesizedDirectlyFrom) {
        super(sourceFile, interfaces, accessFlags, superType, type, staticFields, instanceFields, directMethods, virtualMethods, classAnnotations, origin);
        assert (classAnnotations != null);
        this.originKind = originKind;
        this.synthesizedFrom = DexProgramClass.accumulateSynthesizedFrom(new HashSet<DexProgramClass>(), synthesizedDirectlyFrom);
    }

    public boolean originatesFromDexResource() {
        return this.originKind == ProgramResource.Kind.DEX;
    }

    public boolean originatesFromClassResource() {
        return this.originKind == ProgramResource.Kind.CLASS;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addClass(this)) {
            this.type.collectIndexedItems(indexedItems);
            if (this.superType != null) {
                this.superType.collectIndexedItems(indexedItems);
            } else assert (this.type.toDescriptorString().equals("Ljava/lang/Object;"));
            if (this.sourceFile != null) {
                this.sourceFile.collectIndexedItems(indexedItems);
            }
            if (this.annotations != null) {
                this.annotations.collectIndexedItems(indexedItems);
            }
            if (this.interfaces != null) {
                this.interfaces.collectIndexedItems(indexedItems);
            }
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.staticFields);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.instanceFields);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.directMethods);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.virtualMethods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DexItem> void synchronizedCollectAll(IndexedItemCollection collection, T[] items) {
        T[] TArray = items;
        synchronized (items) {
            DexProgramClass.collectAll((IndexedItemCollection)collection, items);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Collection<DexProgramClass> getSynthesizedFrom() {
        return this.synthesizedFrom;
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (this.hasAnnotations()) {
            mixedItems.setAnnotationsDirectoryForClass(this, new DexAnnotationDirectory(this));
        }
    }

    @Override
    public void addDependencies(MixedSectionCollection collector) {
        if (this.hasMethodsOrFields()) {
            collector.add(this);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.directMethods);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.virtualMethods);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.staticFields);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.instanceFields);
        }
        if (this.annotations != null) {
            this.annotations.collectMixedSectionItems(collector);
        }
        if (this.interfaces != null) {
            this.interfaces.collectMixedSectionItems(collector);
        }
        this.annotations.collectMixedSectionItems(collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DexItem> void synchronizedCollectAll(MixedSectionCollection collection, T[] items) {
        T[] TArray = items;
        synchronized (items) {
            DexProgramClass.collectAll((MixedSectionCollection)collection, items);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString();
    }

    @Override
    public boolean isProgramClass() {
        return true;
    }

    @Override
    public DexProgramClass asProgramClass() {
        return this;
    }

    public boolean hasMethodsOrFields() {
        int numberOfMethods;
        int numberOfFields = this.staticFields().length + this.instanceFields().length;
        return numberOfFields + (numberOfMethods = this.directMethods().length + this.virtualMethods().length) > 0;
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty() || this.hasAnnotations(this.virtualMethods) || this.hasAnnotations(this.directMethods) || this.hasAnnotations(this.staticFields) || this.hasAnnotations(this.instanceFields);
    }

    boolean hasOnlyInternalizableAnnotations() {
        return !this.hasAnnotations(this.virtualMethods) && !this.hasAnnotations(this.directMethods) && !this.hasAnnotations(this.staticFields) && !this.hasAnnotations(this.instanceFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(fields).anyMatch(DexEncodedField::hasAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedMethod[] methods) {
        DexEncodedMethod[] dexEncodedMethodArray = methods;
        synchronized (methods) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(methods).anyMatch(DexEncodedMethod::hasAnnotation);
        }
    }

    private static Collection<DexProgramClass> accumulateSynthesizedFrom(Set<DexProgramClass> accumulated, Collection<DexProgramClass> toAccumulate) {
        for (DexProgramClass dexProgramClass : toAccumulate) {
            if (dexProgramClass.synthesizedFrom.isEmpty()) {
                accumulated.add(dexProgramClass);
                continue;
            }
            DexProgramClass.accumulateSynthesizedFrom(accumulated, dexProgramClass.synthesizedFrom);
        }
        return accumulated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeStaticValues(DexItemFactory factory) {
        if (this.staticValues != SENTINEL_NOT_YET_COMPUTED) return;
        DexEncodedField[] dexEncodedFieldArray = this.staticFields;
        synchronized (this.staticFields) {
            assert (PresortedComparable.isSorted(this.staticFields));
            DexEncodedField[] fields = this.staticFields;
            int length = 0;
            ArrayList<DexValue> values = new ArrayList<DexValue>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                DexEncodedField field = fields[i];
                assert (field.staticValue != null);
                values.add(field.staticValue);
                if (field.staticValue.isDefault(field.field.type, factory)) continue;
                length = i + 1;
            }
            this.staticValues = length > 0 ? new DexEncodedArray(values.subList(0, length).toArray(new DexValue[length])) : null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DexEncodedArray getStaticValues() {
        if (this.staticValues == SENTINEL_NOT_YET_COMPUTED) {
            assert (!this.hasMethodsOrFields());
            return null;
        }
        return this.staticValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        assert (!virtualMethod.accessFlags.isStatic());
        assert (!virtualMethod.accessFlags.isPrivate());
        assert (!virtualMethod.accessFlags.isConstructor());
        DexEncodedMethod[] dexEncodedMethodArray = this.virtualMethods;
        synchronized (this.virtualMethods) {
            this.virtualMethods = Arrays.copyOf(this.virtualMethods, this.virtualMethods.length + 1);
            this.virtualMethods[this.virtualMethods.length - 1] = virtualMethod;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStaticMethod(DexEncodedMethod staticMethod) {
        assert (staticMethod.accessFlags.isStatic());
        assert (!staticMethod.accessFlags.isPrivate());
        DexEncodedMethod[] dexEncodedMethodArray = this.directMethods;
        synchronized (this.directMethods) {
            this.directMethods = Arrays.copyOf(this.directMethods, this.directMethods.length + 1);
            this.directMethods[this.directMethods.length - 1] = staticMethod;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void sortMembers() {
        this.sortEncodedFields(this.staticFields);
        this.sortEncodedFields(this.instanceFields);
        this.sortEncodedMethods(this.directMethods);
        this.sortEncodedMethods(this.virtualMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEncodedFields(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            Arrays.sort(fields, Comparator.comparing(a -> a.field));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEncodedMethods(DexEncodedMethod[] methods) {
        DexEncodedMethod[] dexEncodedMethodArray = methods;
        synchronized (methods) {
            Arrays.sort(methods, Comparator.comparing(a -> a.method));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DexProgramClass get() {
        return this;
    }

    public void setClassFileVersion(int classFileVersion) {
        this.classFileVersion = classFileVersion;
    }

    public int getClassFileVersion() {
        assert (this.classFileVersion != -1);
        return this.classFileVersion;
    }
}

