/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ValueType;

public enum MemberType {
    SINGLE,
    WIDE,
    OBJECT,
    BOOLEAN,
    BYTE,
    CHAR,
    SHORT;


    public static ValueType moveTypeFor(MemberType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                return ValueType.INT;
            }
            case SINGLE: {
                return ValueType.INT_OR_FLOAT;
            }
            case WIDE: {
                return ValueType.LONG_OR_DOUBLE;
            }
            case OBJECT: {
                return ValueType.OBJECT;
            }
        }
        return null;
    }

    public static MemberType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'C': {
                return CHAR;
            }
            case 'F': 
            case 'I': {
                return SINGLE;
            }
            case 'D': 
            case 'J': {
                return WIDE;
            }
            case 'V': {
                throw new InternalCompilerError("No member type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static MemberType fromDexType(DexType type) {
        return MemberType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }
}

