/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.NewArray;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;

public class NewArrayEmpty
extends Instruction {
    public final DexType type;

    public NewArrayEmpty(Value dest, Value size, DexType type) {
        super(dest, size);
        dest.markNeverNull();
        this.type = type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value size() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int size = builder.allocatedRegister(this.size(), this.getNumber());
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, new NewArray(dest, size, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asNewArrayEmpty().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.slowCompareTo(other.asNewArrayEmpty().type);
    }

    @Override
    public boolean isNewArrayEmpty() {
        return true;
    }

    @Override
    public NewArrayEmpty asNewArrayEmpty() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.classIsVisible(holder, this.type, info);
    }
}

