/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;

public class MinifiedNameMapPrinter {
    private final DexApplication application;
    private final NamingLens namingLens;
    private final Set<DexType> seenTypes = Sets.newIdentityHashSet();

    public MinifiedNameMapPrinter(DexApplication application, NamingLens namingLens) {
        this.application = application;
        this.namingLens = namingLens;
    }

    private <T> T[] sortedCopy(T[] source, Comparator<? super T> comparator) {
        T[] copy = Arrays.copyOf(source, source.length);
        Arrays.sort(copy, comparator);
        return copy;
    }

    private void writeClass(DexProgramClass clazz, PrintStream out) {
        this.seenTypes.add(clazz.type);
        DexString descriptor = this.namingLens.lookupDescriptor(clazz.type);
        out.print(DescriptorUtils.descriptorToJavaType(clazz.type.descriptor.toSourceString()));
        out.print(" -> ");
        out.print(DescriptorUtils.descriptorToJavaType(descriptor.toSourceString()));
        out.println(":");
        this.writeFields(this.sortedCopy(clazz.instanceFields(), Comparator.comparing(DexEncodedField::toSourceString)), out);
        this.writeFields(this.sortedCopy(clazz.staticFields(), Comparator.comparing(DexEncodedField::toSourceString)), out);
        this.writeMethods(this.sortedCopy(clazz.directMethods(), Comparator.comparing(DexEncodedMethod::toSourceString)), out);
        this.writeMethods(this.sortedCopy(clazz.virtualMethods(), Comparator.comparing(DexEncodedMethod::toSourceString)), out);
    }

    private void writeType(DexType type, PrintStream out) {
        if (type.isClassType() && this.seenTypes.add(type)) {
            DexString descriptor = this.namingLens.lookupDescriptor(type);
            out.print(DescriptorUtils.descriptorToJavaType(type.descriptor.toSourceString()));
            out.print(" -> ");
            out.print(DescriptorUtils.descriptorToJavaType(descriptor.toSourceString()));
            out.println(":");
        }
    }

    private void writeFields(DexEncodedField[] fields, PrintStream out) {
        for (DexEncodedField encodedField : fields) {
            DexField field = encodedField.field;
            DexString renamed = this.namingLens.lookupName(field);
            if (renamed == field.name) continue;
            out.print("    ");
            out.print(field.type.toSourceString());
            out.print(" ");
            out.print(field.name.toSourceString());
            out.print(" -> ");
            out.println(renamed.toSourceString());
        }
    }

    private void writeMethod(MemberNaming.MethodSignature signature, String renamed, PrintStream out, DexEncodedMethod.DebugPositionRange range) {
        out.print("    ");
        if (range != null) {
            out.printf("%d:%d:", range.emittedFirst, range.getEmittedLast());
        }
        out.print(signature);
        if (range != null && range.originalFirst != range.emittedFirst) {
            out.printf(":%d:%d", range.originalFirst, range.getOriginalLast());
        }
        out.print(" -> ");
        out.println(renamed);
    }

    private void writeMethods(DexEncodedMethod[] methods, PrintStream out) {
        for (DexEncodedMethod encodedMethod : methods) {
            DexMethod method = encodedMethod.method;
            DexString renamed = this.namingLens.lookupName(method);
            if (renamed == method.name) continue;
            MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(method);
            String renamedSourceString = renamed.toSourceString();
            if (encodedMethod.debugPositionRangeList == null || encodedMethod.debugPositionRangeList.isEmpty()) {
                this.writeMethod(signature, renamedSourceString, out, null);
                continue;
            }
            for (DexEncodedMethod.DebugPositionRange range : encodedMethod.debugPositionRangeList) {
                this.writeMethod(signature, renamedSourceString, out, range);
            }
        }
    }

    public void write(PrintStream out) {
        ArrayList<DexProgramClass> classes = new ArrayList<DexProgramClass>(this.application.classes());
        classes.sort(Comparator.comparing(DexProgramClass::toSourceString));
        classes.forEach(clazz -> this.writeClass((DexProgramClass)clazz, out));
        this.namingLens.forAllRenamedTypes(type -> this.writeType((DexType)type, out));
    }

    public void write(Path destination) throws IOException {
        PrintStream out = new PrintStream(Files.newOutputStream(destination, new OpenOption[0]), true, StandardCharsets.UTF_8.name());
        this.write(out);
    }
}

