/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.FileSystemOutputSink;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DirectoryOutputSink
extends FileSystemOutputSink {
    private final Path outputDirectory;

    public DirectoryOutputSink(Path outputDirectory, InternalOptions options) throws IOException {
        super(options);
        this.outputDirectory = outputDirectory;
        this.cleanUpOutputDirectory();
    }

    private void cleanUpOutputDirectory() throws IOException {
        if (this.getOutputMode() == OutputMode.Indexed) {
            try (Stream<Path> filesInDir = Files.list(this.outputDirectory);){
                for (Path path : filesInDir.collect(Collectors.toList())) {
                    if (!FileUtils.isClassesDexFile(path)) continue;
                    Files.delete(path);
                }
            }
        }
    }

    @Override
    public void writeDexFile(byte[] contents, Set<String> classDescriptors, int fileId) throws IOException {
        Path target = this.outputDirectory.resolve(this.getOutputFileName(fileId));
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        this.writeToFile(target, null, contents);
    }

    @Override
    public void writeDexFile(byte[] contents, Set<String> classDescriptors, String primaryClassName) throws IOException {
        this.writeFileFromDescriptor(contents, primaryClassName, ".dex");
    }

    @Override
    public void writeClassFile(byte[] contents, Set<String> classDescriptors, String primaryClassName) throws IOException {
        this.writeFileFromDescriptor(contents, primaryClassName, ".class");
    }

    private void writeFileFromDescriptor(byte[] contents, String descriptor, String extension) throws IOException {
        Path target = this.outputDirectory.resolve(this.getOutputFileName(descriptor, extension));
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        this.writeToFile(target, null, contents);
    }

    @Override
    public void close() throws IOException {
    }
}

