/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.OutputSink;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DirectoryOutputSink;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.ZipFileOutputSink;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public abstract class FileSystemOutputSink
implements OutputSink {
    private final InternalOptions options;

    protected FileSystemOutputSink(InternalOptions options) {
        this.options = options;
    }

    public static FileSystemOutputSink create(Path outputPath, InternalOptions options) throws IOException {
        if (FileUtils.isArchive(outputPath)) {
            return new ZipFileOutputSink(outputPath, options);
        }
        return new DirectoryOutputSink(outputPath, options);
    }

    String getOutputFileName(int index) {
        assert (!this.options.outputClassFiles);
        return index == 0 ? "classes.dex" : "classes" + (index + 1) + ".dex";
    }

    String getOutputFileName(String classDescriptor, String extension) throws IOException {
        assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
        return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + extension;
    }

    @Override
    public void writePrintUsedInformation(byte[] contents) throws IOException {
        this.writeToFile(this.options.proguardConfiguration.getPrintUsageFile(), System.out, contents);
    }

    @Override
    public void writeProguardMapFile(byte[] contents) throws IOException {
        if (this.options.proguardConfiguration.getPrintMappingFile() != null) {
            this.writeToFile(this.options.proguardConfiguration.getPrintMappingFile(), System.out, contents);
        }
        if (this.options.proguardMapOutput != null) {
            this.writeToFile(this.options.proguardMapOutput, System.out, contents);
        }
    }

    @Override
    public void writeProguardSeedsFile(byte[] contents) throws IOException {
        this.writeToFile(this.options.proguardConfiguration.getSeedFile(), System.out, contents);
    }

    @Override
    public void writeMainDexListFile(byte[] contents) throws IOException {
        this.writeToFile(this.options.printMainDexListFile, System.out, contents);
    }

    protected void writeToFile(Path output, OutputStream defValue, byte[] contents) throws IOException {
        try (Closer closer = Closer.create();){
            OutputStream outputStream = FileUtils.openPathWithDefault(closer, output, defValue, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            outputStream.write(contents);
        }
    }

    protected OutputMode getOutputMode() {
        return this.options.outputMode;
    }
}

