/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.AutoValue_ReferenceCountMergingStrategy_FieldEvaluated;
import com.android.builder.dexing.AutoValue_ReferenceCountMergingStrategy_MethodEvaluated;
import com.android.builder.dexing.DexMergingStrategy;
import com.android.dex.Dex;
import com.android.dex.FieldId;
import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReferenceCountMergingStrategy
implements DexMergingStrategy {
    private final Set<FieldEvaluated> fieldRefs = Sets.newHashSet();
    private final Set<MethodEvaluated> methodRefs = Sets.newHashSet();
    private final List<Dex> currentDexes = Lists.newArrayList();

    @Override
    public boolean tryToAddForMerging(Dex dexFile) {
        if (this.tryAddFields(dexFile) && this.tryAddMethods(dexFile)) {
            this.currentDexes.add(dexFile);
            return true;
        }
        return false;
    }

    @Override
    public void startNewDex() {
        this.fieldRefs.clear();
        this.methodRefs.clear();
        this.currentDexes.clear();
    }

    @Override
    public ImmutableList<Dex> getAllDexToMerge() {
        return ImmutableList.copyOf(this.currentDexes);
    }

    private boolean tryAddFields(Dex dexFile) {
        List<FieldId> fieldIds = dexFile.fieldIds();
        HashSet fieldsEvaluated = new HashSet(fieldIds.size());
        fieldIds.forEach(f -> fieldsEvaluated.add(FieldEvaluated.create(f, dexFile)));
        int shared = Sets.intersection(fieldsEvaluated, this.fieldRefs).size();
        if (this.fieldRefs.size() + fieldsEvaluated.size() - shared > 65536) {
            return false;
        }
        this.fieldRefs.addAll(fieldsEvaluated);
        return true;
    }

    private boolean tryAddMethods(Dex dexFile) {
        List<MethodId> methodIds = dexFile.methodIds();
        HashSet methodsEvaluated = new HashSet(methodIds.size());
        methodIds.forEach(f -> methodsEvaluated.add(MethodEvaluated.create(f, dexFile)));
        int shared = Sets.intersection(methodsEvaluated, this.methodRefs).size();
        if (this.methodRefs.size() + methodsEvaluated.size() - shared > 65536) {
            return false;
        }
        this.methodRefs.addAll(methodsEvaluated);
        return true;
    }

    static abstract class MethodEvaluated {
        MethodEvaluated() {
        }

        public static MethodEvaluated create(MethodId methodId, Dex dex) {
            String declaringClass = dex.typeNames().get(methodId.getDeclaringClassIndex());
            String name = dex.strings().get(methodId.getNameIndex());
            ProtoId protoId = dex.protoIds().get(methodId.getProtoIndex());
            String protoShorty = dex.strings().get(protoId.getShortyIndex());
            String protoReturnType = dex.typeNames().get(protoId.getReturnTypeIndex());
            String protoParameterTypes = dex.readTypeList(protoId.getParametersOffset()).toString();
            return new AutoValue_ReferenceCountMergingStrategy_MethodEvaluated(declaringClass, name, protoShorty, protoReturnType, protoParameterTypes);
        }

        abstract String declaringClass();

        abstract String name();

        abstract String protoShorty();

        abstract String protoReturnType();

        abstract String protoParameterTypes();
    }

    static abstract class FieldEvaluated {
        FieldEvaluated() {
        }

        public static FieldEvaluated create(FieldId fieldId, Dex dex) {
            return new AutoValue_ReferenceCountMergingStrategy_FieldEvaluated(dex.typeNames().get(fieldId.getDeclaringClassIndex()), dex.typeNames().get(fieldId.getTypeIndex()), dex.strings().get(fieldId.getNameIndex()));
        }

        abstract String declaringClass();

        abstract String type();

        abstract String name();
    }
}

