/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a\u001a\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0007\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "exportToCompiledJava", "", "table", "Lcom/android/ide/common/symbols/SymbolTable;", "outJar", "Ljava/nio/file/Path;", "generateOuterRClass", "", "resourceTypes", "Ljava/util/EnumSet;", "Lcom/android/resources/ResourceType;", "packageR", "", "generateResourceTypeClass", "resType", "internalName", "type", "parseArrayLiteral", "", "size", "", "valuesString", "builder_main"})
public final class BytecodeRClassWriterKt {
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on((char)',').trimResults();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportToCompiledJava(@NotNull SymbolTable table, @NotNull Path outJar) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        Intrinsics.checkParameterIsNotNull((Object)outJar, (String)"outJar");
        Closeable closeable = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(outJar, new OpenOption[0])));
        boolean bl = false;
        try {
            JarOutputStream jarOutputStream = (JarOutputStream)closeable;
            EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
            ResourceType[] resourceTypeArray = ResourceType.values();
            for (int i = 0; i < resourceTypeArray.length; ++i) {
                byte[] bytes;
                ResourceType resType = resourceTypeArray[i];
                if (BytecodeRClassWriterKt.generateResourceTypeClass(table, resType) == null) continue;
                resourceTypes.add(resType);
                String innerR = BytecodeRClassWriterKt.internalName(table, resType);
                jarOutputStream.putNextEntry(new ZipEntry(innerR + ".class"));
                jarOutputStream.write(bytes);
            }
            String packageR = BytecodeRClassWriterKt.internalName(table, null);
            jarOutputStream.putNextEntry(new ZipEntry(packageR + ".class"));
            EnumSet<ResourceType> enumSet = resourceTypes;
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"resourceTypes");
            jarOutputStream.write(BytecodeRClassWriterKt.generateOuterRClass(enumSet, packageR));
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    closeable.close();
                }
                throw throwable;
            }
        }
        closeable.close();
    }

    private static final byte[] generateOuterRClass(EnumSet<ResourceType> resourceTypes, String packageR) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(52, 49, packageR, null, "java/lang/Object", null);
        for (ResourceType rt : resourceTypes) {
            cw.visitInnerClass(packageR + "$" + rt.getName(), packageR, rt.getName(), 25);
        }
        MethodVisitor methodVisitor = cw.visitMethod(1, "<init>", "()V", null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"cw.visitMethod(ACC_PUBLI\u2026nit>\", \"()V\", null, null)");
        MethodVisitor mv = methodVisitor;
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    private static final byte[] generateResourceTypeClass(SymbolTable table, ResourceType resType) {
        List symbols = table.getSymbolByResourceType(resType);
        if (symbols.isEmpty()) {
            return null;
        }
        ClassWriter cw = new ClassWriter(1);
        String internalName = BytecodeRClassWriterKt.internalName(table, resType);
        cw.visit(52, 49, internalName, null, "java/lang/Object", null);
        cw.visitInnerClass(internalName, BytecodeRClassWriterKt.internalName(table, null), resType.getName(), 25);
        for (Symbol s : symbols) {
            cw.visitField(9, s.getName(), Intrinsics.areEqual((Object)s.getJavaType(), (Object)SymbolJavaType.INT) ? "I" : "[I", null, Intrinsics.areEqual((Object)s.getJavaType(), (Object)SymbolJavaType.INT) ? Integer.valueOf(s.getValue(), 16) : null).visitEnd();
            if (!Intrinsics.areEqual((Object)s.getJavaType(), (Object)SymbolJavaType.INT_LIST)) continue;
            ImmutableList children = s.getChildren();
            for (Object object : CollectionsKt.withIndex((Iterable)((Iterable)children))) {
                int i = object.component1();
                String child = (String)object.component2();
                cw.visitField(9, "" + s.getName() + '_' + SymbolUtils.canonicalizeValueResourceName((String)child), "I", null, (Object)i);
            }
        }
        MethodVisitor init = cw.visitMethod(1, "<init>", "()V", null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        init.visitInsn(177);
        init.visitMaxs(0, 0);
        init.visitEnd();
        if (Intrinsics.areEqual((Object)resType, (Object)ResourceType.STYLEABLE)) {
            MethodVisitor clinit = cw.visitMethod(8, "<clinit>", "()V", null, null);
            clinit.visitCode();
            for (Symbol s : symbols) {
                int[] values = BytecodeRClassWriterKt.parseArrayLiteral(s.getChildren().size(), s.getValue());
                clinit.visitIntInsn(16, values.length);
                clinit.visitIntInsn(188, 10);
                for (IndexedValue indexedValue : ArraysKt.withIndex((int[])values)) {
                    int i = indexedValue.component1();
                    int value = ((Number)indexedValue.component2()).intValue();
                    clinit.visitInsn(89);
                    clinit.visitIntInsn(16, i);
                    clinit.visitLdcInsn((Object)value);
                    clinit.visitInsn(79);
                }
                clinit.visitFieldInsn(179, internalName, s.getName(), "[I");
            }
            clinit.visitInsn(177);
            clinit.visitMaxs(0, 0);
            clinit.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static final String internalName(SymbolTable table, ResourceType type) {
        String className = type == null ? "R" : "R$" + type.getName();
        CharSequence charSequence = table.getTablePackage();
        return charSequence.length() == 0 ? className : "" + StringsKt.replace$default((String)table.getTablePackage(), (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + className;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] parseArrayLiteral(int size, @NotNull String valuesString) {
        Intrinsics.checkParameterIsNotNull((Object)valuesString, (String)"valuesString");
        if (size == 0) {
            return new int[0];
        }
        int[] ints = new int[size];
        Iterator values = VALUE_ID_SPLITTER.split(valuesString.subSequence(1, valuesString.length() - 1)).iterator();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            if (!values.hasNext()) {
                throw (Throwable)new IllegalStateException("Values string " + valuesString + " should have " + size + " items.");
            }
            ints[i] = Integer.parseInt((String)values.next());
            ++i;
        }
        if (values.hasNext()) {
            throw (Throwable)new IllegalStateException("Values string " + valuesString + " should have " + size + " items.");
        }
        return ints;
    }
}

