/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.ManifestData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u001ad\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"processLibraryMainSymbolTable", "", "librarySymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "libraries", "", "Ljava/io/File;", "mainPackageName", "", "manifestFile", "sourceOut", "symbolFileOut", "proguardOut", "mergedResources", "platformSymbols", "disableMergeInLib", "", "builder_main"})
@JvmName(name="SymbolExportUtils")
public final class SymbolExportUtils {
    public static final void processLibraryMainSymbolTable(@NotNull SymbolTable librarySymbols, @NotNull Set<? extends File> libraries, @Nullable String mainPackageName, @NotNull File manifestFile, @NotNull File sourceOut, @NotNull File symbolFileOut, @Nullable File proguardOut, @Nullable File mergedResources, @NotNull SymbolTable platformSymbols, boolean disableMergeInLib) throws IOException {
        SymbolTable symbolTable;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)sourceOut, (String)"sourceOut");
        Intrinsics.checkParameterIsNotNull((Object)symbolFileOut, (String)"symbolFileOut");
        Intrinsics.checkParameterIsNotNull((Object)platformSymbols, (String)"platformSymbols");
        if (mainPackageName == null || proguardOut != null) {
            ManifestData manifestData = SymbolUtils.parseManifest((File)manifestFile);
            if (proguardOut != null) {
                Files.write(proguardOut.toPath(), (Iterable<? extends CharSequence>)SymbolUtils.generateMinifyKeepRules((ManifestData)manifestData, (File)mergedResources), new OpenOption[0]);
            }
            if ((string = mainPackageName) == null) {
                string = SymbolUtils.getPackageNameFromManifest((ManifestData)manifestData);
            }
        } else {
            string = mainPackageName;
        }
        String finalPackageName = string;
        Set depSymbolTables = SymbolUtils.loadDependenciesSymbolTables(libraries);
        if (disableMergeInLib) {
            symbolTable = SymbolUtils.mergeAndRenumberSymbols((String)finalPackageName, (SymbolTable)librarySymbols, (Set)depSymbolTables, (SymbolTable)platformSymbols);
        } else {
            String string2 = finalPackageName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"finalPackageName");
            symbolTable = librarySymbols.rename(string2);
        }
        SymbolTable mainSymbolTable = symbolTable;
        Files.createDirectories(symbolFileOut.toPath().getParent(), new FileAttribute[0]);
        SymbolIo.write((SymbolTable)mainSymbolTable, (File)symbolFileOut);
        SymbolIo.exportToJava((SymbolTable)mainSymbolTable, (File)sourceOut, (boolean)false);
        RGeneration.generateRForLibraries((SymbolTable)mainSymbolTable, (Collection)depSymbolTables, (File)sourceOut, (boolean)false);
    }
}

