/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ClassNamingForMapApplier
implements ClassNaming {
    private final String originalName;
    final String renamedName;
    private final ImmutableMap<MemberNaming.MethodSignature, MemberNaming> methodMembers;
    private final ImmutableMap<MemberNaming.FieldSignature, MemberNaming> fieldMembers;

    static Builder builder(String renamedName, String originalName) {
        return new Builder(renamedName, originalName);
    }

    ClassNamingForMapApplier(ClassNamingForMapApplier proxy) {
        this(proxy.renamedName, proxy.originalName, proxy.methodMembers, proxy.fieldMembers);
    }

    private ClassNamingForMapApplier(String renamedName, String originalName, Map<MemberNaming.MethodSignature, MemberNaming> methodMembers, Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers) {
        this.renamedName = renamedName;
        this.originalName = originalName;
        this.methodMembers = ImmutableMap.copyOf(methodMembers);
        this.fieldMembers = ImmutableMap.copyOf(fieldMembers);
    }

    @Override
    public <T extends Throwable> void forAllMemberNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        this.forAllFieldNaming(consumer);
        this.forAllMethodNaming(consumer);
    }

    @Override
    public <T extends Throwable> void forAllFieldNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.fieldMembers.values()) {
            consumer.accept(naming);
        }
    }

    @Override
    public <T extends Throwable> void forAllMethodNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.methodMembers.values()) {
            consumer.accept(naming);
        }
    }

    @Override
    public MemberNaming lookup(MemberNaming.Signature renamedSignature) {
        if (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            for (MemberNaming memberNaming : this.methodMembers.values()) {
                if (!memberNaming.getRenamedSignature().equals(renamedSignature)) continue;
                return memberNaming;
            }
            return null;
        }
        assert (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        for (MemberNaming memberNaming : this.fieldMembers.values()) {
            if (!memberNaming.getRenamedSignature().equals(renamedSignature)) continue;
            return memberNaming;
        }
        return null;
    }

    @Override
    public MemberNaming lookupByOriginalSignature(MemberNaming.Signature original) {
        if (original.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            return this.methodMembers.get(original);
        }
        assert (original.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        return this.fieldMembers.get(original);
    }

    MemberNaming lookupByOriginalItem(DexField field) {
        for (Map.Entry entry : this.fieldMembers.entrySet()) {
            MemberNaming.FieldSignature signature = (MemberNaming.FieldSignature)entry.getKey();
            if (!signature.name.equals(field.name.toString()) || !signature.type.equals(field.type.getName())) continue;
            return (MemberNaming)entry.getValue();
        }
        return null;
    }

    protected MemberNaming lookupByOriginalItem(DexMethod method) {
        for (Map.Entry entry : this.methodMembers.entrySet()) {
            MemberNaming.MethodSignature signature = (MemberNaming.MethodSignature)entry.getKey();
            if (!signature.name.equals(method.name.toString()) || !signature.type.equals(method.proto.returnType.toString()) || !Arrays.equals(signature.parameters, Arrays.stream(method.proto.parameters.values).map(DexType::toString).toArray(String[]::new))) continue;
            return (MemberNaming)entry.getValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassNamingForMapApplier)) {
            return false;
        }
        ClassNamingForMapApplier that = (ClassNamingForMapApplier)o;
        return this.originalName.equals(that.originalName) && this.renamedName.equals(that.renamedName) && this.methodMembers.equals(that.methodMembers) && this.fieldMembers.equals(that.fieldMembers);
    }

    public int hashCode() {
        int result = this.originalName.hashCode();
        result = 31 * result + this.renamedName.hashCode();
        result = 31 * result + this.methodMembers.hashCode();
        result = 31 * result + this.fieldMembers.hashCode();
        return result;
    }

    public static class Builder
    extends ClassNaming.Builder {
        private final String originalName;
        private final String renamedName;
        private final Map<MemberNaming.MethodSignature, MemberNaming> methodMembers = new HashMap<MemberNaming.MethodSignature, MemberNaming>();
        private final Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers = new HashMap<MemberNaming.FieldSignature, MemberNaming>();

        private Builder(String renamedName, String originalName) {
            this.originalName = originalName;
            this.renamedName = renamedName;
        }

        @Override
        ClassNaming.Builder addMemberEntry(MemberNaming entry) {
            if (entry.isMethodNaming()) {
                this.methodMembers.put((MemberNaming.MethodSignature)entry.getOriginalSignature(), entry);
            } else {
                this.fieldMembers.put((MemberNaming.FieldSignature)entry.getOriginalSignature(), entry);
            }
            return this;
        }

        @Override
        ClassNamingForMapApplier build() {
            return new ClassNamingForMapApplier(this.renamedName, this.originalName, this.methodMembers, this.fieldMembers);
        }
    }
}

