/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.desugaring;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class TypeDependencies {
    private final Map<String, Set<String>> typeToDependencies = Maps.newHashMap();
    private final Map<String, Set<String>> typeToDependents = Maps.newHashMap();
    boolean isReverseMappingValid = false;

    TypeDependencies() {
    }

    void add(String dependent, Set<String> dependencies) {
        Set myDependencies = this.typeToDependencies.getOrDefault(dependent, new HashSet());
        myDependencies.addAll(dependencies);
        this.typeToDependencies.put(dependent, myDependencies);
        this.invalidateReverseMapping();
    }

    Set<String> getDependencies(String type) {
        return this.typeToDependencies.getOrDefault(type, (Set<String>)ImmutableSet.of());
    }

    Set<String> getDependents(String type) {
        return this.reverseMapping().getOrDefault(type, (Set<String>)ImmutableSet.of());
    }

    Set<String> getAllDependents(String type) {
        HashSet children = Sets.newHashSet();
        ArrayDeque<String> dequeue = new ArrayDeque<String>();
        dequeue.add(type);
        while (!dequeue.isEmpty()) {
            String current = (String)dequeue.removeFirst();
            Set<String> dependents = this.getDependents(current);
            for (String dep : dependents) {
                if (!children.add(dep)) continue;
                dequeue.addLast(dep);
            }
        }
        return children;
    }

    private void invalidateReverseMapping() {
        this.isReverseMappingValid = false;
    }

    private Map<String, Set<String>> reverseMapping() {
        if (this.isReverseMappingValid) {
            return this.typeToDependents;
        }
        this.typeToDependents.clear();
        for (Map.Entry<String, Set<String>> typeToDeps : this.typeToDependencies.entrySet()) {
            for (String dependency : typeToDeps.getValue()) {
                Set<String> myDependents = this.typeToDependents.getOrDefault(dependency, Sets.newHashSet());
                myDependents.add(typeToDeps.getKey());
                this.typeToDependents.put(dependency, myDependents);
            }
        }
        this.isReverseMappingValid = true;
        return this.typeToDependents;
    }

    void remove(String removedType) {
        this.typeToDependencies.remove(removedType);
        this.invalidateReverseMapping();
    }
}

