/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveClassFileProvider
implements ClassFileResourceProvider,
Closeable {
    private final Origin origin;
    private final Set<String> descriptors = new HashSet<String>();
    private final ZipFile zipFile;

    public static ClassFileResourceProvider fromArchive(FilteredClassPath archive) throws IOException {
        return new ArchiveClassFileProvider(archive);
    }

    protected ArchiveClassFileProvider(Path archive) throws IOException {
        this(FilteredClassPath.unfiltered(archive));
    }

    private ArchiveClassFileProvider(FilteredClassPath archive) throws IOException {
        assert (FileUtils.isArchive(archive.getPath()));
        this.origin = new PathOrigin(archive.getPath());
        try {
            this.zipFile = new ZipFile(archive.getPath().toFile());
        }
        catch (IOException e) {
            if (!Files.exists(archive.getPath(), new LinkOption[0])) {
                throw new NoSuchFileException(archive.getPath().toString());
            }
            throw e;
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            Path entryPath = Paths.get(name, new String[0]);
            if (!FileUtils.isClassFile(entryPath) || !archive.matchesFile(entryPath)) continue;
            this.descriptors.add(DescriptorUtils.guessTypeDescriptor(name));
        }
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.descriptors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Resource getResource(String descriptor) {
        if (!this.descriptors.contains(descriptor)) {
            return null;
        }
        ZipEntry zipEntry = this.getZipEntryFromDescriptor(descriptor);
        try (InputStream inputStream = this.zipFile.getInputStream(zipEntry);){
            Resource resource = Resource.fromBytes(new ArchiveEntryOrigin(zipEntry.getName(), this.origin), ByteStreams.toByteArray(inputStream), Collections.singleton(descriptor));
            return resource;
        }
        catch (IOException e) {
            throw new CompilationError("Failed to read '" + descriptor + "' from '" + this.zipFile.getName() + "'");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String toString() {
        return this.descriptors.size() + " resources from '" + this.zipFile.getName() + "'";
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    private ZipEntry getZipEntryFromDescriptor(String descriptor) {
        return this.zipFile.getEntry(descriptor.substring(1, descriptor.length() - 1) + ".class");
    }
}

