/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationResult;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.D8Output;
import com.android.tools.r8.OutputSink;
import com.android.tools.r8.R8;
import com.android.tools.r8.Version;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AndroidAppOutputSink;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.VersionProperties;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class D8 {
    private static final int STATUS_ERROR = 1;

    private D8() {
    }

    public static D8Output run(D8Command command) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(command.getInternalOptions());
        try {
            D8Output d8Output = D8.run(command, executor);
            return d8Output;
        }
        finally {
            executor.shutdown();
        }
    }

    public static D8Output run(D8Command command, ExecutorService executor) throws CompilationFailedException {
        try {
            try {
                InternalOptions options = command.getInternalOptions();
                AndroidAppOutputSink compatSink = new AndroidAppOutputSink(command.getOutputSink());
                CompilationResult result = D8.run(command.getInputApp(), compatSink, options, executor);
                assert (result != null);
                D8Output d8Output = new D8Output(compatSink.build(), command.getOutputMode());
                command.getReporter().failIfPendingErrors();
                return d8Output;
            }
            catch (IOException io) {
                throw command.getReporter().fatalError(new IOExceptionDiagnostic(io));
            }
            catch (CompilationException e) {
                throw command.getReporter().fatalError(new StringDiagnostic(e.getMessageForD8()));
            }
        }
        catch (AbortException e) {
            throw new CompilationFailedException(e);
        }
    }

    private static void run(String[] args) throws IOException, CompilationException, CompilationFailedException {
        D8Command command;
        D8Command.Builder builder = D8Command.parse(args, CommandLineOrigin.INSTANCE);
        if (builder.getOutputPath() == null) {
            builder.setOutputPath(Paths.get(".", new String[0]));
        }
        if ((command = (D8Command)builder.build()).isPrintHelp()) {
            System.out.println(D8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            Version.printToolVersion("D8");
            return;
        }
        D8.runForTesting(command.getInputApp(), command.getOutputSink(), command.getInternalOptions());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(D8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        try {
            D8.run(args);
        }
        catch (NoSuchFileException e) {
            System.err.println("File not found: " + e.getFile());
            System.exit(1);
        }
        catch (FileAlreadyExistsException e) {
            System.err.println("File already exists: " + e.getFile());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Failed to read or write application files: " + e.getMessage());
            System.exit(1);
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
        catch (CompilationException e) {
            System.err.println("Compilation failed: " + e.getMessageForD8());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompilationResult runForTesting(AndroidApp inputApp, OutputSink outputSink, InternalOptions options) throws IOException, CompilationException {
        ExecutorService executor = ThreadUtils.getExecutorService(-1);
        try {
            CompilationResult compilationResult = D8.run(inputApp, outputSink, options, executor);
            return compilationResult;
        }
        finally {
            executor.shutdown();
        }
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        Marker marker = new Marker(Marker.Tool.D8).setVersion("v0.2.2-dev").setMinApi(options.minApiLevel);
        if (Version.isDev()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        return marker;
    }

    private static CompilationResult run(AndroidApp inputApp, OutputSink outputSink, InternalOptions options, ExecutorService executor) throws IOException, CompilationException {
        try {
            options.skipMinification = true;
            options.inlineAccessors = false;
            options.outline.enabled = false;
            Timing timing = new Timing("DX timer");
            DexApplication app = new ApplicationReader(inputApp, options, timing).read(executor);
            AppInfo appInfo = new AppInfo(app);
            app = D8.optimize(app, appInfo, options, timing, executor);
            if (options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                CompilationResult compilationResult = null;
                return compilationResult;
            }
            Marker marker = D8.getMarker(options);
            new ApplicationWriter(app, options, marker, null, NamingLens.getIdentityLens(), null, null).write(outputSink, executor);
            CompilationResult output = new CompilationResult(outputSink, app, appInfo);
            options.printWarnings();
            CompilationResult compilationResult = output;
            return compilationResult;
        }
        catch (ExecutionException e) {
            R8.unwrapExecutionException(e);
            throw new AssertionError((Object)e);
        }
        finally {
            outputSink.close();
        }
    }

    private static DexApplication optimize(DexApplication application, AppInfo appInfo, InternalOptions options, Timing timing, ExecutorService executor) throws IOException, ExecutionException, ApiLevelException {
        CfgPrinter printer = options.printCfg ? new CfgPrinter() : null;
        IRConverter converter = new IRConverter(appInfo, options, timing, printer);
        application = converter.convertToDex(application, executor);
        if (options.printCfg) {
            if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
                System.out.print(printer.toString());
            } else {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);){
                    writer.write(printer.toString());
                }
            }
        }
        return application;
    }
}

